<?php
add_action( 'wp_enqueue_scripts', 'my_theme_enqueue_styles' );
function my_theme_enqueue_styles() {
 
    $parent_style = 'parent-style'; // This is 'Movedo-style' for the Movedo theme.
 
    wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );
    wp_enqueue_style( 'child-style',
        get_stylesheet_directory_uri() . '/style.css',
        array( $parent_style ),
        wp_get_theme()->get('Version')
    );
}

function exclude_specific_tag( $q ) {
    if (is_shop()){
        $tax_query = (array) $q->get( 'tax_query' );
        $tax_query[] = array(
            'taxonomy' => 'product_tag',
            'field' => 'slug',
            'terms' => array( 'groupon' ), // write the tag name to remove in between the ''
            'operator' => 'NOT IN'
        );
        $q->set( 'tax_query', $tax_query );
    }
}
add_action( 'woocommerce_product_query', 'exclude_specific_tag' );
?>