<?php
/**
*	Theme Options Config File
*	@version	1.0
*
* 	@author		Greatives Team
* 	@URI		http://greatives.eu
*/

if ( !class_exists( "ReduxFramework" ) ) {
	return;
}

if (!class_exists("Movedo_GRVE_Redux_Framework_config")) {

	class Movedo_GRVE_Redux_Framework_config {

		public $args = array();
		public $sections = array();
		public $theme;
		public $ReduxFramework;

		public function __construct() {
			// Set the default arguments
			$this->setArguments();

			// Create the sections and fields
			$this->setSections();

			// No errors please
			if ( !isset( $this->args['opt_name'] ) ) {
				return;
			}
			$this->ReduxFramework = new ReduxFramework($this->sections, $this->args);
		}

		public function movedo_grve_redux_customizer_visibility() {
			$visibility = apply_filters( 'movedo_grve_redux_customizer_visibility', false );
			return $visibility;
		}

		public function setSections() {

			/**
			 * Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
			 * */
			global $movedo_grve_social_list, $movedo_grve_button_type_selection, $movedo_grve_button_shape_selection, $movedo_grve_button_color_selection, $movedo_grve_area_height;

			//Gravity Forms
			$movedo_grve_gravity_options = array();
			if ( class_exists( 'RGFormsModel' ) ) {
				$gravity_forms = RGFormsModel::get_forms( 1, 'title' );
				if ( $gravity_forms ) {
					$movedo_grve_gravity_options = array( esc_html__( 'Select a form to display.', 'movedo' ) => '' );
					foreach ( $gravity_forms as $gravity_form ) {
						$movedo_grve_gravity_options[ $gravity_form->id ] = $gravity_form->title;
					}
				}
			}

			$movedo_grve_social_options = $movedo_grve_social_list;

			$movedo_grve_portfolio_social_options = array(
				'email' => esc_html__( 'E-mail', 'movedo' ),
				'twitter' => 'Twitter',
				'facebook' => 'Facebook',
				'linkedin' => 'LinkedIn',
				'google-plus' => 'Google Plus',
				'pinterest' => 'Pinterest',
				'reddit' => 'reddit',
				'tumblr' => 'Tumblr',
				'grve-likes' => '(Greatives) Likes',
			);

			$movedo_grve_portfolio_term_selection = array(
				'none' => esc_html__( 'None', 'movedo' ),
				'portfolio_category' => esc_html__( 'Portfolio Category', 'movedo' ),
				'portfolio_field' => esc_html__( 'Portfolio Field', 'movedo' ),
			);

			$movedo_grve_post_social_options = array(
				'email' => esc_html__( 'E-mail', 'movedo' ),
				'twitter' => 'Twitter',
				'facebook' => 'Facebook',
				'linkedin' => 'LinkedIn',
				'google-plus' => 'Google Plus',
				'reddit' => 'reddit',
				'tumblr' => 'Tumblr',
				'grve-likes' => '(Greatives) Likes',
			);

			$movedo_grve_product_social_options = array(
				'email' => esc_html__( 'E-mail', 'movedo' ),
				'twitter' => 'Twitter',
				'facebook' => 'Facebook',
				'linkedin' => 'LinkedIn',
				'google-plus' => 'Google Plus',
				'reddit' => 'reddit',
				'tumblr' => 'Tumblr',
				'grve-likes' => '(Greatives) Likes',
			);

			$movedo_grve_event_social_options = array(
				'email' => esc_html__( 'E-mail', 'movedo' ),
				'twitter' => 'Twitter',
				'facebook' => 'Facebook',
				'linkedin' => 'LinkedIn',
				'google-plus' => 'Google Plus',
				'reddit' => 'reddit',
				'tumblr' => 'Tumblr',
				'grve-likes' => '(Greatives) Likes',
			);

			$movedo_grve_event_mode_selection = array(
				'small' => esc_html__( 'Small Media', 'movedo' ),
				'grid' => esc_html__( 'Grid' , 'movedo' ),
			);

			$movedo_grve_blog_mode_selection = array(
				'large' => esc_html__( 'Large Media', 'movedo' ),
				'small' => esc_html__( 'Small Media', 'movedo' ),
				'masonry' => esc_html__( 'Masonry' , 'movedo' ),
				'grid' => esc_html__( 'Grid' , 'movedo' ),
			);

			$movedo_grve_blog_image_mode_selection = array(
				'landscape-large-wide' => esc_html__( 'Landscape Large Wide Crop', 'movedo' ),
				'landscape-medium' => esc_html__( 'Landscape Medium Crop', 'movedo' ),
				'large' => esc_html__( 'Resize ( Large )', 'movedo' ),
				'medium_large' => esc_html__( 'Resize ( Medium Large )', 'movedo' ),
				'medium' => esc_html__( 'Resize ( Medium )', 'movedo' ),
			);

			$movedo_grve_blog_grid_image_mode_selection = array(
				'square' => esc_html__( 'Square Small Crop', 'movedo' ),
				'landscape' => esc_html__( 'Landscape Small Crop', 'movedo' ),
				'portrait' => esc_html__( 'Portrait Small Crop', 'movedo' ),
				'medium_large' => esc_html__( 'Resize ( Medium Large )', 'movedo' ),
				'medium' => esc_html__( 'Resize ( Medium )', 'movedo' ),
			);

			$movedo_grve_blog_masonry_image_mode_selection = array(
				'large' => esc_html__( 'Resize ( Large )', 'movedo' ),
				'medium_large' => esc_html__( 'Resize ( Medium Large )', 'movedo' ),
				'medium' => esc_html__( 'Resize ( Medium )', 'movedo' ),
			);

			$movedo_grve_search_grid_image_mode_selection = array(
				'square' => esc_html__( 'Square Small Crop', 'movedo' ),
				'landscape' => esc_html__( 'Landscape Small Crop', 'movedo' ),
				'portrait' => esc_html__( 'Portrait Small Crop', 'movedo' ),
				'medium_large' => esc_html__( 'Resize ( Medium Large )', 'movedo' ),
				'medium' => esc_html__( 'Resize ( Medium )', 'movedo' ),
			);

			$movedo_grve_search_masonry_image_mode_selection = array(
				'large' => esc_html__( 'Resize ( Large )', 'movedo' ),
				'medium_large' => esc_html__( 'Resize ( Medium Large )', 'movedo' ),
				'medium' => esc_html__( 'Resize ( Medium )', 'movedo' ),
			);

			$movedo_grve_blog_columns_selection = array(
				'2' => '2',
				'3' => '3',
				'4' => '4',
				'5' => '5',
			);
			$movedo_grve_blog_columns_selection_tablet = array(
				'2' => '2',
				'3' => '3',
				'4' => '4',
			);
			$movedo_grve_blog_columns_selection_mobile = array(
				'1' => '1',
				'2' => '2',
			);

			$movedo_grve_headings_tag_selection = array(
				'h1'  => 'h1',
				'h2'  => 'h2',
				'h3'  => 'h3',
				'h4'  => 'h4',
				'h5'  => 'h5',
				'h6'  => 'h6',
				'div'  => 'div',
			);

			$movedo_grve_blog_headings_tag_selection = array(
				'auto' => esc_html__( 'Auto', 'movedo' ),
				'h2'  => 'h2',
				'h3'  => 'h3',
				'h4'  => 'h4',
				'h5'  => 'h5',
				'h6'  => 'h6',
				'div'  => 'div',
			);

			$movedo_grve_blog_headings_selection = array(
				'auto' => esc_html__( 'Auto', 'movedo' ),
				'h2'  => 'h2',
				'h3'  => 'h3',
				'h4'  => 'h4',
				'h5'  => 'h5',
				'h6'  => 'h6',
				'leader-text' => esc_html__( 'Leader Text', 'movedo' ),
				'subtitle-text' => esc_html__( 'Subtitle Text', 'movedo' ),
				'small-text' => esc_html__( 'Small Text', 'movedo' ),
				'link-text' => esc_html__( 'Link Text', 'movedo' ),
			);

			$movedo_grve_event_headings_selection = array(
				'h2'  => 'h2',
				'h3'  => 'h3',
				'h4'  => 'h4',
				'h5'  => 'h5',
				'h6'  => 'h6',
			);

			$movedo_grve_theme_layout_selection = array(
				'stretched' => esc_html__( 'Stretched', 'movedo' ),
				'boxed' => esc_html__( 'Boxed', 'movedo' ),
				'framed' => esc_html__( 'Framed', 'movedo' ),
			);

			$movedo_grve_layout_selection = array(
				'none' => array('alt' => esc_html__( 'Full Width', 'movedo' ), 'img' => ReduxFramework::$_url . 'assets/img/1col.png'),
				'left' => array('alt' => esc_html__( 'Left Sidebar', 'movedo' ), 'img' => ReduxFramework::$_url . 'assets/img/2cl.png'),
				'right' => array('alt' => esc_html__( 'Right Sidebar', 'movedo' ), 'img' => ReduxFramework::$_url . 'assets/img/2cr.png'),
			);

			$movedo_grve_align_selection = array(
				'left' => esc_html__( 'Left', 'movedo' ),
				'right' => esc_html__( 'Right', 'movedo' ),
			);

			$movedo_grve_align_selection_extra = array(
				'left' => esc_html__( 'Left', 'movedo' ),
				'center' => esc_html__( 'Center', 'movedo' ),
				'right' => esc_html__( 'Right', 'movedo' ),
			);

			$movedo_grve_align_selection_full = array(
				'left-top' => esc_html__( 'Left Top', 'movedo' ),
				'left-center' => esc_html__( 'Left Center', 'movedo' ),
				'left-bottom' => esc_html__( 'Left Bottom', 'movedo' ),
				'center-top' => esc_html__( 'Center Top', 'movedo' ),
				'center-center' => esc_html__( 'Center Center', 'movedo' ),
				'center-bottom' => esc_html__( 'Center Bottom', 'movedo' ),
				'right-top' => esc_html__( 'Right Top', 'movedo' ),
				'right-center' => esc_html__( 'Right Center', 'movedo' ),
				'right-bottom' => esc_html__( 'Right Bottom', 'movedo' ),
			);

			$movedo_grve_animation_selection = array(
				'fade-in' => esc_html__( 'Default', 'movedo' ),
				'none' => esc_html__( 'None', 'movedo' ),
				'fade-in-up' => esc_html__( 'Fade In Up', 'movedo' ),
				'fade-in-down' => esc_html__( 'Fade In Down', 'movedo' ),
				'fade-in-left' => esc_html__( 'Fade In Left', 'movedo' ),
				'fade-in-right' => esc_html__( 'Fade In Right', 'movedo' ),
				'zoom-in' => esc_html__( 'Zoom In', 'movedo' ),
				'zoom-out' => esc_html__( 'Zoom Out', 'movedo' ),
			);

			$movedo_grve_title_bg_mode = array(
				'color' => esc_html__( 'Color Only', 'movedo' ),
				'featured' => esc_html__( 'Featured Image', 'movedo' ),
				'custom' => esc_html__( 'Custom Image', 'movedo' ),
			);

			$movedo_grve_title_bg_mode_limited = array(
				'color' => esc_html__( 'Color Only', 'movedo' ),
				'custom' => esc_html__( 'Custom Image', 'movedo' ),

			);

			$movedo_grve_background_type = array(
				'transparent' => esc_html__( 'None', 'movedo' ),
				'colored' => esc_html__( 'Background', 'movedo' ),
				'advanced' => esc_html__( 'Stretched Background', 'movedo' ),
			);

			$movedo_grve_header_menu_options = array(
				'search' => esc_html__( 'Search', 'movedo' ),
				'form' => esc_html__( 'Contact Form (Contact Form 7 or Gravity Forms Required)', 'movedo' ),
				'language' => esc_html__( 'Language selector (WPML or Polylang Required)', 'movedo' ),
				'login' => esc_html__( 'Login', 'movedo' ),
				'cart' => esc_html__( 'Shopping Cart (WooCommerce Required)', 'movedo' ),
				'social' => esc_html__( 'Social Icons', 'movedo' ),
			);
			$movedo_grve_header_menu_options_default = array(
				'search' => false,
				'form' => false,
				'language' => false,
				'login' => false,
				'cart' => false,
				'social' => false,
			);

			$movedo_grve_header_menu_selection = array(
				'default' => esc_html__( 'Default', 'movedo' ),
				'disabled' => esc_html__( 'Disabled', 'movedo' ),
			);

			$movedo_grve_top_bar_options = array(
				'menu' => esc_html__( 'Menu (Assigned: Menus - Manage Locations)', 'movedo' ),
				'text' => esc_html__( 'Text', 'movedo' ),
				'search' => esc_html__( 'Search', 'movedo' ),
				'language' => esc_html__( 'Language selector (WPML or Polylang Required)', 'movedo' ),
				'form' => esc_html__( 'Contact Form (Contact Form 7 or Gravity Forms Required)', 'movedo' ),
				'login' => esc_html__( 'Login', 'movedo' ),
				'social' => esc_html__( 'Social Icons', 'movedo' ),
			);
			$movedo_grve_top_bar_options_default = array(
				'menu' => false,
				'text' => false,
				'search' => false,
				'language' => false,
				'form' => false,
				'login' => false,
				'social' => false,
			);

			$movedo_grve_menu_animations = array(
				'none' => esc_html__( 'None', 'movedo' ),
				'fade-in' => esc_html__( 'Fade in', 'movedo' ),
				'fade-in-up' => esc_html__( 'Fade in Up', 'movedo' ),
				'fade-in-down' => esc_html__( 'Fade in Down', 'movedo' ),
				'fade-in-left' => esc_html__( 'Fade in Left', 'movedo' ),
				'fade-in-right' => esc_html__( 'Fade in Right', 'movedo' ),
			);
			$movedo_grve_menu_pointers = array(
				'none' => esc_html__( 'None', 'movedo' ),
				'arrow' => esc_html__( 'Arrow', 'movedo' ),
				'arrow-not-first-level' => esc_html__( 'Arrow (exclude first level items)', 'movedo' ),
			);

			$movedo_grve_color_selection = array(
				'dark' => esc_html__( 'Dark', 'movedo' ),
				'light' => esc_html__( 'Light', 'movedo' ),
				'primary-1' => esc_html__( 'Primary 1', 'movedo' ),
				'primary-2' => esc_html__( 'Primary 2', 'movedo' ),
				'primary-3' => esc_html__( 'Primary 3', 'movedo' ),
				'primary-4' => esc_html__( 'Primary 4', 'movedo' ),
				'primary-5' => esc_html__( 'Primary 5', 'movedo' ),
				'primary-6' => esc_html__( 'Primary 6', 'movedo' ),
			);
			$movedo_grve_color_selection_extra = array(
				'dark' => esc_html__( 'Dark', 'movedo' ),
				'light' => esc_html__( 'Light', 'movedo' ),
				'primary-1' => esc_html__( 'Primary 1', 'movedo' ),
				'primary-2' => esc_html__( 'Primary 2', 'movedo' ),
				'primary-3' => esc_html__( 'Primary 3', 'movedo' ),
				'primary-4' => esc_html__( 'Primary 4', 'movedo' ),
				'primary-5' => esc_html__( 'Primary 5', 'movedo' ),
				'primary-6' => esc_html__( 'Primary 6', 'movedo' ),
				'custom' => esc_html__( 'Custom', 'movedo' ),
			);

			$movedo_grve_bg_color_selection = array(
				'none' => esc_html__( 'None', 'movedo' ),
				'dark' => esc_html__( 'Dark', 'movedo' ),
				'light' => esc_html__( 'Light', 'movedo' ),
				'primary-1' => esc_html__( 'Primary 1', 'movedo' ),
				'primary-2' => esc_html__( 'Primary 2', 'movedo' ),
				'primary-3' => esc_html__( 'Primary 3', 'movedo' ),
				'primary-4' => esc_html__( 'Primary 4', 'movedo' ),
				'primary-5' => esc_html__( 'Primary 5', 'movedo' ),
				'primary-6' => esc_html__( 'Primary 6', 'movedo' ),
			);

			$movedo_grve_bg_color_selection_extra = array(
				'none' => esc_html__( 'None', 'movedo' ),
				'dark' => esc_html__( 'Dark', 'movedo' ),
				'light' => esc_html__( 'Light', 'movedo' ),
				'primary-1' => esc_html__( 'Primary 1', 'movedo' ),
				'primary-2' => esc_html__( 'Primary 2', 'movedo' ),
				'primary-3' => esc_html__( 'Primary 3', 'movedo' ),
				'primary-4' => esc_html__( 'Primary 4', 'movedo' ),
				'primary-5' => esc_html__( 'Primary 5', 'movedo' ),
				'primary-6' => esc_html__( 'Primary 6', 'movedo' ),
				'custom' => esc_html__( 'Custom', 'movedo' ),
			);

			$movedo_grve_header_mode_selection = array(
				'default' => array('alt' => esc_html__( 'Default', 'movedo' ), 'img' => get_template_directory_uri() . '/includes/images/header/header-mode-default.png' ),
				'logo-top' => array('alt' => esc_html__( 'Logo on Top', 'movedo' ), 'img' => get_template_directory_uri() . '/includes/images/header/header-mode-logo-top.png' ),
				'side' => array('alt' => esc_html__( 'Side', 'movedo' ), 'img' => get_template_directory_uri() . '/includes/images/header/header-mode-side.png' ),
			);
			$movedo_grve_header_menu_mode_selection = array(
				'default' => array('alt' => esc_html__( 'Default', 'movedo' ), 'img' => get_template_directory_uri() . '/includes/images/menu/default-menu.png' ),
				'split' => array('alt' => esc_html__( 'Split', 'movedo' ), 'img' => get_template_directory_uri() . '/includes/images/menu/split-menu.png' ),
			);

			$movedo_grve_header_style = array(
				'default' => esc_html__( 'Default', 'movedo' ),
				'dark' => esc_html__( 'Dark', 'movedo' ),
				'light' => esc_html__( 'Light', 'movedo' ),
			);

			$movedo_grve_title_style = array(
				'advanced' => esc_html__( 'Advanced Title', 'movedo' ),
				'simple' => esc_html__( 'Simple Title', 'movedo' ),
			);

			$movedo_grve_enable_selection = array(
				'no' => esc_html__( 'No', 'movedo' ),
				'yes' => esc_html__( 'Yes', 'movedo' ),
			);

			$movedo_grve_menu_responsibe_style_selection = array(
				'1' => esc_html__( 'Style 1', 'movedo' ),
				'2' => esc_html__( 'Style 2', 'movedo' ),
			);

			$movedo_grve_menu_responsibe_toggle_selection = array(
				'icon' => esc_html__( 'Icon', 'movedo' ),
				'text' => esc_html__( 'Text', 'movedo' ),
			);

			$movedo_grve_footer_column_selection = array(
				'footer-1' => array('alt' => esc_html__( 'Footer 1', 'movedo' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-1.png' ),
				'footer-2' => array('alt' => esc_html__( 'Footer 2', 'movedo' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-2.png' ),
				'footer-3' => array('alt' => esc_html__( 'Footer 3', 'movedo' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-3.png' ),
				'footer-4' => array('alt' => esc_html__( 'Footer 4', 'movedo' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-4.png' ),
				'footer-5' => array('alt' => esc_html__( 'Footer 5', 'movedo' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-5.png' ),
				'footer-6' => array('alt' => esc_html__( 'Footer 6', 'movedo' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-6.png' ),
				'footer-7' => array('alt' => esc_html__( 'Footer 7', 'movedo' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-7.png' ),
				'footer-8' => array('alt' => esc_html__( 'Footer 8', 'movedo' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-8.png' ),
				'footer-9' => array('alt' => esc_html__( 'Footer 9', 'movedo' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-9.png' ),
			);


			$movedo_grve_opacity_selection_simple = array(
				'0'  => '0%',
				'10' => '10%',
				'20' => '20%',
				'30' => '30%',
				'40' => '40%',
				'50' => '50%',
				'60' => '60%',
				'70' => '70%',
				'80' => '80%',
				'90' => '90%',
				'100'=> '100%',
			);

			$movedo_grve_opacity_selection = array(
				'0'    => '0%',
				'0.05' => '5%',
				'0.10' => '10%',
				'0.15' => '15%',
				'0.20' => '20%',
				'0.25' => '25%',
				'0.30' => '30%',
				'0.35' => '35%',
				'0.40' => '40%',
				'0.45' => '45%',
				'0.50' => '50%',
				'0.55' => '55%',
				'0.60' => '60%',
				'0.65' => '65%',
				'0.70' => '70%',
				'0.75' => '75%',
				'0.80' => '80%',
				'0.85' => '85%',
				'0.90' => '90%',
				'0.95' => '95%',
				'1'    => '100%',
			);
			$movedo_grve_ratio_selection = array(
				'0'    => '0%',
				'0.05' => '5%',
				'0.1'  => '10%',
				'0.15' => '15%',
				'0.2'  => '20%',
				'0.25' => '25%',
				'0.3'  => '30%',
				'0.35' => '35%',
				'0.4'  => '40%',
				'0.45' => '45%',
				'0.5'  => '50%',
				'0.55' => '55%',
				'0.6'  => '60%',
				'0.65' => '65%',
				'0.7'  => '70%',
				'0.75' => '75%',
				'0.8'  => '80%',
				'0.85'  => '85%',
				'0.9'  => '90%',
				'0.95' => '95%',
				'1'    => '100%',
			);

			$movedo_grve_headings_selection = array(
				'h2'  => 'h2',
				'h3'  => 'h3',
				'h4'  => 'h4',
				'h5'  => 'h5',
				'h6'  => 'h6',
				'leader-text' => esc_html__( 'Leader Text', 'movedo' ),
				'subtitle-text' => esc_html__( 'Subtitle Text', 'movedo' ),
				'small-text' => esc_html__( 'Small Text', 'movedo' ),
				'link-text' => esc_html__( 'Link Text', 'movedo' ),
			);

			$movedo_grve_pattern_selection = array(
				'none' => esc_html__( 'No', 'movedo' ),
				'default' => esc_html__( 'Yes', 'movedo' ),
			);

			$movedo_grve_padding_selection = array(
				'none' => esc_html__( 'None', 'movedo' ),
				'1x' => esc_html__( '1x', 'movedo' ),
				'2x' => esc_html__( '2x', 'movedo' ),
				'3x' => esc_html__( '3x', 'movedo' ),
				'4x' => esc_html__( '4x', 'movedo' ),
				'5x' => esc_html__( '5x', 'movedo' ),
				'6x' => esc_html__( '6x', 'movedo' ),
			);
			$movedo_grve_padding_selection_extra = array(
				'none' => esc_html__( 'None', 'movedo' ),
				'1x' => esc_html__( '1x', 'movedo' ),
				'2x' => esc_html__( '2x', 'movedo' ),
				'3x' => esc_html__( '3x', 'movedo' ),
				'4x' => esc_html__( '4x', 'movedo' ),
				'5x' => esc_html__( '5x', 'movedo' ),
				'6x' => esc_html__( '6x', 'movedo' ),
				'custom' => esc_html__( 'Custom', 'movedo' ),
			);

			$movedo_grve_content_size_selection = array(
				'large' => esc_html__( 'Large', 'movedo' ),
				'medium' => esc_html__( 'Medium', 'movedo' ),
				'small' => esc_html__( 'Small', 'movedo' ),
			);

			$movedo_grve_container_size_selection = array(
				'default' => esc_html__( 'Default', 'movedo' ),
				'large' => esc_html__( 'Large', 'movedo' ),
			);

			//Standard Fonts
			$movedo_grve_std_fonts = array(
				"Arial, Helvetica, sans-serif"                         => "Arial, Helvetica, sans-serif",
				"'Arial Black', Gadget, sans-serif"                    => "'Arial Black', Gadget, sans-serif",
				"'Bookman Old Style', serif"                           => "'Bookman Old Style', serif",
				"'Comic Sans MS', cursive"                             => "'Comic Sans MS', cursive",
				"Courier, monospace"                                   => "Courier, monospace",
				"Garamond, serif"                                      => "Garamond, serif",
				"Georgia, serif"                                       => "Georgia, serif",
				"Impact, Charcoal, sans-serif"                         => "Impact, Charcoal, sans-serif",
				"'Lucida Console', Monaco, monospace"                  => "'Lucida Console', Monaco, monospace",
				"'Lucida Sans Unicode', 'Lucida Grande', sans-serif"   => "'Lucida Sans Unicode', 'Lucida Grande', sans-serif",
				"'MS Sans Serif', Geneva, sans-serif"                  => "'MS Sans Serif', Geneva, sans-serif",
				"'MS Serif', 'New York', sans-serif"                   => "'MS Serif', 'New York', sans-serif",
				"'Palatino Linotype', 'Book Antiqua', Palatino, serif" => "'Palatino Linotype', 'Book Antiqua', Palatino, serif",
				"Tahoma,Geneva, sans-serif"                            => "Tahoma, Geneva, sans-serif",
				"'Times New Roman', Times,serif"                       => "'Times New Roman', Times, serif",
				"'Trebuchet MS', Helvetica, sans-serif"                => "'Trebuchet MS', Helvetica, sans-serif",
				"Verdana, Geneva, sans-serif"                          => "Verdana, Geneva, sans-serif",
			);
			$movedo_grve_std_fonts = apply_filters( 'movedo_grve_std_fonts', $movedo_grve_std_fonts );

			$movedo_grve_feature_section_post_types_selection = array(
				'page'   => esc_html__( 'Pages', 'movedo' ),
				'portfolio'   => esc_html__( 'Portfolio Items', 'movedo' ),
				'post'   => esc_html__( 'Posts', 'movedo' ),
				'product'   => esc_html__( 'Products', 'movedo' ),
				'tribe_events'   => esc_html__( 'Events', 'movedo' ),
			);

			$movedo_grve_container_size_selector = array(
				'container' => esc_html__( 'Container Size' , 'movedo' ),
				'1170' => esc_html__( 'Large' , 'movedo' ),
				'990' => esc_html__( 'Medium' , 'movedo' ),
				'770' => esc_html__( 'Small' , 'movedo' ),
			);

			//Skin Presets
			$movedo_grve_skin_palette_1 = '{"top_bar_bg_color":"#ffffff","top_bar_font_color":"#777777","top_bar_link_color":"#777777","top_bar_hover_color":"#0652FD","default_header_background_color":"#ffffff","default_header_background_color_opacity":"1","default_header_border_color":"#000000","default_header_border_color_opacity":"0.10","default_header_menu_text_color":"#000000","default_header_menu_text_hover_color":"#0652FD","default_header_menu_type_color":"#eef1f6","default_header_menu_type_color_hover":"#0652FD","default_header_submenu_bg_color":"#171a1d","default_header_submenu_text_color":"#777777","default_header_submenu_text_hover_color":"#ffffff","default_header_submenu_text_bg_hover_color":"#171a1d","default_header_submenu_column_text_color":"#ffffff","default_header_submenu_column_text_hover_color":"#ffffff","default_header_submenu_border_color":"#333638","logo_top_header_logo_area_background_color":"#ffffff","logo_top_header_logo_area_background_color_opacity":"1","logo_top_header_border_color":"#000000","logo_top_header_border_color_opacity":"0.10","logo_top_header_menu_area_background_color":"#ffffff","logo_top_header_menu_area_background_color_opacity":"1","logo_top_header_menu_text_color":"#000000","logo_top_header_menu_text_hover_color":"#0652FD","logo_top_header_menu_type_color":"#eef1f6","logo_top_header_menu_type_color_hover":"#0652FD","logo_top_header_submenu_bg_color":"#ffffff","logo_top_header_submenu_text_color":"#777777","logo_top_header_submenu_text_hover_color":"#0652FD","logo_top_header_submenu_text_bg_hover_color":"#ffffff","logo_top_header_submenu_column_text_color":"#000000","logo_top_header_submenu_column_text_hover_color":"#0652FD","logo_top_header_submenu_border_color":"#eef1f6","side_header_background_color":"#f7f7f7","side_header_background_color_opacity":"1","side_header_menu_text_color":"#000000","side_header_menu_text_hover_color":"#0652FD","side_header_submenu_text_color":"#000000","side_header_submenu_text_hover_color":"#0652FD","side_header_border_color":"#323232","side_header_border_opacity":"0.10","header_sticky_background_color":"#101215","header_sticky_background_color_opacity":"1","header_sticky_border_color":"#eef1f6","header_sticky_border_color_opacity":"0.30","sticky_menu_text_color":"#9c9c9c","sticky_menu_text_hover_color":"#ffffff","header_sticky_menu_type_color":"#eef1f6","header_sticky_menu_type_color_hover":"#eef1f6","light_menu_text_hover_color":"#ffffff","light_menu_type_color_hover":"#eef1f6","light_header_border_color":"#ffffff","light_header_border_color_opacity":"0.30","dark_menu_text_hover_color":"#000000","dark_menu_type_color_hover":"#eef1f6","dark_header_border_color":"#000000","dark_header_border_color_opacity":"0.10","responsive_header_background_color":"#000000","responsive_header_background_opacity":"1","responsive_header_elements_color":"#bfbfbf","responsive_header_elements_hover_color":"#ffffff","responsive_menu_background_color":"#ffffff","responsive_menu_link_color":"#777777","responsive_menu_link_hover_color":"#0652FD","responsive_menu_close_btn_color":"#777777","responsive_menu_border_color":"#eef1f6","responsive_menu_overflow_background_color":"#000000","responsive_menu_overflow_background_color_opacity":"0.90","page_anchor_menu_background_color":"#171a1d","page_anchor_menu_text_color":"#ffffff","page_anchor_menu_text_hover_color":"#0652FD","page_anchor_menu_background_hover_color":"#171a1d","page_anchor_menu_border_color":"#333638","main_content_background_color":"#ffffff","body_heading_color":"#000000","body_text_color":"#676767","body_text_link_color":"#000000","body_text_link_hover_color":"#0652FD","body_border_color":"#e9e9e9","widget_title_color":"#000000","body_primary_1_color":"#0652FD","body_primary_2_color":"#003a40","body_primary_3_color":"#487F84","body_primary_4_color":"#5F597E","body_primary_5_color":"#d6ccad","body_primary_6_color":"#db5111","blog_title_bg_color":"dark","blog_title_bg_color_custom":"#000000","blog_title_content_bg_color":"none","blog_title_content_bg_color_custom":"#ffffff","blog_title_color":"light","blog_title_color_custom":"#ffffff","blog_description_color":"light","blog_description_color_custom":"#ffffff","post_title_bg_color":"dark","post_title_bg_color_custom":"#000000","post_title_content_bg_color":"none","post_title_content_bg_color_custom":"#ffffff","post_subheading_color":"light","post_subheading_color_custom":"#ffffff","post_title_color":"light","post_title_color_custom":"#ffffff","post_description_color":"light","post_description_color_custom":"#ffffff","post_bar_background_color":"#ffffff","post_bar_socials_color":"#d3d3d3","post_bar_socials_color_hover":"#000000","post_bar_nav_title_color":"#000000","post_bar_arrow_color":"#d3d3d3","post_bar_border_color":"#e9e9e9","page_title_bg_color":"primary-2","page_title_bg_color_custom":"#000000","page_title_content_bg_color":"none","page_title_content_bg_color_custom":"#ffffff","page_title_color":"light","page_title_color_custom":"#ffffff","page_description_color":"light","page_description_color_custom":"#ffffff","search_page_title_bg_color":"dark","search_page_title_bg_color_custom":"#000000","search_page_title_content_bg_color":"none","search_page_title_content_bg_color_custom":"#ffffff","search_page_title_color":"light","search_page_title_color_custom":"#ffffff","search_page_description_color":"light","search_page_description_color_custom":"#ffffff","portfolio_title_bg_color":"dark","portfolio_title_bg_color_custom":"#000000","portfolio_title_content_bg_color":"none","portfolio_title_content_bg_color_custom":"#ffffff","portfolio_title_color":"light","portfolio_title_color_custom":"#ffffff","portfolio_description_color":"light","portfolio_description_color_custom":"#ffffff","portfolio_bar_background_color":"#ffffff","portfolio_bar_socials_color":"#d3d3d3","portfolio_bar_socials_color_hover":"#000000","portfolio_bar_nav_title_color":"#000000","portfolio_bar_arrow_color":"#d3d3d3","portfolio_bar_border_color":"#e9e9e9","product_tax_title_bg_color":"dark","product_tax_title_bg_color_custom":"#000000","product_tax_title_content_bg_color":"none","product_tax_title_content_bg_color_custom":"#ffffff","product_tax_title_color":"light","product_tax_title_color_custom":"#ffffff","product_tax_description_color":"light","product_tax_description_color_custom":"#ffffff","product_title_bg_color":"dark","product_title_bg_color_custom":"#000000","product_title_content_bg_color":"none","product_title_content_bg_color_custom":"#ffffff","product_title_color":"light","product_title_color_custom":"#ffffff","product_description_color":"light","product_description_color_custom":"#ffffff","product_area_bg_color":"#eeeeee","product_area_headings_color":"#000000","product_area_font_color":"#999999","product_area_link_color":"#FF7D88","product_area_hover_color":"#000000","product_area_border_color":"#e0e0e0","product_area_button_color":"primary-1","product_area_button_hover_color":"black","product_bar_background_color":"#ffffff","product_bar_socials_color":"#d3d3d3","product_bar_socials_color_hover":"#000000","product_bar_nav_title_color":"#000000","product_bar_arrow_color":"#d3d3d3","product_bar_border_color":"#e9e9e9","footer_widgets_bg_color":"#0D0F10","footer_widgets_headings_color":"#ffffff","footer_widgets_font_color":"#ffffff","footer_widgets_link_color":"#ffffff","footer_widgets_hover_color":"#909090","footer_widgets_border_color":"#3E3F3F","footer_bar_bg_color":"#0D0F10","footer_bar_bg_color_opacity":"1","footer_bar_font_color":"#ffffff","footer_bar_link_color":"#ffffff","footer_bar_hover_color":"#909090","page_breadcrumbs_background_color":"#ffffff","page_breadcrumbs_text_color":"#6e6e6e","page_breadcrumbs_text_hover_color":"#0652FD","page_breadcrumbs_divider_color":"#b2b2b2","page_breadcrumbs_border_color":"#e0e0e0","safebutton_layer_1_color":"#0652FD","safebutton_layer_2_color":"#000000","safebutton_layer_3_color":"#ffffff","sliding_area_background_color":"#232323","sliding_area_title_color":"#ffffff","sliding_area_text_color":"#777777","sliding_area_link_color":"#777777","sliding_area_link_hover_color":"#0652FD","sliding_area_close_btn_color":"#777777","sliding_area_border_color":"#3e3e3e","sliding_area_overflow_background_color":"#ffffff","sliding_area_overflow_background_color_opacity":"0.90","modal_title_color":"#000000","modal_text_color":"#777777","modal_cursor_color_color":"dark","modal_border_color":"#eef1f6","modal_overflow_background_color":"#ffffff","modal_overflow_background_color_opacity":"1","back_to_top_icon_color":"#ffffff","back_to_top_shape_color":"#262829","redux-backup":1}';
			$movedo_grve_skin_palette_2 = '{"top_bar_bg_color":"#ffffff","top_bar_font_color":"#777777","top_bar_link_color":"#777777","top_bar_hover_color":"#6ECA09","default_header_background_color":"#ffffff","default_header_background_color_opacity":"1","default_header_border_color":"#000000","default_header_border_color_opacity":"0.10","default_header_menu_text_color":"#000000","default_header_menu_text_hover_color":"#6ECA09","default_header_menu_type_color":"#eef1f6","default_header_menu_type_color_hover":"#6ECA09","default_header_submenu_bg_color":"#171a1d","default_header_submenu_text_color":"#777777","default_header_submenu_text_hover_color":"#ffffff","default_header_submenu_text_bg_hover_color":"#171a1d","default_header_submenu_column_text_color":"#ffffff","default_header_submenu_column_text_hover_color":"#ffffff","default_header_submenu_border_color":"#333638","logo_top_header_logo_area_background_color":"#ffffff","logo_top_header_logo_area_background_color_opacity":"1","logo_top_header_border_color":"#000000","logo_top_header_border_color_opacity":"0.10","logo_top_header_menu_area_background_color":"#ffffff","logo_top_header_menu_area_background_color_opacity":"1","logo_top_header_menu_text_color":"#000000","logo_top_header_menu_text_hover_color":"#6ECA09","logo_top_header_menu_type_color":"#eef1f6","logo_top_header_menu_type_color_hover":"#6ECA09","logo_top_header_submenu_bg_color":"#ffffff","logo_top_header_submenu_text_color":"#777777","logo_top_header_submenu_text_hover_color":"#6ECA09","logo_top_header_submenu_text_bg_hover_color":"#ffffff","logo_top_header_submenu_column_text_color":"#000000","logo_top_header_submenu_column_text_hover_color":"#6ECA09","logo_top_header_submenu_border_color":"#eef1f6","side_header_background_color":"#f7f7f7","side_header_background_color_opacity":"1","side_header_menu_text_color":"#000000","side_header_menu_text_hover_color":"#6ECA09","side_header_submenu_text_color":"#000000","side_header_submenu_text_hover_color":"#6ECA09","side_header_border_color":"#323232","side_header_border_opacity":"0.10","header_sticky_background_color":"#101215","header_sticky_background_color_opacity":"1","header_sticky_border_color":"#eef1f6","header_sticky_border_color_opacity":"0.30","sticky_menu_text_color":"#9c9c9c","sticky_menu_text_hover_color":"#ffffff","header_sticky_menu_type_color":"#eef1f6","header_sticky_menu_type_color_hover":"#eef1f6","light_menu_text_hover_color":"#ffffff","light_menu_type_color_hover":"#eef1f6","light_header_border_color":"#ffffff","light_header_border_color_opacity":"0.30","dark_menu_text_hover_color":"#000000","dark_menu_type_color_hover":"#eef1f6","dark_header_border_color":"#000000","dark_header_border_color_opacity":"0.10","responsive_header_background_color":"#000000","responsive_header_background_opacity":"1","responsive_header_elements_color":"#bfbfbf","responsive_header_elements_hover_color":"#ffffff","responsive_menu_background_color":"#ffffff","responsive_menu_link_color":"#777777","responsive_menu_link_hover_color":"#6ECA09","responsive_menu_close_btn_color":"#777777","responsive_menu_border_color":"#eef1f6","responsive_menu_overflow_background_color":"#000000","responsive_menu_overflow_background_color_opacity":"0.90","page_anchor_menu_background_color":"#171a1d","page_anchor_menu_text_color":"#ffffff","page_anchor_menu_text_hover_color":"#6ECA09","page_anchor_menu_background_hover_color":"#171a1d","page_anchor_menu_border_color":"#333638","main_content_background_color":"#ffffff","body_heading_color":"#000000","body_text_color":"#676767","body_text_link_color":"#000000","body_text_link_hover_color":"#6ECA09","body_border_color":"#e9e9e9","widget_title_color":"#000000","body_primary_1_color":"#6ECA09","body_primary_2_color":"#003a40","body_primary_3_color":"#487F84","body_primary_4_color":"#5F597E","body_primary_5_color":"#d6ccad","body_primary_6_color":"#db5111","blog_title_bg_color":"dark","blog_title_bg_color_custom":"#000000","blog_title_content_bg_color":"none","blog_title_content_bg_color_custom":"#ffffff","blog_title_color":"light","blog_title_color_custom":"#ffffff","blog_description_color":"light","blog_description_color_custom":"#ffffff","post_title_bg_color":"dark","post_title_bg_color_custom":"#000000","post_title_content_bg_color":"none","post_title_content_bg_color_custom":"#ffffff","post_subheading_color":"light","post_subheading_color_custom":"#ffffff","post_title_color":"light","post_title_color_custom":"#ffffff","post_description_color":"light","post_description_color_custom":"#ffffff","post_bar_background_color":"#ffffff","post_bar_socials_color":"#d3d3d3","post_bar_socials_color_hover":"#000000","post_bar_nav_title_color":"#000000","post_bar_arrow_color":"#d3d3d3","post_bar_border_color":"#e9e9e9","page_title_bg_color":"primary-2","page_title_bg_color_custom":"#000000","page_title_content_bg_color":"none","page_title_content_bg_color_custom":"#ffffff","page_title_color":"light","page_title_color_custom":"#ffffff","page_description_color":"light","page_description_color_custom":"#ffffff","search_page_title_bg_color":"dark","search_page_title_bg_color_custom":"#000000","search_page_title_content_bg_color":"none","search_page_title_content_bg_color_custom":"#ffffff","search_page_title_color":"light","search_page_title_color_custom":"#ffffff","search_page_description_color":"light","search_page_description_color_custom":"#ffffff","portfolio_title_bg_color":"dark","portfolio_title_bg_color_custom":"#000000","portfolio_title_content_bg_color":"none","portfolio_title_content_bg_color_custom":"#ffffff","portfolio_title_color":"light","portfolio_title_color_custom":"#ffffff","portfolio_description_color":"light","portfolio_description_color_custom":"#ffffff","portfolio_bar_background_color":"#ffffff","portfolio_bar_socials_color":"#d3d3d3","portfolio_bar_socials_color_hover":"#000000","portfolio_bar_nav_title_color":"#000000","portfolio_bar_arrow_color":"#d3d3d3","portfolio_bar_border_color":"#e9e9e9","product_tax_title_bg_color":"dark","product_tax_title_bg_color_custom":"#000000","product_tax_title_content_bg_color":"none","product_tax_title_content_bg_color_custom":"#ffffff","product_tax_title_color":"light","product_tax_title_color_custom":"#ffffff","product_tax_description_color":"light","product_tax_description_color_custom":"#ffffff","product_title_bg_color":"dark","product_title_bg_color_custom":"#000000","product_title_content_bg_color":"none","product_title_content_bg_color_custom":"#ffffff","product_title_color":"light","product_title_color_custom":"#ffffff","product_description_color":"light","product_description_color_custom":"#ffffff","product_area_bg_color":"#eeeeee","product_area_headings_color":"#000000","product_area_font_color":"#999999","product_area_link_color":"#FF7D88","product_area_hover_color":"#000000","product_area_border_color":"#e0e0e0","product_area_button_color":"primary-1","product_area_button_hover_color":"black","product_bar_background_color":"#ffffff","product_bar_socials_color":"#d3d3d3","product_bar_socials_color_hover":"#000000","product_bar_nav_title_color":"#000000","product_bar_arrow_color":"#d3d3d3","product_bar_border_color":"#e9e9e9","footer_widgets_bg_color":"#0D0F10","footer_widgets_headings_color":"#ffffff","footer_widgets_font_color":"#ffffff","footer_widgets_link_color":"#ffffff","footer_widgets_hover_color":"#909090","footer_widgets_border_color":"#3E3F3F","footer_bar_bg_color":"#0D0F10","footer_bar_bg_color_opacity":"1","footer_bar_font_color":"#ffffff","footer_bar_link_color":"#ffffff","footer_bar_hover_color":"#909090","page_breadcrumbs_background_color":"#ffffff","page_breadcrumbs_text_color":"#6e6e6e","page_breadcrumbs_text_hover_color":"#6ECA09","page_breadcrumbs_divider_color":"#b2b2b2","page_breadcrumbs_border_color":"#e0e0e0","safebutton_layer_1_color":"#6ECA09","safebutton_layer_2_color":"#000000","safebutton_layer_3_color":"#ffffff","sliding_area_background_color":"#232323","sliding_area_title_color":"#ffffff","sliding_area_text_color":"#777777","sliding_area_link_color":"#777777","sliding_area_link_hover_color":"#6ECA09","sliding_area_close_btn_color":"#777777","sliding_area_border_color":"#3e3e3e","sliding_area_overflow_background_color":"#ffffff","sliding_area_overflow_background_color_opacity":"0.90","modal_title_color":"#000000","modal_text_color":"#777777","modal_cursor_color_color":"dark","modal_border_color":"#eef1f6","modal_overflow_background_color":"#ffffff","modal_overflow_background_color_opacity":"1","back_to_top_icon_color":"#ffffff","back_to_top_shape_color":"#262829","redux-backup":1}';
			$movedo_grve_skin_palette_3 = '{"top_bar_bg_color":"#ffffff","top_bar_font_color":"#777777","top_bar_link_color":"#777777","top_bar_hover_color":"#E01076","default_header_background_color":"#ffffff","default_header_background_color_opacity":"1","default_header_border_color":"#000000","default_header_border_color_opacity":"0.10","default_header_menu_text_color":"#000000","default_header_menu_text_hover_color":"#E01076","default_header_menu_type_color":"#eef1f6","default_header_menu_type_color_hover":"#E01076","default_header_submenu_bg_color":"#171a1d","default_header_submenu_text_color":"#777777","default_header_submenu_text_hover_color":"#ffffff","default_header_submenu_text_bg_hover_color":"#171a1d","default_header_submenu_column_text_color":"#ffffff","default_header_submenu_column_text_hover_color":"#ffffff","default_header_submenu_border_color":"#333638","logo_top_header_logo_area_background_color":"#ffffff","logo_top_header_logo_area_background_color_opacity":"1","logo_top_header_border_color":"#000000","logo_top_header_border_color_opacity":"0.10","logo_top_header_menu_area_background_color":"#ffffff","logo_top_header_menu_area_background_color_opacity":"1","logo_top_header_menu_text_color":"#000000","logo_top_header_menu_text_hover_color":"#E01076","logo_top_header_menu_type_color":"#eef1f6","logo_top_header_menu_type_color_hover":"#E01076","logo_top_header_submenu_bg_color":"#ffffff","logo_top_header_submenu_text_color":"#777777","logo_top_header_submenu_text_hover_color":"#E01076","logo_top_header_submenu_text_bg_hover_color":"#ffffff","logo_top_header_submenu_column_text_color":"#000000","logo_top_header_submenu_column_text_hover_color":"#E01076","logo_top_header_submenu_border_color":"#eef1f6","side_header_background_color":"#f7f7f7","side_header_background_color_opacity":"1","side_header_menu_text_color":"#000000","side_header_menu_text_hover_color":"#E01076","side_header_submenu_text_color":"#000000","side_header_submenu_text_hover_color":"#E01076","side_header_border_color":"#323232","side_header_border_opacity":"0.10","header_sticky_background_color":"#101215","header_sticky_background_color_opacity":"1","header_sticky_border_color":"#eef1f6","header_sticky_border_color_opacity":"0.30","sticky_menu_text_color":"#9c9c9c","sticky_menu_text_hover_color":"#ffffff","header_sticky_menu_type_color":"#eef1f6","header_sticky_menu_type_color_hover":"#eef1f6","light_menu_text_hover_color":"#ffffff","light_menu_type_color_hover":"#eef1f6","light_header_border_color":"#ffffff","light_header_border_color_opacity":"0.30","dark_menu_text_hover_color":"#000000","dark_menu_type_color_hover":"#eef1f6","dark_header_border_color":"#000000","dark_header_border_color_opacity":"0.10","responsive_header_background_color":"#000000","responsive_header_background_opacity":"1","responsive_header_elements_color":"#bfbfbf","responsive_header_elements_hover_color":"#ffffff","responsive_menu_background_color":"#ffffff","responsive_menu_link_color":"#777777","responsive_menu_link_hover_color":"#E01076","responsive_menu_close_btn_color":"#777777","responsive_menu_border_color":"#eef1f6","responsive_menu_overflow_background_color":"#000000","responsive_menu_overflow_background_color_opacity":"0.90","page_anchor_menu_background_color":"#171a1d","page_anchor_menu_text_color":"#ffffff","page_anchor_menu_text_hover_color":"#E01076","page_anchor_menu_background_hover_color":"#171a1d","page_anchor_menu_border_color":"#333638","main_content_background_color":"#ffffff","body_heading_color":"#000000","body_text_color":"#676767","body_text_link_color":"#000000","body_text_link_hover_color":"#E01076","body_border_color":"#e9e9e9","widget_title_color":"#000000","body_primary_1_color":"#E01076","body_primary_2_color":"#003a40","body_primary_3_color":"#487F84","body_primary_4_color":"#5F597E","body_primary_5_color":"#d6ccad","body_primary_6_color":"#db5111","blog_title_bg_color":"dark","blog_title_bg_color_custom":"#000000","blog_title_content_bg_color":"none","blog_title_content_bg_color_custom":"#ffffff","blog_title_color":"light","blog_title_color_custom":"#ffffff","blog_description_color":"light","blog_description_color_custom":"#ffffff","post_title_bg_color":"dark","post_title_bg_color_custom":"#000000","post_title_content_bg_color":"none","post_title_content_bg_color_custom":"#ffffff","post_subheading_color":"light","post_subheading_color_custom":"#ffffff","post_title_color":"light","post_title_color_custom":"#ffffff","post_description_color":"light","post_description_color_custom":"#ffffff","post_bar_background_color":"#ffffff","post_bar_socials_color":"#d3d3d3","post_bar_socials_color_hover":"#000000","post_bar_nav_title_color":"#000000","post_bar_arrow_color":"#d3d3d3","post_bar_border_color":"#e9e9e9","page_title_bg_color":"primary-2","page_title_bg_color_custom":"#000000","page_title_content_bg_color":"none","page_title_content_bg_color_custom":"#ffffff","page_title_color":"light","page_title_color_custom":"#ffffff","page_description_color":"light","page_description_color_custom":"#ffffff","search_page_title_bg_color":"dark","search_page_title_bg_color_custom":"#000000","search_page_title_content_bg_color":"none","search_page_title_content_bg_color_custom":"#ffffff","search_page_title_color":"light","search_page_title_color_custom":"#ffffff","search_page_description_color":"light","search_page_description_color_custom":"#ffffff","portfolio_title_bg_color":"dark","portfolio_title_bg_color_custom":"#000000","portfolio_title_content_bg_color":"none","portfolio_title_content_bg_color_custom":"#ffffff","portfolio_title_color":"light","portfolio_title_color_custom":"#ffffff","portfolio_description_color":"light","portfolio_description_color_custom":"#ffffff","portfolio_bar_background_color":"#ffffff","portfolio_bar_socials_color":"#d3d3d3","portfolio_bar_socials_color_hover":"#000000","portfolio_bar_nav_title_color":"#000000","portfolio_bar_arrow_color":"#d3d3d3","portfolio_bar_border_color":"#e9e9e9","product_tax_title_bg_color":"dark","product_tax_title_bg_color_custom":"#000000","product_tax_title_content_bg_color":"none","product_tax_title_content_bg_color_custom":"#ffffff","product_tax_title_color":"light","product_tax_title_color_custom":"#ffffff","product_tax_description_color":"light","product_tax_description_color_custom":"#ffffff","product_title_bg_color":"dark","product_title_bg_color_custom":"#000000","product_title_content_bg_color":"none","product_title_content_bg_color_custom":"#ffffff","product_title_color":"light","product_title_color_custom":"#ffffff","product_description_color":"light","product_description_color_custom":"#ffffff","product_area_bg_color":"#eeeeee","product_area_headings_color":"#000000","product_area_font_color":"#999999","product_area_link_color":"#FF7D88","product_area_hover_color":"#000000","product_area_border_color":"#e0e0e0","product_area_button_color":"primary-1","product_area_button_hover_color":"black","product_bar_background_color":"#ffffff","product_bar_socials_color":"#d3d3d3","product_bar_socials_color_hover":"#000000","product_bar_nav_title_color":"#000000","product_bar_arrow_color":"#d3d3d3","product_bar_border_color":"#e9e9e9","footer_widgets_bg_color":"#0D0F10","footer_widgets_headings_color":"#ffffff","footer_widgets_font_color":"#ffffff","footer_widgets_link_color":"#ffffff","footer_widgets_hover_color":"#909090","footer_widgets_border_color":"#3E3F3F","footer_bar_bg_color":"#0D0F10","footer_bar_bg_color_opacity":"1","footer_bar_font_color":"#ffffff","footer_bar_link_color":"#ffffff","footer_bar_hover_color":"#909090","page_breadcrumbs_background_color":"#ffffff","page_breadcrumbs_text_color":"#6e6e6e","page_breadcrumbs_text_hover_color":"#E01076","page_breadcrumbs_divider_color":"#b2b2b2","page_breadcrumbs_border_color":"#e0e0e0","safebutton_layer_1_color":"#E01076","safebutton_layer_2_color":"#000000","safebutton_layer_3_color":"#ffffff","sliding_area_background_color":"#232323","sliding_area_title_color":"#ffffff","sliding_area_text_color":"#777777","sliding_area_link_color":"#777777","sliding_area_link_hover_color":"#E01076","sliding_area_close_btn_color":"#777777","sliding_area_border_color":"#3e3e3e","sliding_area_overflow_background_color":"#ffffff","sliding_area_overflow_background_color_opacity":"0.90","modal_title_color":"#000000","modal_text_color":"#777777","modal_cursor_color_color":"dark","modal_border_color":"#eef1f6","modal_overflow_background_color":"#ffffff","modal_overflow_background_color_opacity":"1","back_to_top_icon_color":"#ffffff","back_to_top_shape_color":"#262829","redux-backup":1}';
			$movedo_grve_skin_palette_4 = '{"top_bar_bg_color":"#ffffff","top_bar_font_color":"#777777","top_bar_link_color":"#777777","top_bar_hover_color":"#15C7FF","default_header_background_color":"#ffffff","default_header_background_color_opacity":"1","default_header_border_color":"#000000","default_header_border_color_opacity":"0.10","default_header_menu_text_color":"#000000","default_header_menu_text_hover_color":"#15C7FF","default_header_menu_type_color":"#eef1f6","default_header_menu_type_color_hover":"#15C7FF","default_header_submenu_bg_color":"#171a1d","default_header_submenu_text_color":"#777777","default_header_submenu_text_hover_color":"#ffffff","default_header_submenu_text_bg_hover_color":"#171a1d","default_header_submenu_column_text_color":"#ffffff","default_header_submenu_column_text_hover_color":"#ffffff","default_header_submenu_border_color":"#333638","logo_top_header_logo_area_background_color":"#ffffff","logo_top_header_logo_area_background_color_opacity":"1","logo_top_header_border_color":"#000000","logo_top_header_border_color_opacity":"0.10","logo_top_header_menu_area_background_color":"#ffffff","logo_top_header_menu_area_background_color_opacity":"1","logo_top_header_menu_text_color":"#000000","logo_top_header_menu_text_hover_color":"#15C7FF","logo_top_header_menu_type_color":"#eef1f6","logo_top_header_menu_type_color_hover":"#15C7FF","logo_top_header_submenu_bg_color":"#ffffff","logo_top_header_submenu_text_color":"#777777","logo_top_header_submenu_text_hover_color":"#15C7FF","logo_top_header_submenu_text_bg_hover_color":"#ffffff","logo_top_header_submenu_column_text_color":"#000000","logo_top_header_submenu_column_text_hover_color":"#15C7FF","logo_top_header_submenu_border_color":"#eef1f6","side_header_background_color":"#f7f7f7","side_header_background_color_opacity":"1","side_header_menu_text_color":"#000000","side_header_menu_text_hover_color":"#15C7FF","side_header_submenu_text_color":"#000000","side_header_submenu_text_hover_color":"#15C7FF","side_header_border_color":"#323232","side_header_border_opacity":"0.10","header_sticky_background_color":"#101215","header_sticky_background_color_opacity":"1","header_sticky_border_color":"#eef1f6","header_sticky_border_color_opacity":"0.30","sticky_menu_text_color":"#9c9c9c","sticky_menu_text_hover_color":"#ffffff","header_sticky_menu_type_color":"#eef1f6","header_sticky_menu_type_color_hover":"#eef1f6","light_menu_text_hover_color":"#ffffff","light_menu_type_color_hover":"#eef1f6","light_header_border_color":"#ffffff","light_header_border_color_opacity":"0.30","dark_menu_text_hover_color":"#000000","dark_menu_type_color_hover":"#eef1f6","dark_header_border_color":"#000000","dark_header_border_color_opacity":"0.10","responsive_header_background_color":"#000000","responsive_header_background_opacity":"1","responsive_header_elements_color":"#bfbfbf","responsive_header_elements_hover_color":"#ffffff","responsive_menu_background_color":"#ffffff","responsive_menu_link_color":"#777777","responsive_menu_link_hover_color":"#15C7FF","responsive_menu_close_btn_color":"#777777","responsive_menu_border_color":"#eef1f6","responsive_menu_overflow_background_color":"#000000","responsive_menu_overflow_background_color_opacity":"0.90","page_anchor_menu_background_color":"#171a1d","page_anchor_menu_text_color":"#ffffff","page_anchor_menu_text_hover_color":"#15C7FF","page_anchor_menu_background_hover_color":"#171a1d","page_anchor_menu_border_color":"#333638","main_content_background_color":"#ffffff","body_heading_color":"#000000","body_text_color":"#676767","body_text_link_color":"#000000","body_text_link_hover_color":"#15C7FF","body_border_color":"#e9e9e9","widget_title_color":"#000000","body_primary_1_color":"#15C7FF","body_primary_2_color":"#003a40","body_primary_3_color":"#487F84","body_primary_4_color":"#5F597E","body_primary_5_color":"#d6ccad","body_primary_6_color":"#db5111","blog_title_bg_color":"dark","blog_title_bg_color_custom":"#000000","blog_title_content_bg_color":"none","blog_title_content_bg_color_custom":"#ffffff","blog_title_color":"light","blog_title_color_custom":"#ffffff","blog_description_color":"light","blog_description_color_custom":"#ffffff","post_title_bg_color":"dark","post_title_bg_color_custom":"#000000","post_title_content_bg_color":"none","post_title_content_bg_color_custom":"#ffffff","post_subheading_color":"light","post_subheading_color_custom":"#ffffff","post_title_color":"light","post_title_color_custom":"#ffffff","post_description_color":"light","post_description_color_custom":"#ffffff","post_bar_background_color":"#ffffff","post_bar_socials_color":"#d3d3d3","post_bar_socials_color_hover":"#000000","post_bar_nav_title_color":"#000000","post_bar_arrow_color":"#d3d3d3","post_bar_border_color":"#e9e9e9","page_title_bg_color":"primary-2","page_title_bg_color_custom":"#000000","page_title_content_bg_color":"none","page_title_content_bg_color_custom":"#ffffff","page_title_color":"light","page_title_color_custom":"#ffffff","page_description_color":"light","page_description_color_custom":"#ffffff","search_page_title_bg_color":"dark","search_page_title_bg_color_custom":"#000000","search_page_title_content_bg_color":"none","search_page_title_content_bg_color_custom":"#ffffff","search_page_title_color":"light","search_page_title_color_custom":"#ffffff","search_page_description_color":"light","search_page_description_color_custom":"#ffffff","portfolio_title_bg_color":"dark","portfolio_title_bg_color_custom":"#000000","portfolio_title_content_bg_color":"none","portfolio_title_content_bg_color_custom":"#ffffff","portfolio_title_color":"light","portfolio_title_color_custom":"#ffffff","portfolio_description_color":"light","portfolio_description_color_custom":"#ffffff","portfolio_bar_background_color":"#ffffff","portfolio_bar_socials_color":"#d3d3d3","portfolio_bar_socials_color_hover":"#000000","portfolio_bar_nav_title_color":"#000000","portfolio_bar_arrow_color":"#d3d3d3","portfolio_bar_border_color":"#e9e9e9","product_tax_title_bg_color":"dark","product_tax_title_bg_color_custom":"#000000","product_tax_title_content_bg_color":"none","product_tax_title_content_bg_color_custom":"#ffffff","product_tax_title_color":"light","product_tax_title_color_custom":"#ffffff","product_tax_description_color":"light","product_tax_description_color_custom":"#ffffff","product_title_bg_color":"dark","product_title_bg_color_custom":"#000000","product_title_content_bg_color":"none","product_title_content_bg_color_custom":"#ffffff","product_title_color":"light","product_title_color_custom":"#ffffff","product_description_color":"light","product_description_color_custom":"#ffffff","product_area_bg_color":"#eeeeee","product_area_headings_color":"#000000","product_area_font_color":"#999999","product_area_link_color":"#FF7D88","product_area_hover_color":"#000000","product_area_border_color":"#e0e0e0","product_area_button_color":"primary-1","product_area_button_hover_color":"black","product_bar_background_color":"#ffffff","product_bar_socials_color":"#d3d3d3","product_bar_socials_color_hover":"#000000","product_bar_nav_title_color":"#000000","product_bar_arrow_color":"#d3d3d3","product_bar_border_color":"#e9e9e9","footer_widgets_bg_color":"#0D0F10","footer_widgets_headings_color":"#ffffff","footer_widgets_font_color":"#ffffff","footer_widgets_link_color":"#ffffff","footer_widgets_hover_color":"#909090","footer_widgets_border_color":"#3E3F3F","footer_bar_bg_color":"#0D0F10","footer_bar_bg_color_opacity":"1","footer_bar_font_color":"#ffffff","footer_bar_link_color":"#ffffff","footer_bar_hover_color":"#909090","page_breadcrumbs_background_color":"#ffffff","page_breadcrumbs_text_color":"#6e6e6e","page_breadcrumbs_text_hover_color":"#15C7FF","page_breadcrumbs_divider_color":"#b2b2b2","page_breadcrumbs_border_color":"#e0e0e0","safebutton_layer_1_color":"#15C7FF","safebutton_layer_2_color":"#000000","safebutton_layer_3_color":"#ffffff","sliding_area_background_color":"#232323","sliding_area_title_color":"#ffffff","sliding_area_text_color":"#777777","sliding_area_link_color":"#777777","sliding_area_link_hover_color":"#15C7FF","sliding_area_close_btn_color":"#777777","sliding_area_border_color":"#3e3e3e","sliding_area_overflow_background_color":"#ffffff","sliding_area_overflow_background_color_opacity":"0.90","modal_title_color":"#000000","modal_text_color":"#777777","modal_cursor_color_color":"dark","modal_border_color":"#eef1f6","modal_overflow_background_color":"#ffffff","modal_overflow_background_color_opacity":"1","back_to_top_icon_color":"#ffffff","back_to_top_shape_color":"#262829","redux-backup":1}';
			$movedo_grve_skin_palette_5 = '{"top_bar_bg_color":"#ffffff","top_bar_font_color":"#777777","top_bar_link_color":"#777777","top_bar_hover_color":"#9013FE","default_header_background_color":"#ffffff","default_header_background_color_opacity":"1","default_header_border_color":"#000000","default_header_border_color_opacity":"0.10","default_header_menu_text_color":"#000000","default_header_menu_text_hover_color":"#9013FE","default_header_menu_type_color":"#eef1f6","default_header_menu_type_color_hover":"#9013FE","default_header_submenu_bg_color":"#171a1d","default_header_submenu_text_color":"#777777","default_header_submenu_text_hover_color":"#ffffff","default_header_submenu_text_bg_hover_color":"#171a1d","default_header_submenu_column_text_color":"#ffffff","default_header_submenu_column_text_hover_color":"#ffffff","default_header_submenu_border_color":"#333638","logo_top_header_logo_area_background_color":"#ffffff","logo_top_header_logo_area_background_color_opacity":"1","logo_top_header_border_color":"#000000","logo_top_header_border_color_opacity":"0.10","logo_top_header_menu_area_background_color":"#ffffff","logo_top_header_menu_area_background_color_opacity":"1","logo_top_header_menu_text_color":"#000000","logo_top_header_menu_text_hover_color":"#9013FE","logo_top_header_menu_type_color":"#eef1f6","logo_top_header_menu_type_color_hover":"#9013FE","logo_top_header_submenu_bg_color":"#ffffff","logo_top_header_submenu_text_color":"#777777","logo_top_header_submenu_text_hover_color":"#9013FE","logo_top_header_submenu_text_bg_hover_color":"#ffffff","logo_top_header_submenu_column_text_color":"#000000","logo_top_header_submenu_column_text_hover_color":"#9013FE","logo_top_header_submenu_border_color":"#eef1f6","side_header_background_color":"#f7f7f7","side_header_background_color_opacity":"1","side_header_menu_text_color":"#000000","side_header_menu_text_hover_color":"#9013FE","side_header_submenu_text_color":"#000000","side_header_submenu_text_hover_color":"#9013FE","side_header_border_color":"#323232","side_header_border_opacity":"0.10","header_sticky_background_color":"#101215","header_sticky_background_color_opacity":"1","header_sticky_border_color":"#eef1f6","header_sticky_border_color_opacity":"0.30","sticky_menu_text_color":"#9c9c9c","sticky_menu_text_hover_color":"#ffffff","header_sticky_menu_type_color":"#eef1f6","header_sticky_menu_type_color_hover":"#eef1f6","light_menu_text_hover_color":"#ffffff","light_menu_type_color_hover":"#eef1f6","light_header_border_color":"#ffffff","light_header_border_color_opacity":"0.30","dark_menu_text_hover_color":"#000000","dark_menu_type_color_hover":"#eef1f6","dark_header_border_color":"#000000","dark_header_border_color_opacity":"0.10","responsive_header_background_color":"#000000","responsive_header_background_opacity":"1","responsive_header_elements_color":"#bfbfbf","responsive_header_elements_hover_color":"#ffffff","responsive_menu_background_color":"#ffffff","responsive_menu_link_color":"#777777","responsive_menu_link_hover_color":"#9013FE","responsive_menu_close_btn_color":"#777777","responsive_menu_border_color":"#eef1f6","responsive_menu_overflow_background_color":"#000000","responsive_menu_overflow_background_color_opacity":"0.90","page_anchor_menu_background_color":"#171a1d","page_anchor_menu_text_color":"#ffffff","page_anchor_menu_text_hover_color":"#9013FE","page_anchor_menu_background_hover_color":"#171a1d","page_anchor_menu_border_color":"#333638","main_content_background_color":"#ffffff","body_heading_color":"#000000","body_text_color":"#676767","body_text_link_color":"#000000","body_text_link_hover_color":"#9013FE","body_border_color":"#e9e9e9","widget_title_color":"#000000","body_primary_1_color":"#9013FE","body_primary_2_color":"#003a40","body_primary_3_color":"#487F84","body_primary_4_color":"#5F597E","body_primary_5_color":"#d6ccad","body_primary_6_color":"#db5111","blog_title_bg_color":"dark","blog_title_bg_color_custom":"#000000","blog_title_content_bg_color":"none","blog_title_content_bg_color_custom":"#ffffff","blog_title_color":"light","blog_title_color_custom":"#ffffff","blog_description_color":"light","blog_description_color_custom":"#ffffff","post_title_bg_color":"dark","post_title_bg_color_custom":"#000000","post_title_content_bg_color":"none","post_title_content_bg_color_custom":"#ffffff","post_subheading_color":"light","post_subheading_color_custom":"#ffffff","post_title_color":"light","post_title_color_custom":"#ffffff","post_description_color":"light","post_description_color_custom":"#ffffff","post_bar_background_color":"#ffffff","post_bar_socials_color":"#d3d3d3","post_bar_socials_color_hover":"#000000","post_bar_nav_title_color":"#000000","post_bar_arrow_color":"#d3d3d3","post_bar_border_color":"#e9e9e9","page_title_bg_color":"primary-2","page_title_bg_color_custom":"#000000","page_title_content_bg_color":"none","page_title_content_bg_color_custom":"#ffffff","page_title_color":"light","page_title_color_custom":"#ffffff","page_description_color":"light","page_description_color_custom":"#ffffff","search_page_title_bg_color":"dark","search_page_title_bg_color_custom":"#000000","search_page_title_content_bg_color":"none","search_page_title_content_bg_color_custom":"#ffffff","search_page_title_color":"light","search_page_title_color_custom":"#ffffff","search_page_description_color":"light","search_page_description_color_custom":"#ffffff","portfolio_title_bg_color":"dark","portfolio_title_bg_color_custom":"#000000","portfolio_title_content_bg_color":"none","portfolio_title_content_bg_color_custom":"#ffffff","portfolio_title_color":"light","portfolio_title_color_custom":"#ffffff","portfolio_description_color":"light","portfolio_description_color_custom":"#ffffff","portfolio_bar_background_color":"#ffffff","portfolio_bar_socials_color":"#d3d3d3","portfolio_bar_socials_color_hover":"#000000","portfolio_bar_nav_title_color":"#000000","portfolio_bar_arrow_color":"#d3d3d3","portfolio_bar_border_color":"#e9e9e9","product_tax_title_bg_color":"dark","product_tax_title_bg_color_custom":"#000000","product_tax_title_content_bg_color":"none","product_tax_title_content_bg_color_custom":"#ffffff","product_tax_title_color":"light","product_tax_title_color_custom":"#ffffff","product_tax_description_color":"light","product_tax_description_color_custom":"#ffffff","product_title_bg_color":"dark","product_title_bg_color_custom":"#000000","product_title_content_bg_color":"none","product_title_content_bg_color_custom":"#ffffff","product_title_color":"light","product_title_color_custom":"#ffffff","product_description_color":"light","product_description_color_custom":"#ffffff","product_area_bg_color":"#eeeeee","product_area_headings_color":"#000000","product_area_font_color":"#999999","product_area_link_color":"#FF7D88","product_area_hover_color":"#000000","product_area_border_color":"#e0e0e0","product_area_button_color":"primary-1","product_area_button_hover_color":"black","product_bar_background_color":"#ffffff","product_bar_socials_color":"#d3d3d3","product_bar_socials_color_hover":"#000000","product_bar_nav_title_color":"#000000","product_bar_arrow_color":"#d3d3d3","product_bar_border_color":"#e9e9e9","footer_widgets_bg_color":"#0D0F10","footer_widgets_headings_color":"#ffffff","footer_widgets_font_color":"#ffffff","footer_widgets_link_color":"#ffffff","footer_widgets_hover_color":"#909090","footer_widgets_border_color":"#3E3F3F","footer_bar_bg_color":"#0D0F10","footer_bar_bg_color_opacity":"1","footer_bar_font_color":"#ffffff","footer_bar_link_color":"#ffffff","footer_bar_hover_color":"#909090","page_breadcrumbs_background_color":"#ffffff","page_breadcrumbs_text_color":"#6e6e6e","page_breadcrumbs_text_hover_color":"#9013FE","page_breadcrumbs_divider_color":"#b2b2b2","page_breadcrumbs_border_color":"#e0e0e0","safebutton_layer_1_color":"#9013FE","safebutton_layer_2_color":"#000000","safebutton_layer_3_color":"#ffffff","sliding_area_background_color":"#232323","sliding_area_title_color":"#ffffff","sliding_area_text_color":"#777777","sliding_area_link_color":"#777777","sliding_area_link_hover_color":"#9013FE","sliding_area_close_btn_color":"#777777","sliding_area_border_color":"#3e3e3e","sliding_area_overflow_background_color":"#ffffff","sliding_area_overflow_background_color_opacity":"0.90","modal_title_color":"#000000","modal_text_color":"#777777","modal_cursor_color_color":"dark","modal_border_color":"#eef1f6","modal_overflow_background_color":"#ffffff","modal_overflow_background_color_opacity":"1","back_to_top_icon_color":"#ffffff","back_to_top_shape_color":"#262829","redux-backup":1}';
			$movedo_grve_skin_palette_6 = '{"top_bar_bg_color":"#ffffff","top_bar_font_color":"#777777","top_bar_link_color":"#777777","top_bar_hover_color":"#F5A623","default_header_background_color":"#ffffff","default_header_background_color_opacity":"1","default_header_border_color":"#000000","default_header_border_color_opacity":"0.10","default_header_menu_text_color":"#000000","default_header_menu_text_hover_color":"#F5A623","default_header_menu_type_color":"#eef1f6","default_header_menu_type_color_hover":"#F5A623","default_header_submenu_bg_color":"#171a1d","default_header_submenu_text_color":"#777777","default_header_submenu_text_hover_color":"#ffffff","default_header_submenu_text_bg_hover_color":"#171a1d","default_header_submenu_column_text_color":"#ffffff","default_header_submenu_column_text_hover_color":"#ffffff","default_header_submenu_border_color":"#333638","logo_top_header_logo_area_background_color":"#ffffff","logo_top_header_logo_area_background_color_opacity":"1","logo_top_header_border_color":"#000000","logo_top_header_border_color_opacity":"0.10","logo_top_header_menu_area_background_color":"#ffffff","logo_top_header_menu_area_background_color_opacity":"1","logo_top_header_menu_text_color":"#000000","logo_top_header_menu_text_hover_color":"#F5A623","logo_top_header_menu_type_color":"#eef1f6","logo_top_header_menu_type_color_hover":"#F5A623","logo_top_header_submenu_bg_color":"#ffffff","logo_top_header_submenu_text_color":"#777777","logo_top_header_submenu_text_hover_color":"#F5A623","logo_top_header_submenu_text_bg_hover_color":"#ffffff","logo_top_header_submenu_column_text_color":"#000000","logo_top_header_submenu_column_text_hover_color":"#F5A623","logo_top_header_submenu_border_color":"#eef1f6","side_header_background_color":"#f7f7f7","side_header_background_color_opacity":"1","side_header_menu_text_color":"#000000","side_header_menu_text_hover_color":"#F5A623","side_header_submenu_text_color":"#000000","side_header_submenu_text_hover_color":"#F5A623","side_header_border_color":"#323232","side_header_border_opacity":"0.10","header_sticky_background_color":"#101215","header_sticky_background_color_opacity":"1","header_sticky_border_color":"#eef1f6","header_sticky_border_color_opacity":"0.30","sticky_menu_text_color":"#9c9c9c","sticky_menu_text_hover_color":"#ffffff","header_sticky_menu_type_color":"#eef1f6","header_sticky_menu_type_color_hover":"#eef1f6","light_menu_text_hover_color":"#ffffff","light_menu_type_color_hover":"#eef1f6","light_header_border_color":"#ffffff","light_header_border_color_opacity":"0.30","dark_menu_text_hover_color":"#000000","dark_menu_type_color_hover":"#eef1f6","dark_header_border_color":"#000000","dark_header_border_color_opacity":"0.10","responsive_header_background_color":"#000000","responsive_header_background_opacity":"1","responsive_header_elements_color":"#bfbfbf","responsive_header_elements_hover_color":"#ffffff","responsive_menu_background_color":"#ffffff","responsive_menu_link_color":"#777777","responsive_menu_link_hover_color":"#F5A623","responsive_menu_close_btn_color":"#777777","responsive_menu_border_color":"#eef1f6","responsive_menu_overflow_background_color":"#000000","responsive_menu_overflow_background_color_opacity":"0.90","page_anchor_menu_background_color":"#171a1d","page_anchor_menu_text_color":"#ffffff","page_anchor_menu_text_hover_color":"#F5A623","page_anchor_menu_background_hover_color":"#171a1d","page_anchor_menu_border_color":"#333638","main_content_background_color":"#ffffff","body_heading_color":"#000000","body_text_color":"#676767","body_text_link_color":"#000000","body_text_link_hover_color":"#F5A623","body_border_color":"#e9e9e9","widget_title_color":"#000000","body_primary_1_color":"#F5A623","body_primary_2_color":"#003a40","body_primary_3_color":"#487F84","body_primary_4_color":"#5F597E","body_primary_5_color":"#d6ccad","body_primary_6_color":"#db5111","blog_title_bg_color":"dark","blog_title_bg_color_custom":"#000000","blog_title_content_bg_color":"none","blog_title_content_bg_color_custom":"#ffffff","blog_title_color":"light","blog_title_color_custom":"#ffffff","blog_description_color":"light","blog_description_color_custom":"#ffffff","post_title_bg_color":"dark","post_title_bg_color_custom":"#000000","post_title_content_bg_color":"none","post_title_content_bg_color_custom":"#ffffff","post_subheading_color":"light","post_subheading_color_custom":"#ffffff","post_title_color":"light","post_title_color_custom":"#ffffff","post_description_color":"light","post_description_color_custom":"#ffffff","post_bar_background_color":"#ffffff","post_bar_socials_color":"#d3d3d3","post_bar_socials_color_hover":"#000000","post_bar_nav_title_color":"#000000","post_bar_arrow_color":"#d3d3d3","post_bar_border_color":"#e9e9e9","page_title_bg_color":"primary-2","page_title_bg_color_custom":"#000000","page_title_content_bg_color":"none","page_title_content_bg_color_custom":"#ffffff","page_title_color":"light","page_title_color_custom":"#ffffff","page_description_color":"light","page_description_color_custom":"#ffffff","search_page_title_bg_color":"dark","search_page_title_bg_color_custom":"#000000","search_page_title_content_bg_color":"none","search_page_title_content_bg_color_custom":"#ffffff","search_page_title_color":"light","search_page_title_color_custom":"#ffffff","search_page_description_color":"light","search_page_description_color_custom":"#ffffff","portfolio_title_bg_color":"dark","portfolio_title_bg_color_custom":"#000000","portfolio_title_content_bg_color":"none","portfolio_title_content_bg_color_custom":"#ffffff","portfolio_title_color":"light","portfolio_title_color_custom":"#ffffff","portfolio_description_color":"light","portfolio_description_color_custom":"#ffffff","portfolio_bar_background_color":"#ffffff","portfolio_bar_socials_color":"#d3d3d3","portfolio_bar_socials_color_hover":"#000000","portfolio_bar_nav_title_color":"#000000","portfolio_bar_arrow_color":"#d3d3d3","portfolio_bar_border_color":"#e9e9e9","product_tax_title_bg_color":"dark","product_tax_title_bg_color_custom":"#000000","product_tax_title_content_bg_color":"none","product_tax_title_content_bg_color_custom":"#ffffff","product_tax_title_color":"light","product_tax_title_color_custom":"#ffffff","product_tax_description_color":"light","product_tax_description_color_custom":"#ffffff","product_title_bg_color":"dark","product_title_bg_color_custom":"#000000","product_title_content_bg_color":"none","product_title_content_bg_color_custom":"#ffffff","product_title_color":"light","product_title_color_custom":"#ffffff","product_description_color":"light","product_description_color_custom":"#ffffff","product_area_bg_color":"#eeeeee","product_area_headings_color":"#000000","product_area_font_color":"#999999","product_area_link_color":"#FF7D88","product_area_hover_color":"#000000","product_area_border_color":"#e0e0e0","product_area_button_color":"primary-1","product_area_button_hover_color":"black","product_bar_background_color":"#ffffff","product_bar_socials_color":"#d3d3d3","product_bar_socials_color_hover":"#000000","product_bar_nav_title_color":"#000000","product_bar_arrow_color":"#d3d3d3","product_bar_border_color":"#e9e9e9","footer_widgets_bg_color":"#0D0F10","footer_widgets_headings_color":"#ffffff","footer_widgets_font_color":"#ffffff","footer_widgets_link_color":"#ffffff","footer_widgets_hover_color":"#909090","footer_widgets_border_color":"#3E3F3F","footer_bar_bg_color":"#0D0F10","footer_bar_bg_color_opacity":"1","footer_bar_font_color":"#ffffff","footer_bar_link_color":"#ffffff","footer_bar_hover_color":"#909090","page_breadcrumbs_background_color":"#ffffff","page_breadcrumbs_text_color":"#6e6e6e","page_breadcrumbs_text_hover_color":"#F5A623","page_breadcrumbs_divider_color":"#b2b2b2","page_breadcrumbs_border_color":"#e0e0e0","safebutton_layer_1_color":"#F5A623","safebutton_layer_2_color":"#000000","safebutton_layer_3_color":"#ffffff","sliding_area_background_color":"#232323","sliding_area_title_color":"#ffffff","sliding_area_text_color":"#777777","sliding_area_link_color":"#777777","sliding_area_link_hover_color":"#F5A623","sliding_area_close_btn_color":"#777777","sliding_area_border_color":"#3e3e3e","sliding_area_overflow_background_color":"#ffffff","sliding_area_overflow_background_color_opacity":"0.90","modal_title_color":"#000000","modal_text_color":"#777777","modal_cursor_color_color":"dark","modal_border_color":"#eef1f6","modal_overflow_background_color":"#ffffff","modal_overflow_background_color_opacity":"1","back_to_top_icon_color":"#ffffff","back_to_top_shape_color":"#262829","redux-backup":1}';

			$movedo_gmap_api_key_link = '<a href="//developers.google.com/maps/documentation/javascript/get-api-key" target="_blank">' . esc_html__( 'Generate Google Map API Key', 'movedo' ) . '</a>';

			// ACTUAL DECLARATION OF SECTIONS

			$this->sections[] = array(
				'icon' => 'el-icon-cogs',
				'title' => esc_html__( 'General Settings', 'movedo' ),
				'id' => 'grve_redux_section_general_settings',
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'theme_layout',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Theme Layout', 'movedo' ),
						'subtitle' => esc_html__( 'Select between Streched or Boxed for the theme basic Layout.', 'movedo' ),
						'options' => $movedo_grve_theme_layout_selection,
						'default' => 'stretched',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'boxed_size',
						'type' => 'text',
						'default' => '1220',
						'title' => esc_html__( 'Theme Wrapper Size', 'movedo' ),
						'subtitle' => esc_html__( 'Enter the Theme Wrapper width in px (Default is 1220).', 'movedo' ),
						'validate' => 'numeric',
						'required' => array( 'theme_layout', 'equals', 'boxed' ),
					),
					array(
						'id' => 'frame_size',
						'type' => 'text',
						'default' => '30',
						'title' => esc_html__( 'Frame Size', 'movedo' ),
						'subtitle' => esc_html__( 'Enter frame size in px (Default is 30).', 'movedo' ),
						'validate' => 'numeric',
						'required' => array( 'theme_layout', 'equals', 'framed' ),
					),
					array(
						'id'          => 'frame_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Frame Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Select a color for the framed layout.', 'movedo' ),
						'default'     => '#ffffff',
						'required' => array( 'theme_layout', 'equals', 'framed' ),
						'transparent' => false,
					),
					array(
						'id' => 'container_size',
						'type' => 'text',
						'default' => '1170',
						'title' => esc_html__( 'Container Size', 'movedo' ),
						'subtitle' => esc_html__( 'Enter the Container width in px (Default is 1170).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id'       => 'body_background',
						'type'     => 'background',
						'title'    => esc_html__( 'Theme Background Image / Color', 'movedo' ),
						'subtitle' => esc_html__( 'Select a background image or color for the theme.', 'movedo' ),
						'background-color' => true,
						'transparent' => false,
						'background-repeat' => true,
						'background-attachment' => true,
						'background-clip' => false,
						'background-size' => true,
						'output'    => '#grve-body',
						'default' => array (
							'background-color' => '#171A1D',
						),
					),
					array(
						'id'=>'theme_loader',
						'type' => 'switch',
						'title' => esc_html__( 'Theme Loader', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable or Disable Theme Loader.', 'movedo' ),
						'default' => '0',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id'=>'show_spinner',
						'type' => 'switch',
						'title' => esc_html__( 'Enable Spinner', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable or Disable Theme Loader Spinner.', 'movedo' ),
						'default' => '1',
						'1' => esc_html__( 'On', 'movedo' ),
						'0' => esc_html__( 'Off', 'movedo' ),
						'required' => array( 'theme_loader', 'equals', '1' ),
					),
					array(
						'id'=>'spinner_style',
						'type' => 'select',
						'title' => esc_html__( 'Spinner', 'movedo' ),
						'subtitle' => esc_html__( 'Select the style of your spinner.', 'movedo' ),
						'options' => array(
							'ring' => esc_html__( 'Ring', 'movedo' ),
							'dual-ring' => esc_html__( 'Dual Ring', 'movedo' ),
							'roller' => esc_html__( 'Roller', 'movedo' ),
							'bullets' => esc_html__( 'Bullets', 'movedo' ),
						),
						'default' => 'ring',
						'validate' => 'not_empty',
						'required' => array( 'show_spinner', 'equals', '1' ),
					),
					array(
						'id' => 'page_transition',
						'type' => 'select',
						'title' => esc_html__( 'Page Transition', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the page transition when navigating from one page to another. It is worth noting that it maybe causes problems with plugins which use ajax requests.', 'movedo' ),
						'options' => array(
							'none' => esc_html__( 'None', 'movedo' ),
							'fade-in' => esc_html__( 'Fade In', 'movedo' ),
							'left-to-right' => esc_html__( 'Left to Right', 'movedo' ),
							'right-to-left' => esc_html__( 'Right to Left', 'movedo' ),
							'top-to-bottom' => esc_html__( 'Top to Bottom', 'movedo' ),
							'bottom-to-top' => esc_html__( 'Bottom to Top', 'movedo' ),
							'zoom-out' => esc_html__( 'Zoom Out', 'movedo' ),
						),
						'default' => 'none',
						'validate' => 'not_empty',
						'required' => array( 'theme_loader', 'equals', '1' ),
					),
					array(
						'id' => 'replace_admin_logo',
						'type' => 'switch',
						'title' => esc_html__( 'Replace Admin Logo', 'movedo' ),
						'subtitle'=> esc_html__( 'Replace the backend admin logo with your company logo.', 'movedo' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id'       => 'admin_logo',
						'type'     => 'media',
						'title' => esc_html__( 'Admin Logo', 'movedo' ),
						'subtitle' => esc_html__( 'Select the image for your company logo. ( If empty Logo Default will be used instead )', 'movedo' ),
						'required' => array( 'replace_admin_logo', 'equals', '1' ),
					),
					array(
						'id' => 'admin_logo_height',
						'type' => 'text',
						'default' => '84',
						'title' => esc_html__( 'Admin Logo Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter the company logo height in px (Default is 84).', 'movedo' ),
						'validate' => 'numeric',
						'required' => array( 'replace_admin_logo', 'equals', '1' ),
					),
					array(
						'id' => 'tracking_code',
						'type' => 'ace_editor',
						'mode' => 'html',
						'theme' => 'chrome',
						'title' => esc_html__( 'Tracking Code', 'movedo' ),
						'subtitle' => esc_html__( 'Copy and paste your tracking code here.', 'movedo' ),
						'desc' => '',
						'default' => ''
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Logos', 'movedo' ),
				'id' => 'grve_redux_section_logos',
				'header' => '',
				'desc' => '',
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-photo',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'logo',
						'url' => true,
						'type' => 'media',
						'title' => esc_html__( 'Logo Default Header', 'movedo' ),
						'read-only' => false,
						'default' => array( 'url' => get_template_directory_uri() .'/images/logos/logo-default.png', 'width' => '158', 'height' => '40' ),
						'subtitle' => esc_html__( 'Upload the logo for the Default Header.', 'movedo' ),
					),
					array(
						'id' => 'logo_light',
						'url'=> true,
						'type' => 'media',
						'title' => esc_html__( 'Logo Light Header', 'movedo' ),
						'read-only' => false,
						'default' => array( 'url' => get_template_directory_uri() .'/images/logos/logo-light.png', 'width' => '158', 'height' => '40' ),
						'subtitle' => esc_html__( 'Upload the logo for the Light Header.', 'movedo' ),
					),
					array(
						'id' => 'logo_dark',
						'url' => true,
						'type' => 'media',
						'title' => esc_html__( 'Logo Dark Header', 'movedo' ),
						'read-only' => false,
						'default' => array( 'url' => get_template_directory_uri() .'/images/logos/logo-default.png', 'width' => '158', 'height' => '40' ),
						'subtitle' => esc_html__( 'Upload the logo for the Dark Header.', 'movedo' ),
					),
					array(
						'id' => 'logo_side',
						'url' => true,
						'type' => 'media',
						'title' => esc_html__( 'Logo Side Header', 'movedo' ),
						'read-only' => false,
						'default' => array( 'url' => get_template_directory_uri() .'/images/logos/logo-side.png', 'width' => '230', 'height' => '180' ),
						'subtitle' => esc_html__( 'Upload the logo for the Side Header.', 'movedo' ),
					),
					array(
						'id' => 'logo_sticky',
						'url'=> true,
						'type' => 'media',
						'title' => esc_html__( 'Logo Sticky Header', 'movedo' ),
						'read-only' => false,
						'default' => array( 'url' => get_template_directory_uri() .'/images/logos/logo-sticky.png', 'width' => '40', 'height' => '40' ),
						'subtitle' => esc_html__( 'Upload the logo for the Sticky Header.', 'movedo' ),
					),
					array(
						'id' => 'logo_responsive',
						'url' => true,
						'type' => 'media',
						'title' => esc_html__( 'Logo Responsive Header', 'movedo' ),
						'read-only' => false,
						'default' => array( 'url' => get_template_directory_uri() .'/images/logos/logo-responsive.png', 'width' => '30', 'height' => '30' ),
						'subtitle' => esc_html__( 'Upload the logo for the Responsive Header.', 'movedo' ),
					),
				)
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Top Bar Options', 'movedo' ),
				'id' => 'grve_redux_section_top_bar_options',
				'header' => '',
				'desc' => esc_html__( 'You can enable the TopBar area, just above the Header, in order to add various elements in two different positions, left and right.', 'movedo' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-arrow-up',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'top_bar_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Top Bar Area', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable or Disable the TopBar Area, the area just above your header.', 'movedo' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id'             => 'top_bar_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Top Bar Spacing', 'movedo' ),
						'subtitle'       => esc_html__( 'Set the spacing, Top and Bottom, of the TopBar Area.', 'movedo' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'movedo'),
						'default'        => array(
							'padding-top'     => '15px',
							'padding-bottom'  => '15px',
							'units'           => 'px',
						),
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'top_bar_section_type',
						'type' => 'select',
						'title' => esc_html__( 'Top Bar Full Width', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you prefer a full-width Top Bar Area.', 'movedo' ),
						'options' => array(
							'fullwidth-background' => esc_html__( 'No', 'movedo' ),
							'fullwidth-element' => esc_html__( 'Yes', 'movedo' ),
						),
						'default' => 'fullwidth-background',
						'validate' => 'not_empty',
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id'   => 'info_top_bar_left',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Left Top Bar Area', 'movedo' ),
						'desc' => esc_html__( 'In side navigation mode, Left Top Bar Area is shown first.', 'movedo' ),
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id'=>'top_bar_left_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Left Area', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Left TopBar Area.', 'movedo' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'top_bar_left_options',
						'type' => 'sortable',
						'mode' => 'checkbox',
						'title' => esc_html__( 'Left Area Elements', 'movedo' ),
						'subtitle' => esc_html__( 'Enable or Disable the elements you like to show in the Left TopBar Area.', 'movedo' ),
						'options' => $movedo_grve_top_bar_options,
						'default' => $movedo_grve_top_bar_options_default,
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
						),
					),
					array(
						'id' => 'top_bar_left_text',
						'type' => 'text',
						'title' => esc_html__( 'Left Area Text', 'movedo' ),
						'subtitle' => esc_html__( 'Place the text you wish for your Left TopBar Area.', 'movedo' ),
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
						),
					),
					array(
						'id'=>'top_bar_left_type_form',
						'type' => 'button_set',
						'title' => esc_html__( 'Left Form Type', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the type of your form.', 'movedo' ),
						'options' => array(
							'contact-form' => esc_html__( 'Contact Form 7', 'movedo' ),
							'gravity-form' => esc_html__( 'Gravity Form', 'movedo' ),
						),
						'default' => 'contact-form',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
						),
					),
					array(
						'id' => 'top_bar_left_form',
						'type' => 'select',
						'title' => esc_html__( 'Left Area Form', 'movedo' ),
						'subtitle' => esc_html__( 'Select the form for your Contact Form.', 'movedo' ),
						'data' => 'posts',
						'args' => array( 'post_type' => 'wpcf7_contact_form', 'numberposts' => -1 ),
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
							array( 'top_bar_left_type_form', 'equals', 'contact-form' ),
						),
					),
					array(
						'id' => 'top_bar_left_gravity_form',
						'type' => 'select',
						'title' => esc_html__( 'Left Area Form', 'movedo' ),
						'subtitle' => esc_html__( 'Select the form for your Gravity Form.', 'movedo' ),
						'options' => $movedo_grve_gravity_options,
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
							array( 'top_bar_left_type_form', 'equals', 'gravity-form' ),
						),
					),
					array(
						'id' => 'top_bar_left_social_options',
						'type' => 'checkbox',
						'title' => esc_html__( 'Left Area Social Icons', 'movedo' ),
						'subtitle' => esc_html__( 'Select your social icons. Social URLs are configured from Theme Options - Social Media', 'movedo' ),
						'desc' => '',
						'class' => 'grve-redux-columns',
						'label' => true,
						'options' => $movedo_grve_social_options,
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
						),
					),
					array(
						'id'   => 'info_top_bar_right',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Right Top Bar Area', 'movedo' ),
						'desc' => esc_html__( 'In side navigation mode, Right Top Bar Area is shown second.', 'movedo' ),
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id'=>'top_bar_right_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Right Area', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Right TopBar Area.', 'movedo' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'top_bar_right_options',
						'type' => 'sortable',
						'mode' => 'checkbox',
						'title' => esc_html__( 'Right Area Elements', 'movedo' ),
						'subtitle' => esc_html__( 'Enable or Disable the elements you like to show in the Right TopBar Area.', 'movedo' ),
						'options' => $movedo_grve_top_bar_options,
						'default' => $movedo_grve_top_bar_options_default,
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
						),
					),
					array(
						'id' => 'top_bar_right_text',
						'type' => 'text',
						'title' => esc_html__( 'Right Area Text', 'movedo' ),
						'subtitle' => esc_html__( 'Place the text you wish for your Right TopBar Area.', 'movedo' ),
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
						),
					),
					array(
						'id'=>'top_bar_right_type_form',
						'type' => 'button_set',
						'title' => esc_html__( 'Right Form Type', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the type of your form.', 'movedo' ),
						'options' => array(
							'contact-form' => esc_html__( 'Contact Form 7', 'movedo' ),
							'gravity-form' => esc_html__( 'Gravity Form', 'movedo' ),
						),
						'default' => 'contact-form',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
						),
					),
					array(
						'id' => 'top_bar_right_form',
						'type' => 'select',
						'title' => esc_html__( 'Right Area Form', 'movedo' ),
						'subtitle' => esc_html__( 'Select the form for your Contact Form.', 'movedo' ),
						'data' => 'posts',
						'args' => array( 'post_type' => 'wpcf7_contact_form', 'numberposts' => -1 ),
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
							array( 'top_bar_right_type_form', 'equals', 'contact-form' ),
						),
					),
					array(
						'id' => 'top_bar_right_gravity_form',
						'type' => 'select',
						'title' => esc_html__( 'Right Area Form', 'movedo' ),
						'subtitle' => esc_html__( 'Select the form for your Gravity Form.', 'movedo' ),
						'options' => $movedo_grve_gravity_options,
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
							array( 'top_bar_right_type_form', 'equals', 'gravity-form' ),
						),
					),
					array(
						'id' => 'top_bar_right_social_options',
						'type' => 'checkbox',
						'title' => esc_html__( 'Right Area Social Icons', 'movedo' ),
						'subtitle' => esc_html__( 'Select your social icons. Social URLs are configured from Theme Options - Social Media', 'movedo' ),
						'class' => 'grve-redux-columns',
						'label' => true,
						'options' => $movedo_grve_social_options,
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
						),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Header Options', 'movedo' ),
				'id' => 'grve_redux_section_header_options',
				'header' => '',
				'desc' => esc_html__( 'Here you can set your preferences for the Theme Header(Logo, Menu and Menu Elements). Notice that most of the options below depend on your first selection where you have to select among Default, Logo on Top or Side Navigation Header.', 'movedo' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-screen',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'header_mode',
						'type' => 'image_select',
						'title' => esc_html__( 'Header Mode', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your Header Mode. keep in mind that this is one of the most important options for the appearance of your site. Your selection here will determine the following section options.', 'movedo' ),
						'options' => $movedo_grve_header_mode_selection,
						'default' => 'default',
					),
					array(
						'id'=>'header_menu_mode',
						'type' => 'image_select',
						'title' => esc_html__( 'Main Menu Mode', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your main menu mode. Select between default and split menu', 'movedo' ),
						'options' => $movedo_grve_header_menu_mode_selection,
						'default' => 'default',
						'required' => array( 'header_mode', 'equals', 'default' ),
					),
					array(
						'id'=>'split_menu_item_position',
						'type' => 'button_set',
						'title' => esc_html__( 'Extra Menu Item Position ', 'movedo' ),
						'subtitle'=> esc_html__( 'Select where you want to place the extra menu item in case of even menu items.', 'movedo' ),
						'options' => array(
							'left' => esc_html__( 'Left', 'movedo' ),
							'right' => esc_html__( 'Right', 'movedo' ),
						),
						'default' => 'left',
						'required' => array(
							array( 'header_mode', 'equals', 'default' ),
							array( 'header_menu_mode', 'equals', 'split' ),
						),
					),
					array(
						'id' => 'header_height',
						'type' => 'text',
						'default' => '70',
						'title' => esc_html__( 'Header Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter the Header height in px (Default is 70).', 'movedo' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', 'equals', 'default' ),
					),
					array(
						'id' => 'header_side_width',
						'type' => 'text',
						'default' => '300',
						'title' => esc_html__( 'Header Width', 'movedo' ),
						'subtitle' => esc_html__( 'Enter the Header Width in px (Default is 300).', 'movedo' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id'             => 'header_side_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'top'           => 'false',
						'bottom'          => 'false',
						'title'          => esc_html__( 'Spacing', 'movedo' ),
						'subtitle'       => esc_html__( 'Set the spacings for the content of the Header.', 'movedo' ),
						'desc'           => esc_html__( 'Set spacing Right, Left in px.', 'movedo'),
						'default'        => array(
							'padding-left'     => '30px',
							'padding-right'  => '30px',
							'units'           => 'px',
						),
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id'       => 'header_side_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the Header Background, Color or Image.', 'movedo' ),
						'options' => $movedo_grve_title_bg_mode_limited,
						'default'  => 'color',
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id'       => 'header_side_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'movedo' ),
						'subtitle' => esc_html__( 'Select a background image for the header.', 'movedo' ),
						'required' => array(
							array( 'header_mode', 'equals', 'side' ),
							array( 'header_side_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'header_side_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'movedo' ),
						'options' => $movedo_grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array(
							array( 'header_mode', 'equals', 'side' ),
							array( 'header_side_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'header_side_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'movedo' ),
						'options' => $movedo_grve_pattern_selection,
						'default' => 'none',
						'required' => array(
							array( 'header_mode', 'equals', 'side' ),
							array( 'header_side_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'header_side_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'movedo' ),
						'options' => $movedo_grve_color_selection,
						'default' => 'dark',
						'required' => array(
							array( 'header_mode', 'equals', 'side' ),
							array( 'header_side_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'header_side_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'movedo' ),
						'options' => $movedo_grve_opacity_selection,
						'default' => '0',
						'required' => array(
							array( 'header_mode', 'equals', 'side' ),
							array( 'header_side_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'header_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Full Width', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable/Disable full width Header.', 'movedo' ),
						'default' => 1,
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
						'required' => array( 'header_mode', '!=', 'side' ),
					),
					array(
						'id'   => 'info_logo_default_options',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Logo Options for the Default Header', 'movedo' ),
						'required' => array( 'header_mode', 'equals', 'default' ),
					),
					array(
						'id' => 'logo_height',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Logo Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter the Logo height in px (Default is 20).', 'movedo' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', 'equals', 'default' ),
					),
					array(
						'id'   => 'info_logo_ontop_options',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Logo Options for the Logo on Top Header', 'movedo' ),
						'required' => array( 'header_mode', 'equals', 'logo-top' ),
					),
					array(
						'id' => 'header_top_logo_height',
						'type' => 'text',
						'default' => '70',
						'title' => esc_html__( 'Logo Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter the Logo height in px (Default is 30).', 'movedo' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', 'equals', 'logo-top' ),
					),
					array(
						'id' => 'header_top_height',
						'type' => 'text',
						'default' => '180',
						'title' => esc_html__( 'Logo Area Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter the Logo Area Height in px (Default is 120).', 'movedo' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', 'equals', 'logo-top' ),
					),
					array(
						'id' => 'header_top_logo_align',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Logo Alignment', 'movedo' ),
						'subtitle' => esc_html__( 'Align your Logo as you wish.', 'movedo' ),
						'options' => $movedo_grve_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
						'required' => array( 'header_mode', 'equals', 'logo-top' ),
					),
					array(
						'id'   => 'info_logo_side_options',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Logo Options for the Side Header', 'movedo' ),
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id' => 'header_side_logo_height',
						'type' => 'text',
						'default' => '90',
						'title' => esc_html__( 'Logo Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter the Logo Height in px (Default is 90).', 'movedo' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id' => 'header_side_logo_align',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Logo Alignment', 'movedo' ),
						'subtitle' => esc_html__( 'Align your Logo as you wish.', 'movedo' ),
						'options' => $movedo_grve_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id'             => 'header_side_logo_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => array('em', 'px', '%'),
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Spacing', 'movedo' ),
						'subtitle'       => esc_html__( 'Set the spacings of the Logo.', 'movedo' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'movedo'),
						'default'        => array(
							'padding-top'     => '100px',
							'padding-bottom'  => '100px',
							'units'           => 'px',
						),
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id'   => 'info_menu_options',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Menu Options', 'movedo' ),
					),
					array(
						'id' => 'menu_type',
						'type' => 'select',
						'title' => esc_html__( 'Menu Type', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the type of the Main Menu.', 'movedo' ),
						'options' => array(
							'classic' => esc_html__( 'Classic', 'movedo' ),
							'button' => esc_html__( 'Button Style', 'movedo' ),
							'underline' => esc_html__( 'Underline', 'movedo' ),
							'hidden' => esc_html__( 'Hidden', 'movedo' ),
						),
						'default' => 'classic',
						'validate' => 'not_empty',
						'required' => array( 'header_mode', 'equals', 'default' ),
					),
					array(
						'id' => 'menu_align',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Menu Alignment', 'movedo' ),
						'subtitle' => esc_html__( 'Align your Menu as you wish.', 'movedo' ),
						'options' => $movedo_grve_align_selection_extra,
						'default' => 'right',
						'validate' => 'not_empty',
						'required' => array(
							array( 'header_mode', 'equals', 'default' ),
							array( 'header_menu_mode', 'equals', 'default' ),
							array( 'menu_type', '!=', 'hidden' ),
						),
					),
					array(
						'id' => 'header_bottom_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Menu Area Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter the Menu Area Height in px (Default is 60).', 'movedo' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', 'equals', 'logo-top' ),
					),
					array(
						'id' => 'header_top_logo_menu_type',
						'type' => 'select',
						'title' => esc_html__( 'Menu Type', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the type of the Main Menu.', 'movedo' ),
						'options' => array(
							'classic' => esc_html__( 'Classic', 'movedo' ),
							'button' => esc_html__( 'Button Style', 'movedo' ),
							'underline' => esc_html__( 'Underline', 'movedo' ),
							'hidden' => esc_html__( 'Hidden', 'movedo' ),
						),
						'default' => 'classic',
						'validate' => 'not_empty',
						'required' => array( 'header_mode', 'equals', 'logo-top' ),
					),
					array(
						'id' => 'header_top_menu_align',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Menu Alignment', 'movedo' ),
						'subtitle' => esc_html__( 'Align your Menu as you wish.', 'movedo' ),
						'options' => $movedo_grve_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
						'required' => array(
							array( 'header_mode', 'equals', 'logo-top' ),
							array( 'header_top_logo_menu_type', '!=', 'hidden' ),
						),
					),
					array(
						'id' => 'submenu_pointer',
						'type' => 'select',
						'title' => esc_html__( 'Sub Menu Pointer', 'movedo' ),
						'subtitle'=> esc_html__( 'Choose pointer for the submenu.', 'movedo' ),
						'desc' => esc_html__( "Note: This setting will not affect hidden menu.", 'movedo' ),
						'options' => $movedo_grve_menu_pointers,
						'default' => 'none',
						'validate' => 'not_empty',
						'required' => array( 'header_mode', '!=', 'side' ),
					),
					array(
						'id' => 'submenu_top_position',
						'type' => 'text',
						'default' => '0',
						'title' => esc_html__( 'Sub Menu Position', 'movedo' ),
						'subtitle' => esc_html__( 'Define the distance between the top position of the Submenu and the bottom of the Header in px. (Default is 0 - Submenu starts at the bottom of the Header).', 'movedo' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', '!=', 'side' ),
					),
					array(
						'id' => 'header_menu_open_type',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Menu Type', 'movedo' ),
						'subtitle' => esc_html__( 'Select your menu type.', 'movedo' ),
						'options' => array(
							'toggle' => esc_html__( 'Toggle', 'movedo' ),
							'slide' => esc_html__( 'Slide', 'movedo' ),
						),
						'default' => 'toggle',
						'validate' => 'not_empty',
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id' => 'header_side_menu_align',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Menu Alignment', 'movedo' ),
						'subtitle' => esc_html__( 'Align your Menu as you wish.', 'movedo' ),
						'options' => $movedo_grve_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
						'required' => array(
							array( 'header_mode', 'equals', 'side' ),
							array( 'header_menu_open_type', 'equals', 'toggle' ),
						),

					),
					array(
						'id'   => 'info_menu_elements',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Menu Elements Options', 'movedo' ),
					),
					array(
						'id'=>'header_menu_options_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Menu Elements', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable or disable the use of various elements in your header like socials, search, language selector and Contact Form.', 'movedo' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id' => 'header_menu_options',
						'type' => 'sortable',
						'mode' => 'checkbox',
						'title' => esc_html__( 'Menu Elements Options', 'movedo' ),
						'subtitle' => esc_html__( 'Enable / Disable various menu elements options.', 'movedo' ),
						'options' => $movedo_grve_header_menu_options,
						'default' => $movedo_grve_header_menu_options_default,
						'required' => array( 'header_menu_options_enabled', 'equals', '1' ),
					),
					array(
						'id'=>'header_menu_type_form',
						'type' => 'button_set',
						'title' => esc_html__( 'Menu Form Type', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the type of your form.', 'movedo' ),
						'options' => array(
							'contact-form' => esc_html__( 'Contact Form 7', 'movedo' ),
							'gravity-form' => esc_html__( 'Gravity Form', 'movedo' ),
						),
						'default' => 'contact-form',
						'required' => array( 'header_menu_options_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'header_menu_form',
						'type' => 'select',
						'title' => esc_html__( 'Menu Form', 'movedo' ),
						'subtitle' => esc_html__( 'Select the form for your Contact Form.', 'movedo' ),
						'data' => 'posts',
						'args' => array( 'post_type' => 'wpcf7_contact_form', 'numberposts' => -1 ),
						'default' => '',
						'required' => array(
							array( 'header_menu_options_enabled', 'equals', '1' ),
							array( 'header_menu_type_form', 'equals', 'contact-form' ),
						),
					),
					array(
						'id' => 'header_menu_gravity_form',
						'type' => 'select',
						'title' => esc_html__( 'Menu Form', 'movedo' ),
						'subtitle' => esc_html__( 'Select the form for your Gravity Form.', 'movedo' ),
						'options' => $movedo_grve_gravity_options,
						'default' => '',
						'required' => array(
							array( 'header_menu_options_enabled', 'equals', '1' ),
							array( 'header_menu_type_form', 'equals', 'gravity-form' ),
						),
					),
					array(
						'id'=>'header_menu_social_mode',
						'type' => 'select',
						'title' => esc_html__( 'Menu Social Icons Mode', 'movedo' ),
						'subtitle'=> esc_html__( 'Select how you want to display your social icons single or modal.', 'movedo' ),
						'options' => array(
							'modal' => esc_html__( 'Modal Popup', 'movedo' ),
							'single' => esc_html__( 'Single Social Icons', 'movedo' ),
						),
						"default" => 'modal',
						'required' => array( 'header_menu_options_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'header_menu_social_options',
						'type' => 'checkbox',
						'title' => esc_html__( 'Menu Social Icons', 'movedo' ),
						'subtitle' => esc_html__( 'Select the social icons.', 'movedo' ),
						'class' => 'grve-redux-columns',
						'desc' => '',
						'label' => true,
						'options' => $movedo_grve_social_options,
						'required' => array( 'header_menu_options_enabled', 'equals', '1' ),
					),
					array(
						'id'   => 'info_header_text',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Header Text Options', 'movedo' ),
					),
					array(
						'id' => 'header_menu_text_element',
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Header Text Element', 'movedo' ),
						'subtitle' => esc_html__( 'Type your text here. In case you are using the default header, make sure the height of your element does not exceed the header height.', 'movedo' ),
						'default' => '',
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Sticky Header Options', 'movedo' ),
				'id' => 'grve_redux_section_sticky_header_options',
				'header' => '',
				'desc' => esc_html__( 'You can enable the Sticky Header option if you want to provide constant access to the Header elements while visitors scroll down the page. These settings will not affect if you select the Side Header Mode in Theme Options > Header Options.', 'movedo' ),
				'submenu' => true,
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-screen',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'=>'header_sticky_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Sticky Header', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable the Sticky Header option.', 'movedo' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
						'required' => array(
							array( 'header_mode', '!=', 'side' ),
						),
					),
					array(
						'id' => 'header_sticky_type',
						'type' => 'select',
						'title' => esc_html__( 'Sticky Header Type', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the type of the Sticky Header.', 'movedo' ),
						'options' => array(
							'simple' => esc_html__( 'Simple', 'movedo' ),
							'shrink' => esc_html__( 'Shrink', 'movedo' ),
							'advanced' => esc_html__( 'Scroll Up', 'movedo' ),
							'movedo' => esc_html__( 'Movedo', 'movedo' ),
						),
						'default' => 'simple',
						'validate' => 'not_empty',
						'required' => array( 'header_sticky_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'header_sticky_shrink_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Header Shrink Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter the shrink height for the Header in px (Default is 60).', 'movedo' ),
						'validate' => 'numeric',
						'required' => array(
							array( 'header_sticky_enabled', 'equals', '1' ),
							array( 'header_sticky_type', '!=', 'simple' ),
						),
					),
					array(
						'id' => 'header_sticky_shrink_logo_height',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Logo Shrink Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter the shrink height for the Logo in px (Default is 20).', 'movedo' ),
						'validate' => 'numeric',
						'required' => array(
							array( 'header_sticky_enabled', 'equals', '1' ),
							array( 'header_sticky_type', '!=', 'simple' ),
						),
					),
					array(
						'id'=>'header_sticky_devices_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Devices Sticky Header', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable the Sticky Header on responsive header mode.', 'movedo' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Responsive Header Options / Hidden Menu Options', 'movedo' ),
				'id' => 'grve_redux_section_responsive_header_options',
				'header' => '',
				'desc' => esc_html__( 'Define your preferences for the responsive header.', 'movedo' ),
				'submenu' => true,
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-screen',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'responsive_header_threshold',
						'type' => 'text',
						'default' => '1024',
						'title' => esc_html__( 'Responsive Header Threshold', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the screensize you want to activate the responsive header in px, based on the menu items you have (Default is 1024).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'responsive_header_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Responsive Header Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter the Header height in px (Default is 60).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'responsive_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Responsive Header Overlapping', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want the Responsive Header overlaps the content.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_responsive_logo_options',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Logo Options for the Responsive Header', 'movedo' ),
					),
					array(
						'id' => 'responsive_logo_height',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Responsive Logo Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter the Logo height in px (Default is 20).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id'   => 'info_responsive_menu_options',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Responsive / Hidden Menu Options', 'movedo' ),
					),
					array(
						'id' => 'menu_responsive_toggle_selection',
						'type' => 'select',
						'title' => esc_html__( 'Responsive Menu Toggle Button Selection', 'movedo' ),
						'subtitle' => esc_html__( 'Select the toggle button content for your responsive menu.', 'movedo' ),
						'options' => $movedo_grve_menu_responsibe_toggle_selection,
						'default' => 'icon',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'menu_responsive_toggle_text',
						'type' => 'text',
						'title' => esc_html__( 'Responsive Menu Text', 'movedo' ),
						'subtitle' => esc_html__( 'Enter the text for your responsive menu.', 'movedo' ),
						'default' => 'Menu',
						'required' => array( 'menu_responsive_toggle_selection', 'equals', 'text' ),
					),
					array(
						'id' => 'menu_responsive_open_type',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Responsive / Hidden Menu Type', 'movedo' ),
						'subtitle' => esc_html__( 'Select your responsive menu type.', 'movedo' ),
						'options' => array(
							'toggle' => esc_html__( 'Toggle', 'movedo' ),
							'slide' => esc_html__( 'Slide', 'movedo' ),
						),
						'default' => 'toggle',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'menu_responsive_align',
						'type' => 'select',
						'title' => esc_html__( 'Responsive Menu Align', 'movedo' ),
						'subtitle' => esc_html__( 'Select your responsive menu align.', 'movedo' ),
						'options' => array(
							'left' => esc_html__( 'Left', 'movedo' ),
							'center' => esc_html__( 'Center', 'movedo' ),
						),
						'default' => 'left',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'menu_responsive_width',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Responsive / Hidden Menu Width', 'movedo' ),
						'subtitle' => esc_html__( 'Select the width for your hidden menu.', 'movedo' ),
						'options' => array(
							'small' => esc_html__( 'Small', 'movedo' ),
							'medium' => esc_html__( 'Medium', 'movedo' ),
							'large' => esc_html__( 'Large', 'movedo' ),
						),
						'default' => 'small',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'menu_responsive_text',
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Responsive / Hidden Menu Text', 'movedo' ),
						'subtitle' => esc_html__( 'Type your text or anything else you want.', 'movedo' ),
						'default' => '',
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Safe Button Area Options', 'movedo' ),
				'id' => 'grve_redux_section_safebutton_area_options',
				'header' => '',
				'desc' => esc_html__( 'The Safe Button functionality in combination with the usage of the Area Items can offer to your visitors rapidly accessible condensed fundamental information.', 'movedo' ),
				'submenu' => true,
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-screen',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'header_safebutton_area',
						'type' => 'select',
						'title' => esc_html__( 'Safe Button Area Item', 'movedo' ),
						'subtitle' => esc_html__( 'Select an area item for your Safe Button Area.', 'movedo' ),
						'data' => 'posts',
						'args' => array( 'post_type' => 'area-item', 'numberposts' => -1 ),
						'default' => '',
					),
					array(
						'id' => 'safebutton_layers',
						'type' => 'select',
						'title' => esc_html__( 'Safe Button Layers', 'movedo' ),
						'subtitle' => esc_html__( 'Select the amount of colored layers.', 'movedo' ),
						'options' => array(
							'1' => esc_html__( '1 Layer', 'movedo' ),
							'2' => esc_html__( '2 Layers', 'movedo' ),
							'3' => esc_html__( '3 Layers', 'movedo' ),
						),
						'default' => '3',
					),
					array(
						'id'       => 'safebutton_image',
						'type'     => 'media',
						'title' => esc_html__( 'Safe Button Image', 'movedo' ),
						'subtitle' => esc_html__( 'Select an image for the safebutton.', 'movedo' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-arrow-down',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Bottom / Footer Areas', 'movedo' ),
				'id' => 'grve_redux_section_footer_options',
				'desc' => esc_html__( 'These areas appear at the bottom of your pages. Define your preferences.', 'movedo' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'sticky_footer',
						'type' => 'switch',
						'title' => esc_html__( 'Sticky Areas', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want to make sticky these areas.', 'movedo' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id' => 'bottom_bar_area',
						'type' => 'select',
						'title' => esc_html__( 'Bottom Bar Area Item', 'movedo' ),
						'subtitle' => esc_html__( 'Select an area item for your Bottom Bar Area.', 'movedo' ),
						'data' => 'posts',
						'args' => array( 'post_type' => 'area-item', 'numberposts' => -1 ),
						'default' => '',
					),
					array(
						'id'   => 'info_footer_widgets',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Footer Widgets Settings', 'movedo' ),
					),
					array(
						'id'       => 'footer_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the Footer Background, Color or Image.', 'movedo' ),
						'options' => $movedo_grve_title_bg_mode_limited,
						'default'  => 'color',
					),
					array(
						'id'       => 'footer_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'movedo' ),
						'subtitle' => esc_html__( 'Select a background image for the footer.', 'movedo' ),
						'required' => array( 'footer_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'footer_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'movedo' ),
						'options' => $movedo_grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'footer_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'footer_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'movedo' ),
						'options' => $movedo_grve_pattern_selection,
						'default' => 'none',
						'required' => array( 'footer_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'footer_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'movedo' ),
						'options' => $movedo_grve_color_selection,
						'default' => 'dark',
						'required' => array( 'footer_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'footer_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'movedo' ),
						'options' => $movedo_grve_opacity_selection,
						'default' => '0',
						'required' => array( 'footer_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id'=>'footer_widgets_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Footer Widgets Visibility', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable the Footer Area to show the widget areas of the footer.', 'movedo' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id' => 'footer_widgets_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Footer Column Layout', 'movedo' ),
						'subtitle' => esc_html__( 'Select the Footer column layout.', 'movedo' ),
						'options' => $movedo_grve_footer_column_selection,
						'default' => 'footer-1',
						'required' => array( 'footer_widgets_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'footer_section_type',
						'type' => 'select',
						'title' => esc_html__( 'Footer Full Width', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you prefer a full-width Footer Area.', 'movedo' ),
						'options' => array(
							'fullwidth-background' => esc_html__( 'No', 'movedo' ),
							'fullwidth-element' => esc_html__( 'Yes', 'movedo' ),
						),
						'default' => 'fullwidth-background',
						'validate' => 'not_empty',
						'required' => array( 'footer_widgets_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'footer_padding_top_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Footer Top Padding', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the space above the footer area.', 'movedo' ),
						'options' => $movedo_grve_padding_selection,
						'default' => '3x',
						'validate' => 'not_empty',
						'required' => array( 'footer_widgets_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'footer_padding_bottom_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Footer Bottom Padding', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the space below the footer area.', 'movedo' ),
						'options' => $movedo_grve_padding_selection,
						'default' => '3x',
						'validate' => 'not_empty',
						'required' => array( 'footer_widgets_visibility', 'equals', '1' ),
					),
					array(
						'id'   => 'info_footer_bar',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Footer Bar Settings', 'movedo' ),
					),
					array(
						'id'=>'footer_bar_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Footer Bar Visibility', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable the Footer Bar Area to add text (copyright), bottom menu and socials.', 'movedo' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id' => 'footer_bar_section_type',
						'type' => 'select',
						'title' => esc_html__( 'Footer Bar Full Width', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you prefer a full-width Footer Bar Area.', 'movedo' ),
						'options' => array(
							'fullwidth-background' => esc_html__( 'No', 'movedo' ),
							'fullwidth-element' => esc_html__( 'Yes', 'movedo' ),
						),
						'default' => 'fullwidth-background',
						'validate' => 'not_empty',
						'required' => array( 'footer_bar_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'footer_bar_align_center',
						'type' => 'select',
						'title' => esc_html__( 'Footer Bar Center', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if the Footer Bar elements will be centered.', 'movedo' ),
						'options' => array(
							'no' => esc_html__( 'No', 'movedo' ),
							'yes' => esc_html__( 'Yes', 'movedo' ),
						),
						'default' => 'yes',
						'validate' => 'not_empty',
						'required' => array( 'footer_bar_visibility', 'equals', '1' ),
					),
					array(
						'id'=>'footer_copyright_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Footer Copyright Visibility', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable the Footer Copyright Area. Edit it as you wish.', 'movedo' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
						'required' => array( 'footer_bar_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'footer_copyright_text',
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Copyright Text', 'movedo' ),
						'subtitle' => esc_html__( 'Type your copyright text or anything else you want.', 'movedo' ),
						'default' => '&copy; 2017 Movedo Theme. We do move your World',
						'required' => array(
							array( 'footer_bar_visibility', 'equals', '1' ),
							array( 'footer_copyright_visibility', 'equals', '1' ),
						),
					),
					array(
						'id'=>'second_area_visibility',
						'type' => 'button_set',
						'title' => esc_html__( 'Second Footer Area', 'movedo' ),
						'subtitle'=> esc_html__( 'This is the second position in the Footer Bar Area. You can easily add the Bottom Menu (assigned in Appearance > Menus) or socials.', 'movedo' ),
						'options' => array(
							'1' => esc_html__( 'Hide', 'movedo' ),
							'2' => esc_html__( 'Menu', 'movedo' ),
							'3' => esc_html__( 'Socials', 'movedo' ),
							'4' => esc_html__( 'Text', 'movedo' ),
						),
						'default' => '1',
						'required' => array( 'footer_bar_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'footer_second_copyright_text',
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Text', 'movedo' ),
						'subtitle' => esc_html__( 'Type your text or anything else you want.', 'movedo' ),
						'default' => '',
						'required' => array(
							array( 'footer_bar_visibility', 'equals', '1' ),
							array( 'second_area_visibility', 'equals', '4' ),
						),
					),
					array(
						'id' => 'footer_social_display',
						'type' => 'select',
						'title' => esc_html__( 'Footer Social Display', 'movedo' ),
						'subtitle'=> esc_html__( 'Select how you want to display your social items.', 'movedo' ),
						'options' => array(
							'text' => esc_html__( 'Text', 'movedo' ),
							'icon' => esc_html__( 'Icons', 'movedo' ),
						),
						'default' => 'text',
						'validate' => 'not_empty',
						'required' => array(
							array( 'footer_bar_visibility', 'equals', '1' ),
							array( 'second_area_visibility', 'equals', '3' ),
						),
					),
					array(
						'id' => 'footer_social_options',
						'type' => 'checkbox',
						'title' => esc_html__( 'Footer Social items', 'movedo' ),
						'subtitle' => esc_html__( 'Select your social icons.', 'movedo' ),
						'desc' => '',
						'class' => 'grve-redux-columns',
						'label' => true,
						'options' => $movedo_grve_social_options,
						'required' => array(
							array( 'footer_bar_visibility', 'equals', '1' ),
							array( 'second_area_visibility', 'equals', '3' ),
						),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-edit',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Blog Options', 'movedo' ),
				'id' => 'grve_redux_section_blog_options',
				'desc' => esc_html__( 'Changes here will affect the assigned blog page in case you have set a Static Page as blog page in Settings > Reading > Front Page Displays and not when you use the shortcodes to create a blog page. Also these settings will also affect on Archives / Categories / Tags overview pages.', 'movedo' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'blog_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Blog Layout', 'movedo' ),
						'subtitle' => esc_html__( 'Select the layout for the assigned blog page. Choose among Full Width, Left Sidebar or Right Sidebar.', 'movedo' ),
						'options' => $movedo_grve_layout_selection,
						'default' => 'right',
					),
					array(
						'id' => 'blog_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Blog Sidebar', 'movedo' ),
						'subtitle' => esc_html__( 'Select the sidebar for the assigned blog page.', 'movedo' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'blog_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Blog Fixed Sidebar', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'blog_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Blog Sliding Area Visibility', 'movedo' ),
						'subtitle' => esc_html__( 'Enable the Blog Sliding Area for the assigned blog page.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'blog_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Blog Sliding Area Sidebar', 'movedo' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the sliding area.', 'movedo' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id'   => 'info_style_blog_settings',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Blog Style and Basic Blog Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Set the style and basic settings for the default blog.', 'movedo' ),
					),
					array(
						'id' => 'blog_mode',
						'type' => 'select',
						'title' => esc_html__( 'Blog Mode', 'movedo' ),
						'subtitle' => esc_html__( 'Select the blog mode', 'movedo' ),
						'options' => $movedo_grve_blog_mode_selection,
						'default' => 'large',
					),
					array(
						'id' => 'blog_shadow_style',
						'type' => 'select',
						'title' => esc_html__( 'Blog Style', 'movedo' ),
						'subtitle' => esc_html__( 'Select the blog style', 'movedo' ),
						'options' =>array(
							'shadow-mode' => esc_html__( 'With Shadow', 'movedo' ),
							'no-shadow-mode' => esc_html__( 'Without Shadow', 'movedo' ),
						),
						'default' => 'shadow-mode',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
						),
					),
					array(
						'id' => 'blog_media_area',
						'type' => 'switch',
						'title' => esc_html__( 'Blog Media Area visibility', 'movedo' ),
						'subtitle' => esc_html__( 'Select if you want to enable media area', 'movedo' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id' => 'blog_image_mode',
						'type' => 'select',
						'title' => esc_html__( 'Blog Image Size', 'movedo' ),
						'subtitle' => esc_html__( 'Select your Blog Image Size', 'movedo' ),
						'options' => $movedo_grve_blog_image_mode_selection,
						'default' => 'landscape-large-wide',
						'required' => array(
							array( 'blog_mode','equals', 'large' ),
							array( 'blog_media_area', 'equals', '1' ),
						),
					),
					array(
						'id' => 'blog_grid_image_mode',
						'type' => 'select',
						'title' => esc_html__( 'Blog Grid Image Size', 'movedo' ),
						'subtitle' => esc_html__( 'Select your Blog Image Size', 'movedo' ),
						'options' => $movedo_grve_blog_grid_image_mode_selection,
						'default' => 'landscape',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'masonry' ),
							array( 'blog_media_area', 'equals', '1' ),
						),
					),
					array(
						'id' => 'blog_masonry_image_mode',
						'type' => 'select',
						'title' => esc_html__( 'Blog Masonry_Image Size', 'movedo' ),
						'subtitle' => esc_html__( 'Select your Blog Masonry Image Size', 'movedo' ),
						'options' => $movedo_grve_blog_masonry_image_mode_selection,
						'default' => 'medium',
						'required' => array(
							array( 'blog_mode','equals', 'masonry' ),
							array( 'blog_media_area', 'equals', '1' ),
						),
					),
					array(
						'id' => 'blog_image_prio',
						'type' => 'select',
						'title' => esc_html__( 'Blog Featured Image Priority', 'movedo' ),
						'subtitle' => esc_html__( 'If enabled, Featured image is displayed instead of media element', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
						'required' => array( 'blog_media_area', 'equals', '1' ),
					),
					array(
						'id' => 'blog_columns_large_screen',
						'type' => 'select',
						'title' => esc_html__( 'Blog Columns Large Screens', 'movedo' ),
						'subtitle' => esc_html__( 'Select the Blog Columns for large screens', 'movedo' ),
						'options' => $movedo_grve_blog_columns_selection,
						'default' => '3',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
						),
					),
					array(
						'id' => 'blog_columns',
						'type' => 'select',
						'title' => esc_html__( 'Blog Columns', 'movedo' ),
						'subtitle' => esc_html__( 'Select the Blog Columns', 'movedo' ),
						'options' => $movedo_grve_blog_columns_selection,
						'default' => '3',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
						),
					),
					array(
						'id' => 'blog_columns_tablet_landscape',
						'type' => 'select',
						'title' => esc_html__( 'Blog Tablet Landscape Columns', 'movedo' ),
						'subtitle' => esc_html__( 'Select responsive column on tablet devices, landscape orientation.', 'movedo' ),
						'options' => $movedo_grve_blog_columns_selection_tablet,
						'default' => '2',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
						),
					),
					array(
						'id' => 'blog_columns_tablet_portrait',
						'type' => 'select',
						'title' => esc_html__( 'Blog Tablet Portrait Columns', 'movedo' ),
						'subtitle' => esc_html__( 'Select responsive column on tablet devices, portrait orientation.', 'movedo' ),
						'options' => $movedo_grve_blog_columns_selection_tablet,
						'default' => '2',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
						),
					),
					array(
						'id' => 'blog_columns_mobile',
						'type' => 'select',
						'title' => esc_html__( 'Blog Mobile Columns', 'movedo' ),
						'subtitle' => esc_html__( 'Select responsive column on mobile devices.', 'movedo' ),
						'options' => $movedo_grve_blog_columns_selection_mobile,
						'default' => '1',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
						),
					),
					array(
						'id' => 'blog_gutter',
						"type" => "select",
						"title" => esc_html__( "Gutter between items", "movedo" ),
						'subtitle' => esc_html__( 'Add gutter among items.', 'movedo' ),
						"options" => array(
							'yes' => esc_html__( "Yes", "movedo" ),
							'no' => esc_html__( "No", "movedo" ),
						),
						'default' => 'yes',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
						),
					),
					array(
						'id'=>'blog_gutter_size',
						'type' => 'text',
						'default' => '30',
						'title' => esc_html__( 'Gutter Size', 'movedo' ),
						'subtitle' => esc_html__( 'Define the gutter size.', 'movedo' ),
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
							array( 'blog_gutter','equals', 'yes' ),
						),
					),
					array(
						'id' => 'blog_heading_tag',
						'type' => 'select',
						'title' => esc_html__( 'Blog Title Tag', 'movedo' ),
						'subtitle' => esc_html__( 'Select tag for your blog title.', 'movedo' ),
						'options' => $movedo_grve_blog_headings_tag_selection,
						'default' => 'auto',
					),
					array(
						'id' => 'blog_heading',
						'type' => 'select',
						'title' => esc_html__( 'Blog Title Size', 'movedo' ),
						'subtitle' => esc_html__( 'Select size and typography for your blog title.', 'movedo' ),
						'options' => $movedo_grve_blog_headings_selection,
						'default' => 'auto',
					),
					array(
						'id' => 'blog_item_spinner',
						'type' => 'select',
						'title' => esc_html__( 'Blog Loader', 'movedo' ),
						'subtitle' => esc_html__( 'If selected, this will enable a graphic spinner before load.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id'=>'blog_excerpt_length_small',
						'type' => 'text',
						'default' => '30',
						'title' => esc_html__( 'Excerpt Length', 'movedo' ),
						'subtitle' => esc_html__( 'Type how many words you want to display in your post excerpts (Default is 30).', 'movedo' ),
						'validate' => 'numeric',
						'required' => array( 'blog_mode', '!=', 'large' ),
					),
					array(
						'id' => 'blog_auto_excerpt',
						'type' => 'switch',
						'title' => esc_html__( 'Auto Excerpt', 'movedo' ),
						'subtitle'=> esc_html__( "Adds automatic excerpt to all posts. If auto excerpt is off, blog will show all content, a desired 'cut-off' can be inserted in each post with more quicktag.", 'movedo' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
						'required' => array( 'blog_mode', 'equals', 'large' ),
					),

					array(
						'id'=>'blog_excerpt_length',
						'type' => 'text',
						'default' => '55',
						'title' => esc_html__( 'Excerpt Length', 'movedo' ),
						'subtitle' => esc_html__( 'Type how many words you want to display in your post excerpts (Default is 55).', 'movedo' ),
						'validate' => 'numeric',
						'required' => array(
							array( 'blog_auto_excerpt', 'equals', '1' ),
							array( 'blog_mode', 'equals', 'large' ),
						),
					),
					array(
						'id' => 'blog_excerpt_more',
						'type' => 'switch',
						'title' => esc_html__( 'Read More', 'movedo' ),
						'subtitle'=> esc_html__( "Adds a read more button after the excerpt or more quicktag.", 'movedo' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id'=>'blog_comments_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Comments Field Visibility', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable or Disable the comments field of your blog overview.', 'movedo' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id'=>'blog_author_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Author Field Visibility', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable or Disable the author field of your blog overview.', 'movedo' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id'=>'blog_date_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Date Field Visibility', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable or Disable the date field of your blog overview.', 'movedo' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id'=>'blog_like_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Like Field Visibility', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable or Disable the like field of your blog overview.', 'movedo' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id'=>'blog_categories_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Categories Field Visibility', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable or Disable the categories field of your blog overview.', 'movedo' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id'   => 'info_style_blog_header',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Blog Header Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Set the style for the default blog header.', 'movedo' ),
					),
					array(
						'id' => 'blog_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Blog Header Style', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your blog header style.', 'movedo' ),
						'options' => $movedo_grve_header_style,
						'default' => 'default',
					),
					array(
						'id' => 'blog_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Blog Header Overlapping', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want the Blog Header overlaps the content. Combine this option with the Light or Dark Header.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id'=>'blog_title',
						'type' => 'select',
						'title' => esc_html__( 'Main Blog Title', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want to use the site name and tagline as the main blog title or hide it.', 'movedo' ),
						'options' => array(
							'sitetitle' => esc_html__( 'Site Title / Tagline', 'movedo' ),
							'none' => esc_html__( 'None', 'movedo' ),
						),
						'default' => 'sitetitle',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'blog_title_height',
						'type' => 'select',
						'default' => '60',
						'title' => esc_html__( 'Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter blog title height (Default is 60%).', 'movedo' ),
						'options' => $movedo_grve_area_height,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'blog_title_min_height',
						'type' => 'text',
						'default' => '200',
						'title' => esc_html__( 'Minimum Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter blog title minimum height in px (Default is 200).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'blog_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'movedo' ),
						'options' => $movedo_grve_container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'blog_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'movedo' ),
						'options' => $movedo_grve_content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'blog_title_content_alignment',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the alignemt of the content.', 'movedo' ),
						'options' => $movedo_grve_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'blog_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Position', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your position for the default blog title/description.', 'movedo' ),
						'options' => $movedo_grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'blog_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your animation for the default blog title/description.', 'movedo' ),
						'options' => $movedo_grve_animation_selection,
						'default' => 'fade-in-up',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'blog_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the Background for the blog page, Color or Image.', 'movedo' ),
						'options' => $movedo_grve_title_bg_mode_limited,
						'default'  => 'color',
					),
					array(
						'id'       => 'blog_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'movedo' ),
						'subtitle' => esc_html__( 'Select a background image for the default blog title.', 'movedo' ),
						'required' => array( 'blog_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'blog_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'movedo' ),
						'options' => $movedo_grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'blog_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'blog_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'movedo' ),
						'options' => $movedo_grve_pattern_selection,
						'default' => 'none',
						'required' => array( 'blog_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'blog_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'movedo' ),
						'options' => $movedo_grve_color_selection,
						'default' => 'dark',
						'required' => array( 'blog_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'blog_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'movedo' ),
						'options' => $movedo_grve_opacity_selection,
						'default' => '0',
						'required' => array( 'blog_title_bg_mode', '!=', 'color' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Single Post Settings', 'movedo' ),
				'id' => 'grve_redux_section_single_post_settings',
				'header' => '',
				'desc' => esc_html__( 'Define your preferences for the Single Posts. Notice that most of them can be overridden when you create a single post.', 'movedo' ),
				'submenu' => true,
				'icon' => 'el-icon-edit',
				'icon_class' => 'el-icon-large',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'post_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Post Layout', 'movedo' ),
						'subtitle' => esc_html__( 'Select the layout for the Single Posts. Choose among Full Width, Left Sidebar or Right Sidebar.', 'movedo' ),
						'options' => $movedo_grve_layout_selection,
						'default' => 'right',
					),
					array(
						'id' => 'post_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Post Sidebar', 'movedo' ),
						'subtitle' => esc_html__( 'Select the sidebar for the Single Posts.', 'movedo' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'post_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Post Fixed Sidebar', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'post_content_width',
						'type' => 'select',
						'title' => esc_html__( 'Post Content Width', 'movedo' ),
						'subtitle' => esc_html__( 'Select the Single Post Content width (only for Full Width Post Layout)', 'movedo' ),
						'options' => $movedo_grve_container_size_selector,
						'default' => '770',
					),
					array(
						'id' => 'post_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Post Sliding Area Visibility', 'movedo' ),
						'subtitle' => esc_html__( 'Enable the Post Sliding Area if you want.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'post_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Post Sliding Area Sidebar', 'movedo' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the sliding area.', 'movedo' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'post_feature_image_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Featured Image Visibility (Standard Post)', 'movedo' ),
						'subtitle'=> esc_html__( 'Toggle Featured Image on or off.', 'movedo' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id' => 'post_tag_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Post Tags Visibility', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable or Disable the post tags.', 'movedo' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id' => 'post_category_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Post Categories Visibility', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable or Disable the post categories.', 'movedo' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id' => 'post_author_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Author Info Visibility', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Author Info field.', 'movedo' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id' => 'post_author_info_link_text',
						'type' => 'text',
						'title' => esc_html__( 'Author Info Link Text', 'movedo' ),
						'subtitle' => esc_html__( 'Type the text for the author info link.', 'movedo' ),
						"default" => 'All stories by :',
						'required' => array( 'post_author_visibility', 'equals', '1' ),
					),
					array(
						'id'=>'post_comments_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Comments Visibility', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable or Disable the comments of your single posts.', 'movedo' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id'   => 'info_style_post_header',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Post Header Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Set the style for the default post header.', 'movedo' ),
					),
					array(
						'id' => 'post_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Post Header Style', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your post header style.', 'movedo' ),
						'options' => $movedo_grve_header_style,
						'default' => 'default',
					),
					array(
						'id' => 'post_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Post Header Overlapping', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want the Post Header overlaps the content. Combine this option with the Light or Dark Header. You can still override this when you edit each single post.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_post_title',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Single Post Title Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Set the style for the default single post title.', 'movedo' ),
					),
					array(
						'id' => 'post_title_style',
						'type' => 'select',
						'default' => 'advanced',
						'title' => esc_html__( 'Title Style', 'movedo' ),
						'subtitle' => esc_html__( 'Select Post Title Style', 'movedo' ),
						'options' => $movedo_grve_title_style,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'post_title_height',
						'type' => 'select',
						'default' => '60',
						'title' => esc_html__( 'Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter post title height (Default is 60%).', 'movedo' ),
						'options' => $movedo_grve_area_height,
						'validate' => 'not_empty',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'post_title_min_height',
						'type' => 'text',
						'default' => '200',
						'title' => esc_html__( 'Minimum Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter post title minimum height in px (Default is 200).', 'movedo' ),
						'validate' => 'numeric',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'post_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'movedo' ),
						'options' => $movedo_grve_container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'post_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'movedo' ),
						'options' => $movedo_grve_content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'post_title_content_alignment',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the alignemt of the content.', 'movedo' ),
						'options' => $movedo_grve_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'post_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Position', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your position for the default post title/description.', 'movedo' ),
						'options' => $movedo_grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'post_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your animation for the default post title/description.', 'movedo' ),
						'options' => $movedo_grve_animation_selection,
						'default' => 'fade-in-up',
						'validate' => 'not_empty',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id'       => 'post_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the Post Title Background, Color or Image.', 'movedo' ),
						'options' => $movedo_grve_title_bg_mode,
						'default'  => 'color',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id'       => 'post_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'movedo' ),
						'subtitle' => esc_html__( 'Select a background image for the default post title.', 'movedo' ),
						'required' => array(
							array( 'post_title_style', 'equals', 'advanced' ),
							array( 'post_title_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'post_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'movedo' ),
						'options' => $movedo_grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array(
							array( 'post_title_style', 'equals', 'advanced' ),
							array( 'post_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id' => 'post_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'movedo' ),
						'options' => $movedo_grve_pattern_selection,
						'default' => 'none',
						'required' => array(
							array( 'post_title_style', 'equals', 'advanced' ),
							array( 'post_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id' => 'post_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'movedo' ),
						'options' => $movedo_grve_color_selection,
						'default' => 'dark',
						'required' => array(
							array( 'post_title_style', 'equals', 'advanced' ),
							array( 'post_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id' => 'post_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'movedo' ),
						'options' => $movedo_grve_opacity_selection,
						'default' => '0',
						'required' => array(
							array( 'post_title_style', 'equals', 'advanced' ),
							array( 'post_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id'   => 'info_style_post_anchor_menu',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Anchor Menu Bar Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Anchor Menu Bar where you can place a custom sticky menu per post.', 'movedo' ),
					),
					array(
						'id' => 'post_anchor_menu_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Anchor Menu Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter Anchor Menu height in px (Default is 60).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'post_anchor_menu_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Anchor Menu Alignment', 'movedo' ),
						'subtitle' => esc_html__( 'Select the alignment of your Anchor Menu in posts.', 'movedo' ),
						'options' => $movedo_grve_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'post_anchor_menu_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want to have full width Anchor Menu.', 'movedo' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id'   => 'info_style_post_breadcrumbs',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Breadcrumbs Bar Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Breadcrumbs Bar.', 'movedo' ),
					),
					array(
						'id'=>'post_breadcrumbs_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Breadcrumbs', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Breadcrumbs for Single Post / Archives / Categories / Tags.', 'movedo' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id' => 'post_breadcrumbs_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Breadcrumbs Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter Breadcrumbs height in px (Default is 60).', 'movedo' ),
						'validate' => 'numeric',
						'required' => array( 'post_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'post_breadcrumbs_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Breadcrumbs Alignment', 'movedo' ),
						'subtitle' => esc_html__( 'Select the alignment of your breadcrumbs.', 'movedo' ),
						'options' => $movedo_grve_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array( 'post_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'post_breadcrumbs_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want to show your breadcrumbs full width.', 'movedo' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
						'required' => array( 'post_breadcrumbs_enabled', 'equals', '1' ),
					),

					array(
						'id'   => 'info_style_post_nav',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Navigation & Socials Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Navigation.', 'movedo' ),
					),
					array(
						'id' => 'post_nav_bar_layout',
						'type' => 'select',
						'title' => esc_html__( 'Navigation and Related Items Layout', 'movedo' ),
						'subtitle' => esc_html__( 'Select the Layout for Navigation and Related Items', 'movedo' ),
						'options' => array(
							'layout-1' => esc_html__( 'Bottom Navigation & Classic Related', 'movedo' ),
							'layout-2' => esc_html__( 'Bottom Navigation & Related Combo', 'movedo' ),
							'layout-3' => esc_html__( 'Floating Navigation & Classic Related', 'movedo' ),
						),
						'default' => 'layout-1',
					),
					array(
						'id'=>'post_related_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Related Posts Visibility', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable or Disable the visibility of the related posts.', 'movedo' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id' => 'post_related_title_first',
						'type' => 'text',
						'title' => esc_html__( 'Related Posts First Title', 'movedo' ),
						'subtitle' => esc_html__( 'Type the text for the first posts related title.', 'movedo' ),
						"default" => 'You might also like',
						'required' => array( 'post_related_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'post_related_title_second',
						'type' => 'text',
						'title' => esc_html__( 'Related Posts Second Title', 'movedo' ),
						'subtitle' => esc_html__( 'Type the text for the second posts related title.', 'movedo' ),
						"default" => 'One of the following',
						'required' => array( 'post_related_visibility', 'equals', '1' ),
					),
					array(
						'id'=>'post_nav_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Posts Navigation Visibility', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable or Disable the visibility of the posts navigation.', 'movedo' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id' => 'post_nav_same_term',
						'type' => 'checkbox',
						'title' => esc_html__( 'Post Navigation Same Term', 'movedo' ),
						'subtitle'=> esc_html__( 'If selected, only navigation items from the current taxonomy term will be displayed.', 'movedo' ),
						'default' => 0,
						'required' => array( 'post_nav_visibility', 'equals', '1' ),
					),
					array(
						'id'             => 'post_nav_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Navigation Bar Spacing', 'movedo' ),
						'subtitle'       => esc_html__( 'Set the spacing, Top and Bottom, of the Navigation Area.', 'movedo' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'movedo'),
						'default'        => array(
							'padding-top'     => '40px',
							'padding-bottom'  => '40px',
							'units'           => 'px',
						),
						'required' => array( 'post_nav_bar_layout', 'equals', 'layout-1' ),
					),
					array(
						'id' => 'post_social',
						'type' => 'checkbox',
						'title' => esc_html__( 'Social Share', 'movedo' ),
						'subtitle' => esc_html__( 'Enable or Disable post social shares for the Single Posts.', 'movedo' ),
						'options' => $movedo_grve_post_social_options,
						'default' => 0,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-pencil',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Page Options', 'movedo'),
				'id' => 'grve_redux_section_page_options',
				'subtitle' => esc_html__( 'You can find the basic settings for the pages here. Almost everything can be overridden when you edit a single page.', 'movedo' ),
				'desc' => esc_html__( 'You can find the basic settings for the pages here. Almost everything can be overridden when you edit a single page.', 'movedo' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'page_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Page Layout', 'movedo' ),
						'subtitle' => esc_html__( 'Select the layout for the pages. Choose among Full Width, Left Sidebar or Right Sidebar.', 'movedo' ),
						'options' => $movedo_grve_layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'page_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Page Sidebar', 'movedo' ),
						'subtitle' => esc_html__( 'Select the default sidebar for the pages in case you do not use full width layout.', 'movedo' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Page Fixed Sidebar', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'page_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Page Sliding Area Visibility', 'movedo' ),
						'subtitle' => esc_html__( 'Enable the Sliding Area for the pages.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'page_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Page Sliding Area Sidebar', 'movedo' ),
						'subtitle' => esc_html__( 'Select the sidebar for the sliding area.', 'movedo' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'page_comments_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Comments Visibility', 'movedo' ),
						'subtitle'=> esc_html__( 'Easily disable the comments for all pages.', 'movedo' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id'   => 'info_style_page_header',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Page Header Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Set the style for the default page header.', 'movedo' ),
					),
					array(
						'id' => 'page_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Page Header Style', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your page header style.', 'movedo' ),
						'options' => $movedo_grve_header_style,
						'default' => 'default',
					),
					array(
						'id' => 'page_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Page Header Overlapping', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want the Page Header overlaps the content. Combine this option with the Light or Dark Header. You can still override this when you edit each single page.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_page_title',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Page Title Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Set the style for the default page title.', 'movedo' ),
					),
					array(
						'id' => 'page_title_height',
						'type' => 'select',
						'default' => '40',
						'title' => esc_html__( 'Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter Page title height (Default is 40%).', 'movedo' ),
						'options' => $movedo_grve_area_height,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_title_min_height',
						'type' => 'text',
						'default' => '200',
						'title' => esc_html__( 'Minimum Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter page title minimum height in px (Default is 200).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'page_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'movedo' ),
						'options' => $movedo_grve_container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'movedo' ),
						'options' => $movedo_grve_content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_title_content_alignment',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the alignemt of the content.', 'movedo' ),
						'options' => $movedo_grve_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Position', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your position for the default page title/description.', 'movedo' ),
						'options' => $movedo_grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your animation for the default page title/description.', 'movedo' ),
						'options' => $movedo_grve_animation_selection,
						'default' => 'fade-in-up',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'page_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the Page Title Background, Color or Image.', 'movedo' ),
						'options' => $movedo_grve_title_bg_mode,
						'default'  => 'color',
					),
					array(
						'id'       => 'page_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'movedo' ),
						'subtitle' => esc_html__( 'Select a background image for the default page title.', 'movedo' ),
						'required' => array( 'page_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'page_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'movedo' ),
						'options' => $movedo_grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'page_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'movedo' ),
						'options' => $movedo_grve_pattern_selection,
						'default' => 'none',
						'required' => array( 'page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'page_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'movedo' ),
						'options' => $movedo_grve_color_selection,
						'default' => 'dark',
						'required' => array( 'page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'page_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'movedo' ),
						'options' => $movedo_grve_opacity_selection,
						'default' => '0',
						'required' => array( 'page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id'   => 'info_style_page_anchor_menu',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Anchor Menu Bar Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Anchor Menu Bar where you can place a custom sticky menu per page.', 'movedo' ),
					),
					array(
						'id' => 'page_anchor_menu_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Anchor Menu Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter Anchor Menu height in px (Default is 60).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'page_anchor_menu_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Anchor Menu Alignment', 'movedo' ),
						'subtitle' => esc_html__( 'Select the alignment of your anchor menu.', 'movedo' ),
						'options' => $movedo_grve_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_anchor_menu_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want to show your anchor menu full width.', 'movedo' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id'   => 'info_style_page_breadcrumbs',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Breadcrumbs Bar Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Breadcrumbs Bar.', 'movedo' ),
					),
					array(
						'id'=>'page_breadcrumbs_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Breadcrumbs', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Breadcrumbs for Single Page.', 'movedo' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id' => 'page_breadcrumbs_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Breadcrumbs Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter Breadcrumbs height in px (Default is 60).', 'movedo' ),
						'validate' => 'numeric',
						'required' => array( 'page_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'page_breadcrumbs_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Breadcrumbs Alignment', 'movedo' ),
						'subtitle' => esc_html__( 'Select the alignment of your breadcrumbs.', 'movedo' ),
						'options' => $movedo_grve_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array( 'page_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'page_breadcrumbs_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want to show your breadcrumbs full width.', 'movedo' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
						'required' => array( 'page_breadcrumbs_enabled', 'equals', '1' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-search',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Search Options', 'movedo'),
				'id' => 'grve_redux_section_search_page_options',
				'subtitle' => esc_html__( 'You can find the basic settings for the search page here.', 'movedo' ),
				'desc' => esc_html__( 'You can find the basic settings for the search page here.', 'movedo' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'   => 'info_style_search_page_header',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Search Page Header Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Set the style for the search page header.', 'movedo' ),
					),
					array(
						'id' => 'search_page_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Page Header Style', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your page header style.', 'movedo' ),
						'options' => $movedo_grve_header_style,
						'default' => 'default',
					),
					array(
						'id' => 'search_page_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Page Header Overlapping', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want the Page Header overlaps the content. Combine this option with the Light or Dark Header.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_search_page_title',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Search Page Title Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Set the style for the search page title.', 'movedo' ),
					),
					array(
						'id' => 'search_page_title_height',
						'type' => 'select',
						'default' => '60',
						'title' => esc_html__( 'Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter page title height (Default is 60%).', 'movedo' ),
						'options' => $movedo_grve_area_height,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'search_page_title_min_height',
						'type' => 'text',
						'default' => '200',
						'title' => esc_html__( 'Minimum Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter page title minimum height in px (Default is 200).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'search_page_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'movedo' ),
						'options' => $movedo_grve_container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'search_page_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'movedo' ),
						'options' => $movedo_grve_content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'search_page_title_content_alignment',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the alignemt of the content.', 'movedo' ),
						'options' => $movedo_grve_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'search_page_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Position', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your position for the search page title/description.', 'movedo' ),
						'options' => $movedo_grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'search_page_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your animation for the search page title/description.', 'movedo' ),
						'options' => $movedo_grve_animation_selection,
						'default' => 'fade-in-up',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'search_page_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the Page Title Background, Color or Image.', 'movedo' ),
						'options' => $movedo_grve_title_bg_mode_limited,
						'default'  => 'color',
					),
					array(
						'id'       => 'search_page_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'movedo' ),
						'subtitle' => esc_html__( 'Select a background image for the search page title.', 'movedo' ),
						'required' => array( 'search_page_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'search_page_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'movedo' ),
						'options' => $movedo_grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'search_page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'search_page_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'movedo' ),
						'options' => $movedo_grve_pattern_selection,
						'default' => 'none',
						'required' => array( 'search_page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'search_page_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'movedo' ),
						'options' => $movedo_grve_color_selection,
						'default' => 'dark',
						'required' => array( 'search_page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'search_page_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'movedo' ),
						'options' => $movedo_grve_opacity_selection,
						'default' => '0',
						'required' => array( 'search_page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id'   => 'info_style_search_page_settings',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Search Page Style and Basic Search Page Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Set the style and basic settings for the search page.', 'movedo' ),
					),
					array(
						'id' => 'search_page_mode',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Mode', 'movedo' ),
						'subtitle' => esc_html__( 'Select the search page mode', 'movedo' ),
						'options' => array(
							'masonry' => esc_html__( 'Masonry' , 'movedo' ),
							'grid' => esc_html__( 'Grid' , 'movedo' ),
							'small' => esc_html__( 'Small Media', 'movedo' ),
						),
						'default' => 'masonry',
					),
					array(
						'id' => 'search_page_shadow_style',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Style', 'movedo' ),
						'subtitle' => esc_html__( 'Select the search style', 'movedo' ),
						'options' =>array(
							'shadow-mode' => esc_html__( 'With Shadow', 'movedo' ),
							'no-shadow-mode' => esc_html__( 'Without Shadow', 'movedo' ),
						),
						'default' => 'shadow-mode',
						'required' => array( 'search_page_mode', '!=', 'small' ),
					),
					array(
						'id' => 'search_page_show_image',
						'type' => 'select',
						'title' => esc_html__( 'Show Search Page Featured Image', 'movedo' ),
						'subtitle' => esc_html__( 'If enabled, Featured image is displayed', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'yes',
					),
					array(
						'id' => 'search_image_mode',
						'type' => 'select',
						'title' => esc_html__( 'Search Grid Image Size', 'movedo' ),
						'subtitle' => esc_html__( 'Select your Search Grid Image Size', 'movedo' ),
						'options' => $movedo_grve_search_grid_image_mode_selection,
						'default' => 'landscape',
						'required' => array(
							array( 'search_page_mode', '!=', 'masonry' ),
							array( 'search_page_show_image', 'equals', 'yes' ),
						),
					),
					array(
						'id' => 'search_masonry_image_mode',
						'type' => 'select',
						'title' => esc_html__( 'Search Masonry Image Size', 'movedo' ),
						'subtitle' => esc_html__( 'Select your Search Masonry Image Size', 'movedo' ),
						'options' => $movedo_grve_search_masonry_image_mode_selection,
						'default' => 'medium',
						'required' => array(
							array( 'search_page_mode','equals', 'masonry' ),
							array( 'search_page_show_image', 'equals', 'yes' ),
						),
					),
					array(
						'id' => 'search_page_columns_large_screen',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Large Screen Columns', 'movedo' ),
						'subtitle' => esc_html__( 'Select the Search Page Columns on large screen devices', 'movedo' ),
						'options' => $movedo_grve_blog_columns_selection,
						'default' => '3',
						'required' => array( 'search_page_mode', '!=', 'small' ),
					),
					array(
						'id' => 'search_page_columns',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Columns', 'movedo' ),
						'subtitle' => esc_html__( 'Select the Search Page Columns', 'movedo' ),
						'options' => $movedo_grve_blog_columns_selection,
						'default' => '3',
						'required' => array( 'search_page_mode', '!=', 'small' ),
					),
					array(
						'id' => 'search_page_columns_tablet_landscape',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Tablet Landscape Columns', 'movedo' ),
						'subtitle' => esc_html__( 'Select responsive column on tablet devices, landscape orientation.', 'movedo' ),
						'options' => $movedo_grve_blog_columns_selection_tablet,
						'default' => '2',
						'required' => array( 'search_page_mode', '!=', 'small' ),
					),
					array(
						'id' => 'search_page_columns_tablet_portrait',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Tablet Portrait Columns', 'movedo' ),
						'subtitle' => esc_html__( 'Select responsive column on tablet devices, portrait orientation.', 'movedo' ),
						'options' => $movedo_grve_blog_columns_selection_tablet,
						'default' => '2',
						'required' => array( 'search_page_mode', '!=', 'small' ),
					),
					array(
						'id' => 'search_page_columns_mobile',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Mobile Columns', 'movedo' ),
						'subtitle' => esc_html__( 'Select responsive column on mobile devices.', 'movedo' ),
						'options' => $movedo_grve_blog_columns_selection_mobile,
						'default' => '1',
						'required' => array( 'search_page_mode', '!=', 'small' ),
					),
					array(
						'id' => 'search_page_heading_tag',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Result Title Tag', 'movedo' ),
						'subtitle' => esc_html__( 'Select tag for your search result title.', 'movedo' ),
						'options' => $movedo_grve_headings_tag_selection,
						'default' => 'h4',
					),
					array(
						'id' => 'search_page_heading',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Result Title Size', 'movedo' ),
						'subtitle' => esc_html__( 'Select size and typography for your search result title.', 'movedo' ),
						'options' => $movedo_grve_headings_selection,
						'default' => 'h4',
					),
					array(
						'id'=>'search_page_excerpt_length_small',
						'type' => 'text',
						'default' => '30',
						'title' => esc_html__( 'Excerpt Length', 'movedo' ),
						'subtitle' => esc_html__( 'Type how many words you want to display in your post excerpts (Default is 30).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'search_page_excerpt_more',
						'type' => 'switch',
						'title' => esc_html__( 'Read More', 'movedo' ),
						'subtitle'=> esc_html__( "Adds a read more button after the excerpt or more quicktag.", 'movedo' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id' => 'search_modal_text',
						'type' => 'text',
						'title' => esc_html__( 'Search Modal Text', 'movedo' ),
						'subtitle' => esc_html__( 'Type the search text of the modal.', 'movedo' ),
						'default' => 'Enter your<br>text here',
					),
					array(
						'id' => 'search_modal_button_text',
						'type' => 'text',
						'title' => esc_html__( 'Search Modal Button Text', 'movedo' ),
						'subtitle' => esc_html__( 'Type the search text of the modal button.', 'movedo' ),
						'default' => 'Start Searching',
					),
					array(
						'id' => 'search_modal_mode',
						'type' => 'select',
						'title' => esc_html__( 'Search Modal Mode', 'movedo' ),
						'subtitle' => esc_html__( 'Select the search modal mode', 'movedo' ),
						'options' => array(
							'typed' => esc_html__( 'Typed Text' , 'movedo' ),
							'static' => esc_html__( 'Static Text' , 'movedo' ),
						),
						'default' => 'typed',
					),
					array(
						'id' => 'search_page_not_found_text',
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Search Page Not Found Content', 'movedo' ),
						'subtitle' => esc_html__( 'Type the content of your search page when no results are found.', 'movedo' ),
						'default' => '<p class="grve-align-center grve-leader-text">Hey there mate!<br />Your lost treasure is not found here...</p><p class="grve-align-center">Check again your spelling and rewrite the content you are seeking for in the search field.</p>',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-briefcase',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Portfolio Options', 'movedo' ),
				'id' => 'grve_redux_section_portfolio_options',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'portfolio_slug',
						'type' => 'text',
						'default' => 'portfolio',
						'title' => esc_html__( 'Slug', 'movedo' ),
						'subtitle' => esc_html__( "Enter Portfolio Slug (Default is 'portfolio'). If you change it, go to Settings - Permalinks and click on Save Changes.", 'movedo' ),
						'desc' => esc_html__( "Slug must not be used anywhere else (e.g: category, page, post).", 'movedo' ),
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Portfolio Layout', 'movedo' ),
						'subtitle' => esc_html__( 'Select the default layout for the Portfolio (single portfolio items). Choose among Full Width, Left Sidebar or Right Sidebar.', 'movedo' ),
						'options' => $movedo_grve_layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'portfolio_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Sidebar', 'movedo' ),
						'subtitle' => esc_html__( 'Select the default sidebar for the single portfolio items.', 'movedo' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Fixed Sidebar', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'portfolio_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Sliding Area Visibility', 'movedo' ),
						'subtitle' => esc_html__( 'Enable the Sliding Area for the single portfolio items.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'portfolio_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Sliding Area Sidebar', 'movedo' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the sliding area.', 'movedo' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_details_text',
						'type' => 'text',
						'title' => esc_html__( 'Portfolio Details Text', 'movedo' ),
						'subtitle' => esc_html__( 'Type the text for the Portfolio Details title.', 'movedo' ),
						"default" => 'Project Details',
					),
					array(
						'id' => 'portfolio_details_heading_tag',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Details Text Heading Tag', 'movedo' ),
						'subtitle' => esc_html__( 'Select the headings tag for your Portfolio Details Text.', 'movedo' ),
						'options' => $movedo_grve_headings_tag_selection,
						'default' => 'div',
					),
					array(
						'id' => 'portfolio_details_link_text',
						'type' => 'text',
						'title' => esc_html__( 'Portfolio Details Link Text', 'movedo' ),
						'subtitle' => esc_html__( 'Type the text for the Portfolio Details link text.', 'movedo' ),
						"default" => 'View Project',
					),
					array(
						'id'=>'portfolio_comments_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Comments Visibility', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable or Disable the comments of your portfolio.', 'movedo' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id'   => 'info_style_portfolio_header',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Portfolio Header Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Set the style for the default portfolio header.', 'movedo' ),
					),
					array(
						'id' => 'portfolio_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Header Style', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your portfolio header style.', 'movedo' ),
						'options' => $movedo_grve_header_style,
						'default' => 'default',
					),
					array(
						'id' => 'portfolio_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Header Overlapping', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want the Portfolio Header overlaps the content. Combine this option with the Light or Dark Header. You can still override this when you edit each single portfolio.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_portfolio_title',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Portfolio Title Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Set the style for the single default portfolio title.', 'movedo' ),
					),
					array(
						'id' => 'portfolio_title_height',
						'type' => 'select',
						'default' => '60',
						'title' => esc_html__( 'Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter portfolio title height (Default is 60%).', 'movedo' ),
						'options' => $movedo_grve_area_height,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_title_min_height',
						'type' => 'text',
						'default' => '200',
						'title' => esc_html__( 'Min Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter portfolio title minimum height in px (Default is 200).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'portfolio_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'movedo' ),
						'options' => $movedo_grve_container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'movedo' ),
						'options' => $movedo_grve_content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_title_content_alignment',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the alignemt of the content.', 'movedo' ),
						'options' => $movedo_grve_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Position', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your position for the default portfolio title/description.', 'movedo' ),
						'options' => $movedo_grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your animation for the default portfolio title/description.', 'movedo' ),
						'options' => $movedo_grve_animation_selection,
						'default' => 'fade-in',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'portfolio_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the Portfolio Title Background, Color or Image.', 'movedo' ),
						'options' => $movedo_grve_title_bg_mode,
						'default'  => 'color',
					),
					array(
						'id'       => 'portfolio_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'movedo' ),
						'subtitle' => esc_html__( 'Select a background image for the default portfolio title.', 'movedo' ),
						'required' => array( 'portfolio_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'movedo' ),
						'options' => $movedo_grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'portfolio_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'portfolio_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'movedo' ),
						'options' => $movedo_grve_pattern_selection,
						'default' => 'none',
						'required' => array( 'portfolio_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'portfolio_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'movedo' ),
						'options' => $movedo_grve_color_selection,
						'default' => 'dark',
						'required' => array( 'portfolio_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'portfolio_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'movedo' ),
						'options' => $movedo_grve_opacity_selection,
						'default' => '0',
						'required' => array( 'portfolio_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id'   => 'info_style_portfolio_anchor_menu',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Anchor Menu Bar Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Anchor Menu Bar where you can place a custom sticky menu per portfolio item.', 'movedo' ),
					),
					array(
						'id' => 'portfolio_anchor_menu_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Anchor Menu Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter Anchor Menu height in px (Default is 60).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'portfolio_anchor_menu_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Anchor Menu Alignment', 'movedo' ),
						'subtitle' => esc_html__( 'Select the alignment of your anchor menu.', 'movedo' ),
						'options' => $movedo_grve_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_anchor_menu_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want to show your anchor menu full width.', 'movedo' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id'   => 'info_style_portfolio_breadcrumbs',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Breadcrumbs Bar Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Breadcrumbs Bar.', 'movedo' ),
					),
					array(
						'id'=>'portfolio_breadcrumbs_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Breadcrumbs', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Breadcrumbs for Single Portfolio.', 'movedo' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id' => 'portfolio_breadcrumbs_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Breadcrumbs Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter Breadcrumbs height in px (Default is 60).', 'movedo' ),
						'validate' => 'numeric',
						'required' => array( 'portfolio_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'portfolio_breadcrumbs_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Breadcrumbs Alignment', 'movedo' ),
						'subtitle' => esc_html__( 'Select the alignment of your breadcrumbs.', 'movedo' ),
						'options' => $movedo_grve_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array( 'portfolio_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'portfolio_breadcrumbs_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want to show your breadcrumbs full width.', 'movedo' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
						'required' => array( 'portfolio_breadcrumbs_enabled', 'equals', '1' ),
					),

					array(
						'id'   => 'info_style_portfolio_nav',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Navigation Bar, Recent Items and Socials', 'movedo' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Navigation Bar, Recent Items and Socials.', 'movedo' ),
					),
					array(
						'id' => 'portfolio_nav_bar_layout',
						'type' => 'select',
						'title' => esc_html__( 'Navigation and Recent Items Layout', 'movedo' ),
						'subtitle' => esc_html__( 'Select the Layout for Navigation and Recent Items', 'movedo' ),
						'options' => array(
							'layout-1' => esc_html__( 'Bottom Navigation & Classic Related', 'movedo' ),
							'layout-2' => esc_html__( 'Bottom Navigation & Related Combo', 'movedo' ),
							'layout-3' => esc_html__( 'Floating Navigation & Classic Related', 'movedo' ),
						),
						'default' => 'layout-1',
					),
					array(
						'id'=>'portfolio_recents_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Recent Items Visibility', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable or Disable the recent items carousel.', 'movedo' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id' => 'portfolio_recent_title',
						'type' => 'text',
						'title' => esc_html__( 'Portfolio Recent Items Title', 'movedo' ),
						'subtitle' => esc_html__( 'Type the text for the portfolio recent items title.', 'movedo' ),
						"default" => 'More Projects',
						'required' => array( 'portfolio_recents_visibility', 'equals', '1' ),
					),
					array(
						'id'=>'portfolio_nav_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Portfolio Navigation Visibility', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable or Disable the visibility of the portfolio navigation.', 'movedo' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id' => 'portfolio_nav_term',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Navigation Same Term', 'movedo' ),
						'subtitle' => esc_html__( 'If selected, only navigation items with the same selected taxonomy term will be displayed.', 'movedo' ),
						'options' => $movedo_grve_portfolio_term_selection,
						'default' => 'none',
						'required' => array( 'portfolio_nav_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'portfolio_backlink_id',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Backlink', 'movedo' ),
						'subtitle' => esc_html__( 'Select the overview page for your portfolio backlink.', 'movedo' ),
						'data' => 'page',
						'default' => '',
						'required' => array( 'portfolio_nav_bar_layout', '!=', 'layout-2' ),
					),
					array(
						'id'             => 'portfolio_nav_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Navigation Bar Spacing', 'movedo' ),
						'subtitle'       => esc_html__( 'Set the spacing, Top and Bottom, of the Navigation Area.', 'movedo' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'movedo'),
						'default'        => array(
							'padding-top'     => '40px',
							'padding-bottom'  => '40px',
							'units'           => 'px',
						),
						'required' => array( 'portfolio_nav_bar_layout', 'equals', 'layout-1' ),
					),
					array(
						'id' => 'portfolio_social',
						'type' => 'checkbox',
						'title' => esc_html__( 'Social Share', 'movedo' ),
						'subtitle' => esc_html__( 'Enable or Disable the social shares you like in the single portfolio items.', 'movedo' ),
						'options' => $movedo_grve_portfolio_social_options,
						'default' => 0,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-shopping-cart',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'WooCommerce Options', 'movedo'),
				'id' => 'grve_redux_section_woocommerce_options',
				'subtitle' => esc_html__( 'You can find the Theme settings for the WooCommerce here.', 'movedo' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'product_tax_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Product Taxonomy Layout', 'movedo' ),
						'subtitle' => esc_html__( 'Select the default layout for the Product Taxonomy. Choose among Full Width, Left Sidebar or Right Sidebar.', 'movedo' ),
						'options' => $movedo_grve_layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'product_tax_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Taxonomy Sidebar', 'movedo' ),
						'subtitle' => esc_html__( 'Select the default sidebar for the single Product Taxonomy.', 'movedo' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_tax_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Taxonomy Fixed Sidebar', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'product_tax_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Product Taxonomy Sliding Area Visibility', 'movedo' ),
						'subtitle' => esc_html__( 'Enable the Sliding Area for the Product Taxonomy.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'product_tax_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Taxonomy Sliding Area Sidebar', 'movedo' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the sliding area.', 'movedo' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id'   => 'info_style_product_tax_header',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Product Taxonomy Header Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Set the style for the default Product Taxonomy header.', 'movedo' ),
					),
					array(
						'id' => 'product_tax_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Product Taxonomy Header Style', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your Product Taxonomy header style.', 'movedo' ),
						'options' => $movedo_grve_header_style,
						'default' => 'default',
					),
					array(
						'id' => 'product_tax_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Product Taxonomy Header Overlapping', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want the Product Taxonomy Header overlaps the content. Combine this option with the Light or Dark Header.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_product_tax_title',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Product Taxonomy Title Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Set the style for the single default Product Taxonomy title.', 'movedo' ),
					),
					array(
						'id' => 'product_tax_title_height',
						'type' => 'select',
						'default' => '60',
						'title' => esc_html__( 'Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter Product Taxonomy title height (Default is 60%).', 'movedo' ),
						'options' => $movedo_grve_area_height,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_tax_title_min_height',
						'type' => 'text',
						'default' => '320',
						'title' => esc_html__( 'Min Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter Product Taxonomy title minimum height in px (Default is 320).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'product_tax_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'movedo' ),
						'options' => $movedo_grve_container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_tax_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'movedo' ),
						'options' => $movedo_grve_content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_tax_title_content_alignment',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the alignemt of the content.', 'movedo' ),
						'options' => $movedo_grve_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_tax_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Position', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your position for the default Product Taxonomy title/description.', 'movedo' ),
						'options' => $movedo_grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_tax_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your animation for the default Product Taxonomy title/description.', 'movedo' ),
						'options' => $movedo_grve_animation_selection,
						'default' => 'fade-in',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'product_tax_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the Product Taxonomy Title Background, Color or Image.', 'movedo' ),
						'options' => $movedo_grve_title_bg_mode_limited,
						'default'  => 'color',
					),
					array(
						'id'       => 'product_tax_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'movedo' ),
						'subtitle' => esc_html__( 'Select a background image for the default Product Taxonomy title.', 'movedo' ),
						'required' => array( 'product_tax_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_tax_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'movedo' ),
						'options' => $movedo_grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'product_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'product_tax_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'movedo' ),
						'options' => $movedo_grve_pattern_selection,
						'default' => 'none',
						'required' => array( 'product_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'product_tax_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'movedo' ),
						'options' => $movedo_grve_color_selection,
						'default' => 'dark',
						'required' => array( 'product_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'product_tax_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'movedo' ),
						'options' => $movedo_grve_opacity_selection,
						'default' => '0',
						'required' => array( 'product_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id'   => 'info_style_product_overview',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Shop Overview Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Set the style for the shop overview.', 'movedo' ),
					),
					array(
						'id' => 'product_overview_image_effect',
						'type' => 'select',
						'title' => esc_html__( 'Loop Product Image effect', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the effect for the overview product image', 'movedo' ),
						'options' => array(
							'none' => esc_html__( 'None', 'movedo' ),
							'second' => esc_html__( 'Second Image on Hover', 'movedo' ),
						),
						'default' => 'second',
					),
					array(
						'id' => 'product_overview_image_zoom_effect',
						'type' => 'select',
						'options' => array(
							'in' => esc_html__( 'Zoom In', 'movedo' ),
							'out' => esc_html__( 'Zoom Out', 'movedo' ),
							'none' => esc_html__( 'None', 'movedo' ),
						),
						'title' => esc_html__( 'Loop Image Zoom Effect', 'movedo' ),
						'subtitle' => esc_html__( 'Choose the image zoom effect.', 'movedo' ),
						'default' => 'none',
					),
					array(
						'id' => 'product_overview_image_size',
						'type' => 'select',
						'options' => array(
							'default' => esc_html__( 'Default', 'movedo' ),
							'square' => esc_html__( 'Square Small Crop', 'movedo' ),
							'landscape' => esc_html__( 'Landscape Small Crop', 'movedo' ),
							'portrait' => esc_html__( 'Portrait Small Crop', 'movedo' ),
							'large' => esc_html__( 'Resize ( Large )', 'movedo' ),
							'medium_large' => esc_html__( 'Resize ( Medium Large )', 'movedo' ),
							'medium' => esc_html__( 'Resize ( Medium )', 'movedo' ),
						),
						'title' => esc_html__( 'Loop Image Size', 'movedo' ),
						'subtitle' => esc_html__( 'Choose the overview image size.', 'movedo' ),
						'default' => 'default',
					),
					array(
						'id' => 'product_loop_columns',
						'type' => 'select',
						'options' => array(
							'2' => '2',
							'3' => '3',
							'4' => '4',
							'5' => '5',
						),
						'default' => '4',
						'title' => esc_html__( 'Loop Columns', 'movedo' ),
						'subtitle' => esc_html__( 'Select the number of columns (Default is 4).', 'movedo' ),
					),
					array(
						'id' => 'product_loop_shop_per_page',
						'type' => 'text',
						'default' => '12',
						'title' => esc_html__( 'Loop Products per Page', 'movedo' ),
						'subtitle' => esc_html__( 'Select how many products per page you want to show (Default is 12).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'product_overview_heading_tag',
						'type' => 'select',
						'title' => esc_html__( 'Loop Product Title Tag', 'movedo' ),
						'subtitle' => esc_html__( 'Select tag for your loop product title.', 'movedo' ),
						'options' => $movedo_grve_headings_tag_selection,
						'default' => 'h3',
					),
					array(
						'id' => 'product_overview_heading',
						'type' => 'select',
						'title' => esc_html__( 'Loop Product Title Size', 'movedo' ),
						'subtitle' => esc_html__( 'Select size and typography for your loop product title.', 'movedo' ),
						'options' => $movedo_grve_headings_selection,
						'default' => 'h6',
					),
					array(
						'id' => 'product_overview_overlay_color',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'movedo' ),
						'options' => $movedo_grve_color_selection,
						'default' => 'light',
					),
					array(
						'id' => 'product_overview_overlay_opacity',
						'type' => 'select',
						'options' => $movedo_grve_opacity_selection_simple,
						'title' => esc_html__( 'Overlay Opacity', 'movedo' ),
						'subtitle' => esc_html__( 'Choose the opacity for the overlay.', 'movedo' ),
						'default' => '90',
					),


				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Single Product Settings', 'movedo' ),
				'id' => 'grve_redux_section_single_product_settings',
				'header' => '',
				'desc' => esc_html__( 'Define your preferences for the Single Products. Notice that most of them can be overridden when you create a single product.', 'movedo' ),
				'submenu' => true,
				'icon' => 'el-icon-shopping-cart',
				'icon_class' => 'el-icon-large',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'product_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Product Layout', 'movedo' ),
						'subtitle' => esc_html__( 'Select the layout for the Single Products. Choose among Full Width, Left Sidebar or Right Sidebar.', 'movedo' ),
						'options' => $movedo_grve_layout_selection,
						'default' => 'right',
					),
					array(
						'id' => 'product_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Sidebar', 'movedo' ),
						'subtitle' => esc_html__( 'Select the sidebar for the Single Products.', 'movedo' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Fixed Sidebar', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'product_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Product Sliding Area Visibility', 'movedo' ),
						'subtitle' => esc_html__( 'Enable the Product Sliding Area if you want.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'product_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Sliding Area Sidebar', 'movedo' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the sliding area.', 'movedo' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id'   => 'info_style_product_header',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Product Header Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Set the style for the default post header.', 'movedo' ),
					),
					array(
						'id' => 'product_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Product Header Style', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your product header style.', 'movedo' ),
						'options' => $movedo_grve_header_style,
						'default' => 'default',
					),
					array(
						'id' => 'product_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Product Header Overlapping', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want the Product Header overlaps the content. Combine this option with the Light or Dark Header. You can still override this when you edit each single product.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_product_title',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Single Product Title Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Set the style for the default single product title.', 'movedo' ),
					),
					array(
						'id' => 'product_title_style',
						'type' => 'select',
						'default' => 'simple',
						'title' => esc_html__( 'Title Style', 'movedo' ),
						'subtitle' => esc_html__( 'Select Product Title Style', 'movedo' ),
						'options' => $movedo_grve_title_style,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_title_height',
						'type' => 'select',
						'default' => '60',
						'title' => esc_html__( 'Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter product title height (Default is 60%).', 'movedo' ),
						'options' => $movedo_grve_area_height,
						'validate' => 'not_empty',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'product_title_min_height',
						'type' => 'text',
						'default' => '200',
						'title' => esc_html__( 'Min Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter product title minimum height in px (Default is 200).', 'movedo' ),
						'validate' => 'numeric',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'product_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'movedo' ),
						'options' => $movedo_grve_container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'product_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'movedo' ),
						'options' => $movedo_grve_content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'product_title_content_alignment',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the alignemt of the content.', 'movedo' ),
						'options' => $movedo_grve_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'product_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Position', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your position for the default product title/description.', 'movedo' ),
						'options' => $movedo_grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'product_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your animation for the default product title/description.', 'movedo' ),
						'options' => $movedo_grve_animation_selection,
						'default' => 'fade-in',
						'validate' => 'not_empty',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id'       => 'product_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the Product Title Background, Color or Image.', 'movedo' ),
						'options' => $movedo_grve_title_bg_mode,
						'default'  => 'color',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id'       => 'product_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'movedo' ),
						'subtitle' => esc_html__( 'Select a background image for the default product title.', 'movedo' ),
						'required' => array(
							array( 'product_title_style', 'equals', 'advanced' ),
							array( 'product_title_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'product_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'movedo' ),
						'options' => $movedo_grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array(
							array( 'product_title_style', 'equals', 'advanced' ),
							array( 'product_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id' => 'product_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'movedo' ),
						'options' => $movedo_grve_pattern_selection,
						'default' => 'none',
						'required' => array(
							array( 'product_title_style', 'equals', 'advanced' ),
							array( 'product_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id' => 'product_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'movedo' ),
						'options' => $movedo_grve_color_selection,
						'default' => 'dark',
						'required' => array(
							array( 'product_title_style', 'equals', 'advanced' ),
							array( 'product_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id' => 'product_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'movedo' ),
						'options' => $movedo_grve_opacity_selection,
						'default' => '0',
						'required' => array(
							array( 'product_title_style', 'equals', 'advanced' ),
							array( 'product_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id'   => 'info_style_product_content_area',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Product Area/Product Content Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Define your preferences for the product area and product content (Tabs).', 'movedo' ),
					),
					array(
						'id' => 'product_area_section_type',
						'type' => 'select',
						'title' => esc_html__( 'Product Area Full Width', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you prefer a full-width Product Content Area.', 'movedo' ),
						'options' => array(
							'fullwidth-background' => esc_html__( 'No', 'movedo' ),
							'fullwidth-element' => esc_html__( 'Yes', 'movedo' ),
						),
						'default' => 'fullwidth-background',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_area_padding_top_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Product Area Top Padding', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the space above the area.', 'movedo' ),
						'options' => $movedo_grve_padding_selection,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_area_padding_bottom_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Product Area bottom Padding', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the space below the product area.', 'movedo' ),
						'options' => $movedo_grve_padding_selection,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_content_width',
						'type' => 'select',
						'title' => esc_html__( 'Product Content Width', 'movedo' ),
						'subtitle' => esc_html__( 'Select the Single Product Content width (only for Full Width Product Layout)', 'movedo' ),
						'options' => $movedo_grve_container_size_selector,
						'default' => '770',
					),
					array(
						'id'   => 'info_style_product_anchor_menu',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Anchor Menu Bar Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Anchor Menu Bar where you can place a custom sticky menu per product.', 'movedo' ),
					),
					array(
						'id' => 'product_anchor_menu_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Anchor Menu Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter Anchor Menu height in px (Default is 60).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'product_anchor_menu_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Anchor Menu Alignment', 'movedo' ),
						'subtitle' => esc_html__( 'Select the alignment of your Anchor Menu in products.', 'movedo' ),
						'options' => $movedo_grve_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_anchor_menu_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want to have full width Anchor Menu.', 'movedo' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id'   => 'info_style_product_breadcrumbs',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Breadcrumbs Bar Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Breadcrumbs Bar.', 'movedo' ),
					),
					array(
						'id'=>'product_breadcrumbs_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Breadcrumbs', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Breadcrumbs for Single Product / Product Categories / Product Tags.', 'movedo' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id' => 'product_breadcrumbs_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Breadcrumbs Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter Breadcrumbs height in px (Default is 60).', 'movedo' ),
						'validate' => 'numeric',
						'required' => array( 'product_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'product_breadcrumbs_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Breadcrumbs Alignment', 'movedo' ),
						'subtitle' => esc_html__( 'Select the alignment of your breadcrumbs.', 'movedo' ),
						'options' => $movedo_grve_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array( 'product_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'product_breadcrumbs_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want to show your breadcrumbs full width.', 'movedo' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
						'required' => array( 'product_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_product_image',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Single Product Image Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Set the style for the single product image.', 'movedo' ),
					),
					array(
						'id' => 'product_image_effect',
						'type' => 'select',
						'title' => esc_html__( 'Product Image effect', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the effect for the main product image', 'movedo' ),
						'options' => array(
							'none' => esc_html__( 'None', 'movedo' ),
							'parallax' => esc_html__( 'Parallax', 'movedo' ),
							'zoom' => esc_html__( 'Zoom', 'movedo' ),
						),
						'default' => 'none',
					),
					array(
						'id' => 'product_image_size',
						'type' => 'select',
						'options' => array(
							'default' => esc_html__( 'Default', 'movedo' ),
							'square' => esc_html__( 'Square Small Crop', 'movedo' ),
							'landscape' => esc_html__( 'Landscape Small Crop', 'movedo' ),
							'portrait' => esc_html__( 'Portrait Small Crop', 'movedo' ),
							'large' => esc_html__( 'Resize ( Large )', 'movedo' ),
							'medium_large' => esc_html__( 'Resize ( Medium Large )', 'movedo' ),
							'medium' => esc_html__( 'Resize ( Medium )', 'movedo' ),
						),
						'title' => esc_html__( 'Product Image Size', 'movedo' ),
						'subtitle' => esc_html__( 'Choose the product image size.', 'movedo' ),
						'default' => 'default',
					),
					array(
						'id' => 'product_gallery_mode',
						'type' => 'select',
						'title' => esc_html__( 'Product Gallery Mode', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the mode for the single product gallery', 'movedo' ),
						'options' => array(
							'none' => esc_html__( 'None', 'movedo' ),
							'popup' => esc_html__( 'Magnific Popup', 'movedo' ),
						),
						'default' => 'popup',
					),
					array(
						'id' => 'product_gallery_title_caption',
						"type" => "select",
						"title" => esc_html__( "Product Gallery Image Title & Caption Visibility", "movedo" ),
						"subtitle" => esc_html__( "Define the visibility for your image title - caption.", "movedo" ),
						'options' => array(
							'none' => esc_html__( 'None' , 'movedo' ),
							'title-caption' => esc_html__( 'Title and Caption' , 'movedo' ),
							'title-only' => esc_html__( 'Title Only' , 'movedo' ),
							'caption-only' => esc_html__( 'Caption Only' , 'movedo' ),
						),
						'default' => 'none',
					),
					array(
						'id'   => 'info_style_product_nav',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Navigation & Socials Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Navigation.', 'movedo' ),
					),
					array(
						'id' => 'product_nav_bar_layout',
						'type' => 'select',
						'title' => esc_html__( 'Navigation and Social Items Layout', 'movedo' ),
						'subtitle' => esc_html__( 'Select the Layout for Navigation and Social Items', 'movedo' ),
						'options' => array(
							'layout-1' => esc_html__( 'Bottom Navigation & Classic Related', 'movedo' ),
							'layout-3' => esc_html__( 'Floating Navigation & Classic Related', 'movedo' ),
						),
						'default' => 'layout-3',
					),
					array(
						'id'=>'product_nav_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Product Navigation Visibility', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable or Disable the visibility of the products navigation.', 'movedo' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id' => 'product_nav_same_term',
						'type' => 'checkbox',
						'title' => esc_html__( 'Product Navigation Same Term', 'movedo' ),
						'subtitle'=> esc_html__( 'If selected, only navigation items from the current taxonomy term will be displayed.', 'movedo' ),
						'default' => 0,
						'required' => array( 'product_nav_visibility', 'equals', '1' ),
					),
					array(
						'id'             => 'product_nav_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Navigation Bar Spacing', 'movedo' ),
						'subtitle'       => esc_html__( 'Set the spacing, Top and Bottom, of the Navigation Area.', 'movedo' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'movedo'),
						'default'        => array(
							'padding-top'     => '40px',
							'padding-bottom'  => '40px',
							'units'           => 'px',
						),
						'required' => array( 'product_nav_bar_layout', 'equals', 'layout-1' ),
					),
					array(
						'id' => 'product_social',
						'type' => 'checkbox',
						'title' => esc_html__( 'Social Share', 'movedo' ),
						'subtitle' => esc_html__( 'Enable or Disable post social shares for the Single Product.', 'movedo' ),
						'options' => $movedo_grve_product_social_options,
						'default' => 0,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-calendar',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Events Calendar Options', 'movedo'),
				'id' => 'grve_redux_section_event_calendar_options',
				'subtitle' => esc_html__( 'You can find the Theme settings for the Events Calendar here.', 'movedo' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'event_tax_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Event Taxonomy Layout', 'movedo' ),
						'subtitle' => esc_html__( 'Select the default layout for the Event Taxonomy. Choose among Full Width, Left Sidebar or Right Sidebar.', 'movedo' ),
						'options' => $movedo_grve_layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'event_tax_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Event Taxonomy Sidebar', 'movedo' ),
						'subtitle' => esc_html__( 'Select the default sidebar for the single Event Taxonomy.', 'movedo' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_tax_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Event Taxonomy Fixed Sidebar', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'event_tax_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Event Taxonomy Sliding Area Visibility', 'movedo' ),
						'subtitle' => esc_html__( 'Enable the Sliding Area for the Event Taxonomy.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'event_tax_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Event Taxonomy Sliding Area Sidebar', 'movedo' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the sliding area.', 'movedo' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id'   => 'info_style_event_tax_header',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Event Taxonomy Header Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Set the style for the default Event Taxonomy header.', 'movedo' ),
					),
					array(
						'id' => 'event_tax_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Event Taxonomy Header Style', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your Event Taxonomy header style.', 'movedo' ),
						'options' => $movedo_grve_header_style,
						'default' => 'default',
					),
					array(
						'id' => 'event_tax_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Event Taxonomy Header Overlapping', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want the Event Taxonomy Header overlaps the content. Combine this option with the Light or Dark Header.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_event_tax_title',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Event Taxonomy Title Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Set the style for the Event Taxonomy title.', 'movedo' ),
					),
					array(
						'id' => 'event_tax_title_height',
						'type' => 'select',
						'default' => '60',
						'title' => esc_html__( 'Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter Event Taxonomy title height (Default is 60%).', 'movedo' ),
						'options' => $movedo_grve_area_height,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_tax_title_min_height',
						'type' => 'text',
						'default' => '320',
						'title' => esc_html__( 'Min Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter Event Taxonomy title minimum height in px (Default is 320).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'event_tax_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'movedo' ),
						'options' => $movedo_grve_container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_tax_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'movedo' ),
						'options' => $movedo_grve_content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_tax_title_content_alignment',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the alignemt of the content.', 'movedo' ),
						'options' => $movedo_grve_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_tax_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Position', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your position for the default Event Taxonomy title/description.', 'movedo' ),
						'options' => $movedo_grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_tax_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your animation for the default Event Taxonomy title/description.', 'movedo' ),
						'options' => $movedo_grve_animation_selection,
						'default' => 'fade-in',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'event_tax_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the Event Taxonomy Title Background, Color or Image.', 'movedo' ),
						'options' => $movedo_grve_title_bg_mode_limited,
						'default'  => 'color',
					),
					array(
						'id'       => 'event_tax_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'movedo' ),
						'subtitle' => esc_html__( 'Select a background image for the default Event Taxonomy title.', 'movedo' ),
						'required' => array( 'event_tax_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'event_tax_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'movedo' ),
						'options' => $movedo_grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'event_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'event_tax_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'movedo' ),
						'options' => $movedo_grve_pattern_selection,
						'default' => 'none',
						'required' => array( 'event_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'event_tax_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'movedo' ),
						'options' => $movedo_grve_color_selection,
						'default' => 'dark',
						'required' => array( 'event_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'event_tax_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'movedo' ),
						'options' => $movedo_grve_opacity_selection,
						'default' => '0',
						'required' => array( 'event_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id'   => 'info_style_event_overview',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Event Overview Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Define your preferences for the event overview.', 'movedo' ),
					),
					array(
						'id' => 'event_overview_image_size',
						'type' => 'select',
						'options' => array(
							'default' => esc_html__( 'Default', 'movedo' ),
							'square' => esc_html__( 'Square Small Crop', 'movedo' ),
							'landscape' => esc_html__( 'Landscape Small Crop', 'movedo' ),
							'portrait' => esc_html__( 'Portrait Small Crop', 'movedo' ),
							'large' => esc_html__( 'Resize ( Large )', 'movedo' ),
							'medium_large' => esc_html__( 'Resize ( Medium Large )', 'movedo' ),
							'medium' => esc_html__( 'Resize ( Medium )', 'movedo' ),
						),
						'title' => esc_html__( 'Event Overview Image Size', 'movedo' ),
						'subtitle' => esc_html__( 'Choose the event overview image size.', 'movedo' ),
						'default' => 'default',
					),
					array(
						'id' => 'event_overview_heading',
						'type' => 'select',
						'title' => esc_html__( 'Event Overview Title Size', 'movedo' ),
						'subtitle' => esc_html__( 'Select size and typography for your event overview title.', 'movedo' ),
						'options' => $movedo_grve_event_headings_selection,
						'default' => 'h2',
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Single Event Settings', 'movedo' ),
				'id' => 'grve_redux_section_single_event_settings',
				'header' => '',
				'desc' => esc_html__( 'Define your preferences for the Single Events. Notice that most of them can be overridden when you create a single event.', 'movedo' ),
				'submenu' => true,
				'icon' => 'el-icon-calendar',
				'icon_class' => 'el-icon-large',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'event_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Event Layout', 'movedo' ),
						'subtitle' => esc_html__( 'Select the layout for the Single Events. Choose among Full Width, Left Sidebar or Right Sidebar.', 'movedo' ),
						'options' => $movedo_grve_layout_selection,
						'default' => 'right',
					),
					array(
						'id' => 'event_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Event Sidebar', 'movedo' ),
						'subtitle' => esc_html__( 'Select the sidebar for the Single Events.', 'movedo' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Event Fixed Sidebar', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'event_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Event Sliding Area Visibility', 'movedo' ),
						'subtitle' => esc_html__( 'Enable the Event Sliding Area if you want.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'event_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Event Sliding Area Sidebar', 'movedo' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the sliding area.', 'movedo' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_content_width',
						'type' => 'select',
						'title' => esc_html__( 'Event Content Width', 'movedo' ),
						'subtitle' => esc_html__( 'Select the Event Content width (only for Full Width Post Layout)', 'movedo' ),
						'options' => $movedo_grve_container_size_selector,
						'default' => '1170',
					),
					array(
						'id'   => 'info_style_event_header',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Event Header Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Set the style for the default post header.', 'movedo' ),
					),
					array(
						'id' => 'event_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Event Header Style', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your event header style.', 'movedo' ),
						'options' => $movedo_grve_header_style,
						'default' => 'default',
					),
					array(
						'id' => 'event_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Event Header Overlapping', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want the Event Header overlaps the content. Combine this option with the Light or Dark Header. You can still override this when you edit each single event.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_event_title',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Single Event Title Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Set the style for the default single event title.', 'movedo' ),
					),
					array(
						'id' => 'event_title_height',
						'type' => 'select',
						'default' => '60',
						'title' => esc_html__( 'Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter event title height (Default is 60%).', 'movedo' ),
						'options' => $movedo_grve_area_height,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_title_min_height',
						'type' => 'text',
						'default' => '200',
						'title' => esc_html__( 'Min Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter event title minimum height in px (Default is 200).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'event_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'movedo' ),
						'options' => $movedo_grve_container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'movedo' ),
						'options' => $movedo_grve_content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_title_content_alignment',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the alignemt of the content.', 'movedo' ),
						'options' => $movedo_grve_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Position', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your position for the default event title/description.', 'movedo' ),
						'options' => $movedo_grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your animation for the default event title/description.', 'movedo' ),
						'options' => $movedo_grve_animation_selection,
						'default' => 'fade-in',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'event_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the Event Title Background, Color or Image.', 'movedo' ),
						'options' => $movedo_grve_title_bg_mode,
						'default'  => 'color',
					),
					array(
						'id'       => 'event_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'movedo' ),
						'subtitle' => esc_html__( 'Select a background image for the default event title.', 'movedo' ),
						'required' => array( 'event_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'event_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'movedo' ),
						'options' => $movedo_grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'event_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'event_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'movedo' ),
						'options' => $movedo_grve_pattern_selection,
						'default' => 'none',
						'required' => array( 'event_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'event_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'movedo' ),
						'options' => $movedo_grve_color_selection,
						'default' => 'dark',
						'required' => array( 'event_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'event_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'movedo' ),
						'options' => $movedo_grve_opacity_selection,
						'default' => '0',
						'required' => array( 'event_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id'   => 'info_style_event_anchor_menu',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Anchor Menu Bar Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Anchor Menu Bar where you can place a custom sticky menu per event.', 'movedo' ),
					),
					array(
						'id' => 'event_anchor_menu_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Anchor Menu Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter Anchor Menu height in px (Default is 60).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'event_anchor_menu_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Anchor Menu Alignment', 'movedo' ),
						'subtitle' => esc_html__( 'Select the alignment of your Anchor Menu in events.', 'movedo' ),
						'options' => $movedo_grve_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_anchor_menu_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want to have full width Anchor Menu.', 'movedo' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id'   => 'info_style_event_breadcrumbs',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Breadcrumbs Bar Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Breadcrumbs Bar.', 'movedo' ),
					),
					array(
						'id'=>'event_breadcrumbs_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Breadcrumbs', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Breadcrumbs for Single Event / Event Categories / Event Tags.', 'movedo' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id' => 'event_breadcrumbs_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Breadcrumbs Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter Breadcrumbs height in px (Default is 60).', 'movedo' ),
						'validate' => 'numeric',
						'required' => array( 'event_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'event_breadcrumbs_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Breadcrumbs Alignment', 'movedo' ),
						'subtitle' => esc_html__( 'Select the alignment of your breadcrumbs.', 'movedo' ),
						'options' => $movedo_grve_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array( 'event_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'event_breadcrumbs_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want to show your breadcrumbs full width.', 'movedo' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
						'required' => array( 'event_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_event_media_settings',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Event Single Media', 'movedo' ),
						'subtitle'=> esc_html__( 'Define your media preferences for the single event.', 'movedo' ),
					),
					array(
						'id' => 'event_image_size',
						'type' => 'select',
						'options' => array(
							'default' => esc_html__( 'Default', 'movedo' ),
							'square' => esc_html__( 'Square Small Crop', 'movedo' ),
							'landscape' => esc_html__( 'Landscape Small Crop', 'movedo' ),
							'landscape-large-wide' => esc_html__( 'Landscape Large Wide Crop', 'movedo' ),
							'portrait' => esc_html__( 'Portrait Small Crop', 'movedo' ),
							'extra-extra-large' => esc_html__( 'Resize ( Extra Extra Large )', 'movedo' ),
							'large' => esc_html__( 'Resize ( Large )', 'movedo' ),
							'medium_large' => esc_html__( 'Resize ( Medium Large )', 'movedo' ),
							'medium' => esc_html__( 'Resize ( Medium )', 'movedo' ),
						),
						'title' => esc_html__( 'Event Image Size', 'movedo' ),
						'subtitle' => esc_html__( 'Choose the event image size.', 'movedo' ),
						'default' => 'default',
					),
					array(
						'id'   => 'info_style_event_nav',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Navigation & Socials Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Navigation.', 'movedo' ),
					),
					array(
						'id' => 'event_nav_bar_layout',
						'type' => 'select',
						'title' => esc_html__( 'Navigation and Social Items Layout', 'movedo' ),
						'subtitle' => esc_html__( 'Select the Layout for Navigation and Social Items', 'movedo' ),
						'options' => array(
							'layout-1' => esc_html__( 'Bottom Navigation & Classic Related', 'movedo' ),
							'layout-3' => esc_html__( 'Floating Navigation & Classic Related', 'movedo' ),
						),
						'default' => 'layout-3',
					),
					array(
						'id'=>'event_nav_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Event Navigation Visibility', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable or Disable the visibility of the events navigation.', 'movedo' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id' => 'event_nav_same_term',
						'type' => 'checkbox',
						'title' => esc_html__( 'Event Navigation Same Term', 'movedo' ),
						'subtitle'=> esc_html__( 'If selected, only navigation items from the current taxonomy term will be displayed.', 'movedo' ),
						'default' => 0,
						'required' => array( 'event_nav_visibility', 'equals', '1' ),
					),
					array(
						'id'             => 'event_nav_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Navigation Bar Spacing', 'movedo' ),
						'subtitle'       => esc_html__( 'Set the spacing, Top and Bottom, of the Navigation Area.', 'movedo' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'movedo'),
						'default'        => array(
							'padding-top'     => '40px',
							'padding-bottom'  => '40px',
							'units'           => 'px',
						),
						'required' => array( 'event_nav_bar_layout', 'equals', 'layout-1' ),
					),
					array(
						'id' => 'event_social',
						'type' => 'checkbox',
						'title' => esc_html__( 'Social Share', 'movedo' ),
						'subtitle' => esc_html__( 'Enable or Disable social shares for the Single Event.', 'movedo' ),
						'options' => $movedo_grve_event_social_options,
						'default' => 0,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-comment-alt',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'bbPress Forum Options', 'movedo'),
				'id' => 'grve_redux_section_bbpress_options',
				'subtitle' => esc_html__( 'You can find the Theme settings for the bbPress here.', 'movedo' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'forum_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Forum Layout', 'movedo' ),
						'subtitle' => esc_html__( 'Select the default layout for the Forum. Choose among Full Width, Left Sidebar or Right Sidebar.', 'movedo' ),
						'options' => $movedo_grve_layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'forum_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Forum Sidebar', 'movedo' ),
						'subtitle' => esc_html__( 'Select the default sidebar for the single Forum.', 'movedo' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'forum_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Forum Fixed Sidebar', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'forum_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Forum Sliding Area Visibility', 'movedo' ),
						'subtitle' => esc_html__( 'Enable the Sliding Area for the Forum.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'forum_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Forum Sliding Area Sidebar', 'movedo' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the sliding area.', 'movedo' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id'   => 'info_style_forum_header',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Forum Header Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Set the style for the default Forum header.', 'movedo' ),
					),
					array(
						'id' => 'forum_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Forum Header Style', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your Forum header style.', 'movedo' ),
						'options' => $movedo_grve_header_style,
						'default' => 'default',
					),
					array(
						'id' => 'forum_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Forum Header Overlapping', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want the Forum Header overlaps the content. Combine this option with the Light or Dark Header.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_forum_title',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Forum Title Settings', 'movedo' ),
						'subtitle'=> esc_html__( 'Set the style for the single default Forum title.', 'movedo' ),
					),
					array(
						'id' => 'forum_title_height',
						'type' => 'select',
						'default' => '60',
						'title' => esc_html__( 'Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter Forum title height (Default is 60%).', 'movedo' ),
						'options' => $movedo_grve_area_height,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'forum_title_min_height',
						'type' => 'text',
						'default' => '320',
						'title' => esc_html__( 'Min Height', 'movedo' ),
						'subtitle' => esc_html__( 'Enter Forum title minimum height in px (Default is 320).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'forum_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'movedo' ),
						'options' => $movedo_grve_container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'forum_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'movedo' ),
						'options' => $movedo_grve_content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'forum_title_content_alignment',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the alignemt of the content.', 'movedo' ),
						'options' => $movedo_grve_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'forum_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Position', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your position for the default Forum title/description.', 'movedo' ),
						'options' => $movedo_grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'forum_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your animation for the default Forum title/description.', 'movedo' ),
						'options' => $movedo_grve_animation_selection,
						'default' => 'fade-in',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'forum_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'movedo' ),
						'subtitle'=> esc_html__( 'Select the Forum Title Background, Color or Image.', 'movedo' ),
						'options' => $movedo_grve_title_bg_mode_limited,
						'default'  => 'color',
					),
					array(
						'id'       => 'forum_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'movedo' ),
						'subtitle' => esc_html__( 'Select a background image for the default Forum title.', 'movedo' ),
						'required' => array( 'forum_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'forum_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'movedo' ),
						'options' => $movedo_grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'forum_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'forum_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'movedo' ),
						'options' => $movedo_grve_pattern_selection,
						'default' => 'none',
						'required' => array( 'forum_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'forum_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'movedo' ),
						'options' => $movedo_grve_color_selection,
						'default' => 'dark',
						'required' => array( 'forum_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'forum_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'movedo' ),
						'options' => $movedo_grve_opacity_selection,
						'default' => '0',
						'required' => array( 'forum_title_bg_mode', '!=', 'color' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Typography Options', 'movedo' ),
				'id' => 'grve_redux_section_typography_options',
				'header' => '',
				'desc' => '',
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Header/Body', 'movedo' ),
				'id' => 'grve_redux_section_typography_header',
				'header' => '',
				'desc' => esc_html__( 'Define your main typography settings.', 'movedo' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_body_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Main Body Fonts', 'movedo' ),
					),
					array(
						'id' => 'body_font',
						'type' => 'typography',
						'title' => esc_html__( 'Body Font', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the body font properties.', 'movedo' ),
						'google' => true,
						'line-height'=> true,
						'text-align'=> false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'default' => array(
							'font-size' => '14px',
							'line-height' => '24px',
							'font-family' => 'Hind Siliguri',
							'font-weight' => '400',
							'letter-spacing' => '0px',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'single_post_font',
						'type' => 'typography',
						'title' => esc_html__( 'Single Post & Product Body Font', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the single post & single product body font properties.', 'movedo' ),
						'google' => true,
						'line-height'=> true,
						'text-align'=> false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'default' => array(
							'font-size' => '18px',
							'line-height' => '30px',
							'font-family' => 'Hind Siliguri',
							'font-weight' => '400',
							'letter-spacing' => '0px',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id'   => 'info_logo_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Logo as text Fonts', 'movedo' ),
					),
					array(
						'id' => 'logo_font',
						'type' => 'typography',
						'title' => esc_html__( 'Logo Font', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the logo font properties.', 'movedo' ),
						'google' => true,
						'line-height'=> false,
						'text-align'=> false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'font-size' => '36px',
							'font-weight' => '700',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id'   => 'info_menu_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Main Menu Fonts', 'movedo' ),
					),
					array(
						'id' => 'main_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Menu Font', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the menu font properties.', 'movedo' ),
						'google' => true,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'font-size' => '12px',
							'font-weight' => '600',
							'text-transform' => 'uppercase',
							'letter-spacing' => '1px',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'sub_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Submenu Font', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the submenu font properties.', 'movedo' ),
						'google' => true,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'font-size' => '12px',
							'font-weight' => '500',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'description_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Menu Description Font', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the Menu description font properties.', 'movedo' ),
						'google' => true,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'font-size' => '11px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id'   => 'info_hidden_menu_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Hidden Menu Fonts', 'movedo' ),
					),
					array(
						'id' => 'hidden_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Hidden Menu Font', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the hidden menu font properties.', 'movedo' ),
						'google' => true,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'font-size' => '12px',
							'font-weight' => '600',
							'text-transform' => 'uppercase',
							'letter-spacing' => '1px',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'sub_hidden_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Hidden Submenu Font', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the hidden submenu font properties.', 'movedo' ),
						'google' => true,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'font-size' => '12px',
							'font-weight' => '500',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'description_hidden_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Hidden Menu Description Font', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the hidden menu description font properties.', 'movedo' ),
						'google' => true,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'font-size' => '11px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Headings (H1-H6)', 'movedo' ),
				'id' => 'grve_redux_section_typography_headings',
				'header' => '',
				'desc' => esc_html__( 'Define your Typography Headings ( H1-H6 ).', 'movedo' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_headers_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Headings Fonts', 'movedo' ),
					),
					array(
						'id' => 'h1_font',
						'type' => 'typography',
						'title' => esc_html__( 'H1 Font', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the H1 font.', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'text-transform' => 'none',
							'font-weight' => '700',
							'font-size' => '30px',
							'line-height' => '36px',
							'letter-spacing' => '-1.5px',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'h2_font',
						'type' => 'typography',
						'title' => esc_html__( 'H2 Font', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the H2 font.', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'text-transform' => 'none',
							'font-weight' => '600',
							'font-size' => '24px',
							'line-height' => '30px',
							'letter-spacing' => '',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'h3_font',
						'type' => 'typography',
						'title' => esc_html__( 'H3 Font', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the H3 font.', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'text-transform' => 'none',
							'font-weight' => '600',
							'font-size' => '20px',
							'line-height' => '28px',
							'letter-spacing' => '',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'h4_font',
						'type' => 'typography',
						'title' => esc_html__( 'H4 Font', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the H4 font.', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'text-transform' => 'none',
							'font-weight' => '600',
							'font-size' => '18px',
							'line-height' => '24px',
							'letter-spacing' => '',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'h5_font',
						'type' => 'typography',
						'title' => esc_html__( 'H5 Font', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the H5 font.', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'text-transform' => 'none',
							'font-weight' => '600',
							'font-size' => '16px',
							'line-height' => '20px',
							'letter-spacing' => '',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'h6_font',
						'type' => 'typography',
						'title' => esc_html__( 'H6 Font', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the H6 font.', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'text-transform' => 'none',
							'font-weight' => '600',
							'font-size' => '14px',
							'line-height' => '18px',
							'letter-spacing' => '',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Titles/Descriptions', 'movedo' ),
				'id' => 'grve_redux_section_typography_titles',
				'header' => '',
				'desc' => esc_html__( 'Define your typography for titles/descriptions.', 'movedo' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_page_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Page/Blog Typography', 'movedo' ),
					),
					array(
						'id' => 'page_title',
						'type' => 'typography',
						'title' => esc_html__( 'Page Title', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the font for the default page titles and for the assigned blog page in case you have set a Static Page as blog page in Settings > Reading > Front Page Displays. (Archives / Categories / Tags overview pages)', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'font-size' => '48px',
							'line-height' => '60px',
							'font-weight' => '700',
							'text-transform' => 'none',
							'letter-spacing' => '-1.3px',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'page_description',
						'type' => 'typography',
						'title' => esc_html__( 'Page Description', 'movedo' ),
						'subtitle' => esc_html__( 'Specify font for the page description and for the description of the assigned blog page in case you have set a Static Page as blog page in Settings > Reading > Front Page Displays. (Archives / Categories / Tags overview pages)', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Hind Siliguri',
							'font-size' => '20px',
							'line-height' => '30px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id'   => 'info_post_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Single Post Typography', 'movedo' ),
					),
					array(
						'id' => 'post_simple_title',
						'type' => 'typography',
						'title' => esc_html__( 'Post Simple Title', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the font for the single post simple title.', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'font-size' => '36px',
							'line-height' => '48px',
							'font-weight' => '600',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'post_title',
						'type' => 'typography',
						'title' => esc_html__( 'Post Title', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the font for the single post titles.', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'font-size' => '48px',
							'line-height' => '60px',
							'font-weight' => '700',
							'text-transform' => 'none',
							'letter-spacing' => '-1.3px',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'post_title_desc',
						'type' => 'typography',
						'title' => esc_html__( 'Post Description', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the font for the single post description.', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Hind Siliguri',
							'font-size' => '20px',
							'line-height' => '30px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '1px',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'post_title_meta',
						'type' => 'typography',
						'title' => esc_html__( 'Post Meta', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the font for meta ( categories ) in the post title section.', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'font-size' => '11px',
							'line-height' => '14px',
							'font-weight' => '700',
							'text-transform' => 'uppercase',
							'letter-spacing' => '2px',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'post_title_extra_meta',
						'type' => 'typography',
						'title' => esc_html__( 'Post Extra Meta', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the font for extra meta ( Author/Date/Comments ) in the post title section.', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'font-size' => '11px',
							'font-weight' => '600',
							'text-transform' => 'uppercase',
							'letter-spacing' => '',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id'   => 'info_portfolio_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Portfolio Typography', 'movedo' ),
					),
					array(
						'id' => 'portfolio_title',
						'type' => 'typography',
						'title' => esc_html__( 'Portfolio Title', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the font for the default single portfolio titles.', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'font-size' => '48px',
							'line-height' => '60px',
							'font-weight' => '700',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'portfolio_description',
						'type' => 'typography',
						'title' => esc_html__( 'Portfolio Description', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the font for the default single portfolio description.', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Hind Siliguri',
							'font-size' => '20px',
							'line-height' => '30px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '1px',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id'   => 'info_forum_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'bbPress Forum Typography', 'movedo' ),
					),
					array(
						'id' => 'forum_title',
						'type' => 'typography',
						'title' => esc_html__( 'Forum Title', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the font for the forum titles.', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'font-size' => '48px',
							'line-height' => '60px',
							'font-weight' => '700',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id'   => 'info_woocommerce_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'WooCommerce Typography', 'movedo' ),
					),
					array(
						'id' => 'product_simple_title',
						'type' => 'typography',
						'title' => esc_html__( 'WooCommerce Product Simple Title', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the font for the product simple title', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'font-size' => '48px',
							'line-height' => '60px',
							'font-weight' => '700',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'product_short_description',
						'type' => 'typography',
						'title' => esc_html__( 'WooCommerce Product Short Description', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the font for the product short description', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Hind Siliguri',
							'font-size' => '16px',
							'line-height' => '28px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '0px',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'product_tax_title',
						'type' => 'typography',
						'title' => esc_html__( 'WooCommerce Title', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the font for the product titles', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'font-size' => '60px',
							'line-height' => '72px',
							'font-weight' => '700',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'product_tax_description',
						'type' => 'typography',
						'title' => esc_html__( 'WooCommerce Title Description', 'movedo' ),
						'subtitle' => esc_html__( 'Specify font for the product title description', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Hind Siliguri',
							'font-size' => '20px',
							'line-height' => '30px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '0px',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id'   => 'info_events_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Events Calendar Typography', 'movedo' ),
					),
					array(
						'id' => 'event_simple_title',
						'type' => 'typography',
						'title' => esc_html__( 'Event Simple Title', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the font for the event simple title', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'font-size' => '48px',
							'line-height' => '60px',
							'font-weight' => '700',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'event_tax_title',
						'type' => 'typography',
						'title' => esc_html__( 'Events Title', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the font for the event titles', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'font-size' => '60px',
							'line-height' => '72px',
							'font-weight' => '700',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'event_tax_description',
						'type' => 'typography',
						'title' => esc_html__( 'Events Description', 'movedo' ),
						'subtitle' => esc_html__( 'Specify font for the events description', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Hind Siliguri',
							'font-size' => '20px',
							'line-height' => '30px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '0px',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Feature Section', 'movedo' ),
				'id' => 'grve_redux_section_typography_feature_section',
				'header' => '',
				'desc' => esc_html__( 'Define your typography for feature section.', 'movedo' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_feature_typography_custom_height',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Feature Section Typography with Custom Height', 'movedo' ),
					),
					array(
						'id' => 'feature_subheading_custom_font',
						'type' => 'typography',
						'title' => esc_html__( 'Sub Heading', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the font for the sub-heading in the feature section.', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'font-size' => '16px',
							'line-height' => '30px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '0px',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'feature_title_custom_font',
						'type' => 'typography',
						'title' => esc_html__( 'Title', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the font for the title in the feature section.', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'font-size' => '48px',
							'line-height' => '60px',
							'font-weight' => '700',
							'text-transform' => 'none',
							'letter-spacing' => '-1.3px',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'feature_desc_custom_font',
						'type' => 'typography',
						'title' => esc_html__( 'Description', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the font for the description in the feature section.', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Hind Siliguri',
							'font-size' => '20px',
							'line-height' => '30px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '1px',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id'   => 'info_feature_typography_full',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Feature Section Typography with Fullscreen mode', 'movedo' ),
					),
					array(
						'id' => 'feature_subheading_full_font',
						'type' => 'typography',
						'title' => esc_html__( 'Sub Heading', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the font for the sub-heading in the feature section.', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'font-size' => '16px',
							'line-height' => '30px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '0px',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'feature_title_full_font',
						'type' => 'typography',
						'title' => esc_html__( 'Title', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the font for the title in the feature section.', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'font-size' => '90px',
							'line-height' => '100px',
							'font-weight' => '700',
							'text-transform' => 'none',
							'letter-spacing' => '-2px',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'feature_desc_full_font',
						'type' => 'typography',
						'title' => esc_html__( 'Description', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the font for the  description in the feature section.', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Hind Siliguri',
							'font-size' => '24px',
							'line-height' => '30px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Extras', 'movedo' ),
				'id' => 'grve_redux_section_typography_extras',
				'header' => '',
				'desc' => esc_html__( 'Define your typography for extra fields ( widgets, special texts, custom fonts .etc ).', 'movedo' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'widgets_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Widgets Typography', 'movedo' ),
					),
					array(
						'id' => 'widget_title',
						'type' => 'typography',
						'title' => esc_html__( 'Widgets Title', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the style for the widget titles.', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'font-size' => '12px',
							'line-height' => '24px',
							'font-weight' => '600',
							'text-transform' => 'uppercase',
							'letter-spacing' => '',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'widget_text',
						'type' => 'typography',
						'title' => esc_html__( 'Widgets Text', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the style for the widget texts.', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Hind Siliguri',
							'font-size' => '14px',
							'line-height' => '24px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id'   => 'info_special_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Special Text Typography', 'movedo' ),
					),
					array(
						'id' => 'quote_text',
						'type' => 'typography',
						'title' => esc_html__( 'Quote Text', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the style for the quote text.', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Georgia, serif',
							'font-size' => '24px',
							'line-height' => '40px',
							'font-weight' => '400',
							'font-style' => 'italic',
							'text-transform' => 'none',
							'letter-spacing' => '',
							'google' => false,
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'leader_text',
						'type' => 'typography',
						'title' => esc_html__( 'Leader Text', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the style for the leader text. This is used in various elements (Text block, Testimonial...)', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Hind Siliguri',
							'font-size' => '18px',
							'line-height' => '30px',
							'font-weight' => '300',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'subtitle_text',
						'type' => 'typography',
						'title' => esc_html__( 'Subtitle Text', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the style for the subtitle text. This is used in various elements (Slogan Subtitle...)', 'movedo' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Hind Siliguri',
							'font-size' => '12px',
							'line-height' => '16px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '0px',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'small_text',
						'type' => 'typography',
						'title' => esc_html__( 'Small Text', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the style for the small text. This is used in various elements (Tags, Post Meta...)', 'movedo' ),
						'google' => true,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Hind Siliguri',
							'font-size' => '11px',
							'font-weight' => '400',
							'text-transform' => 'uppercase',
							'letter-spacing' => '0.5px',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'link_text',
						'type' => 'typography',
						'title' => esc_html__( 'Link Text', 'movedo' ),
						'subtitle' => esc_html__( 'Specify the style for the link text. This is used in various elements (Buttons, Read More...)', 'movedo' ),
						'google' => true,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Poppins',
							'font-size' => '11px',
							'font-weight' => '600',
							'text-transform' => 'uppercase',
							'letter-spacing' => '',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id'   => 'info_custom_font_family',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Custom Font Family', 'movedo' ),
					),
					array(
						'id' => 'custom_font_family_1',
						'type' => 'typography',
						'title' => esc_html__( 'Custom Font Family 1', 'movedo' ),
						'subtitle' => esc_html__( 'This is used in various elements (Title, Slogan, Callout...)', 'movedo' ),
						'google' => true,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'font-size' => false,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'text-transform' => 'none',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'custom_font_family_2',
						'type' => 'typography',
						'title' => esc_html__( 'Custom Font Family 2', 'movedo' ),
						'subtitle' => esc_html__( 'This is used in various elements (Title, Slogan, Callout...)', 'movedo' ),
						'google' => true,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'font-size' => false,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'text-transform' => 'none',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'custom_font_family_3',
						'type' => 'typography',
						'title' => esc_html__( 'Custom Font Family 3', 'movedo' ),
						'subtitle' => esc_html__( 'This is used in various elements (Title, Slogan, Callout...)', 'movedo' ),
						'google' => true,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'font-size' => false,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'text-transform' => 'none',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
					array(
						'id' => 'custom_font_family_4',
						'type' => 'typography',
						'title' => esc_html__( 'Custom Font Family 4', 'movedo' ),
						'subtitle' => esc_html__( 'This is used in various elements (Title, Slogan, Callout...)', 'movedo' ),
						'google' => true,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'font-size' => false,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'text-transform' => 'none',
						),
						'fonts' => $movedo_grve_std_fonts,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Responsive Typography', 'movedo' ),
				'id' => 'grve_redux_section_responsive_typography',
				'header' => '',
				'desc' => '',
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-fontsize',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Responsive Headings', 'movedo' ),
				'id' => 'grve_redux_section_responsive_typography_headings',
				'header' => '',
				'desc' => esc_html__( 'Define your responsiveness for the Typography Headings ( H1-H6 ).', 'movedo' ),
				'submenu' => true,
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-fontsize',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_typography_small_desktop_headings',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Small Desktop', 'movedo' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 1201px) and (max-width: 1440px)', 'movedo' ),
					),
					array(
						'id' => 'typography_small_desktop_threshold_headings',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'movedo' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_small_desktop_ratio_headings',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'movedo' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'movedo' ),
						'options' => $movedo_grve_ratio_selection,
						'default' => '1',
					),
					array(
						'id'   => 'info_typography_tablet_landscape_headings',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Tablet Landscape', 'movedo' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 960px) and (max-width: 1200px)', 'movedo' ),
					),
					array(
						'id' => 'typography_tablet_landscape_threshold_headings',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'movedo' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_landscape_ratio_headings',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'movedo' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'movedo' ),
						'options' => $movedo_grve_ratio_selection,
						'default' => '0.9',
					),
					array(
						'id'   => 'info_typography_tablet_portrait_headings',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Tablet Portrait', 'movedo' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 768px) and (max-width: 959px)', 'movedo' ),
					),
					array(
						'id' => 'typography_tablet_portrait_threshold_headings',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'movedo' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_portrait_ratio_headings',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'movedo' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'movedo' ),
						'options' => $movedo_grve_ratio_selection,
						'default' => '0.8',
					),
					array(
						'id'   => 'info_typography_mobile_headings',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Mobile', 'movedo' ),
						'subtitle'=> esc_html__( 'Screen (max-width: 767px)', 'movedo' ),
					),
					array(
						'id' => 'typography_mobile_threshold_headings',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'movedo' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_mobile_ratio_headings',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'movedo' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'movedo' ),
						'options' => $movedo_grve_ratio_selection,
						'default' => '0.7',
					),
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Responsive First Group', 'movedo' ),
				'id' => 'grve_redux_section_responsive_typography_first_group',
				'header' => '',
				'desc' => esc_html__( 'Define your responsiveness Typography for the following elements: Page Title, Post Title, Portfolio Title, Product Title, Feature Section Title, Feature Section Description with Fullscreen mode.', 'movedo' ),
				'submenu' => true,
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-fontsize',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_typography_small_desktop',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Small Desktop', 'movedo' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 1201px) and (max-width: 1440px)', 'movedo' ),
					),
					array(
						'id' => 'typography_small_desktop_threshold',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'movedo' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_small_desktop_ratio',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'movedo' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'movedo' ),
						'options' => $movedo_grve_ratio_selection,
						'default' => '1',
					),
					array(
						'id'   => 'info_typography_tablet_landscape',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Tablet Landscape', 'movedo' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 960px) and (max-width: 1200px)', 'movedo' ),
					),
					array(
						'id' => 'typography_tablet_landscape_threshold',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'movedo' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_landscape_ratio',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'movedo' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'movedo' ),
						'options' => $movedo_grve_ratio_selection,
						'default' => '0.9',
					),
					array(
						'id'   => 'info_typography_tablet_portrait',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Tablet Portrait', 'movedo' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 768px) and (max-width: 959px)', 'movedo' ),
					),
					array(
						'id' => 'typography_tablet_portrait_threshold',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'movedo' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_portrait_ratio',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'movedo' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'movedo' ),
						'options' => $movedo_grve_ratio_selection,
						'default' => '0.85',
					),
					array(
						'id'   => 'info_typography_mobile',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Mobile', 'movedo' ),
						'subtitle'=> esc_html__( 'Screen (max-width: 767px)', 'movedo' ),
					),
					array(
						'id' => 'typography_mobile_threshold',
						'type' => 'text',
						'default' => '18',
						'title' => esc_html__( 'Size Threshold', 'movedo' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 18).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_mobile_ratio',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'movedo' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'movedo' ),
						'options' => $movedo_grve_ratio_selection,
						'default' => '0.6',
					),
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Responsive Second Group', 'movedo' ),
				'id' => 'grve_redux_section_responsive_typography_second_group',
				'header' => '',
				'desc' => esc_html__( 'Define your responsiveness Typography for the following elements: Page Description, Post Description, Portfolio Description, Product Description, Feature Section Description with Custom Height, Leader Text, Subtitle Text, Link Texts, Menus and Buttons.', 'movedo' ),
				'submenu' => true,
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-fontsize',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_typography_small_desktop2',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Small Desktop', 'movedo' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 1201px) and (max-width: 1440px)', 'movedo' ),
					),
					array(
						'id' => 'typography_small_desktop_threshold2',
						'type' => 'text',
						'default' => '14',
						'title' => esc_html__( 'Size Threshold', 'movedo' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 14).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_small_desktop_ratio2',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'movedo' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'movedo' ),
						'options' => $movedo_grve_ratio_selection,
						'default' => '1',
					),
					array(
						'id'   => 'info_typography_tablet_landscape2',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Tablet Landscape', 'movedo' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 960px) and (max-width: 1200px)', 'movedo' ),
					),
					array(
						'id' => 'typography_tablet_landscape_threshold2',
						'type' => 'text',
						'default' => '14',
						'title' => esc_html__( 'Size Threshold', 'movedo' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 14).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_landscape_ratio2',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'movedo' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'movedo' ),
						'options' => $movedo_grve_ratio_selection,
						'default' => '0.9',
					),
					array(
						'id'   => 'info_typography_tablet_portrait2',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Tablet Portrait', 'movedo' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 768px) and (max-width: 959px)', 'movedo' ),
					),
					array(
						'id' => 'typography_tablet_portrait_threshold2',
						'type' => 'text',
						'default' => '14',
						'title' => esc_html__( 'Size Threshold', 'movedo' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 14).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_portrait_ratio2',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'movedo' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'movedo' ),
						'options' => $movedo_grve_ratio_selection,
						'default' => '0.8',
					),
					array(
						'id'   => 'info_typography_mobile2',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Mobile', 'movedo' ),
						'subtitle'=> esc_html__( 'Screen (max-width: 767px)', 'movedo' ),
					),
					array(
						'id' => 'typography_mobile_threshold2',
						'type' => 'text',
						'default' => '13',
						'title' => esc_html__( 'Size Threshold', 'movedo' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 13).', 'movedo' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_mobile_ratio2',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'movedo' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'movedo' ),
						'options' => $movedo_grve_ratio_selection,
						'default' => '0.8',
					),
				),
			);

			$this->sections[] = array(
				'icon' => 'el-icon-file-edit',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'CSS / JS Options', 'movedo' ),
				'desc' => esc_html__( 'Configure your custom css and javascript in the areas below', 'movedo' ),
				'id' => 'grve_redux_section_css_js_options',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'css_code',
						'type' => 'ace_editor',
						'title' => esc_html__( 'CSS Code', 'movedo' ),
						'subtitle' => esc_html__( 'Paste your CSS code here.', 'movedo' ),
						'mode' => 'css',
						'theme' => 'monokai',
						'desc' => '',
						'default' => ''
					),
					array(
						'id' => 'custom_js',
						'type' => 'ace_editor',
						'mode' => 'javascript',
						'theme' => 'chrome',
						'title' => esc_html__( 'JS Code', 'movedo' ),
						'subtitle' => esc_html__( 'Add your custom JavaScript code here. Please do not include any script tags.', 'movedo' ),
						'desc' => '',
						'default' => ''
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Style Options', 'movedo' ),
				'id' => 'grve_redux_section_style_options',
				'desc' => sprintf( wp_kses( __( 'To customize the color scheme, please use the <a href="%s">Live Color Customizer</a>.', 'movedo' ), array( 'br' => array(), 'a' => array( 'href' => true, 'target' => true ) ) ), esc_url( admin_url('/customize.php') ) ),
				'customizer' => false,
				'fields' => array(
					array(
						'id'    => 'info_style_color_preset',
						'type'  => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Skin Presets', 'movedo' ),
					),
					array(
						'id'        => 'skin_preset',
						'type'      => 'image_select',
						'presets'   => true,
						'title'     => esc_html__( 'Select your Skin', 'movedo' ),
						'default'   => 0,
						'subtitle'  => esc_html__( 'Use the preset as you wish in order to customize your color scheme.', 'movedo' ),
						'options'   => array(
							'palette-1'  => array('img' => get_template_directory_uri() . '/includes/images/skins/palette-1.png', 'presets' => $movedo_grve_skin_palette_1 ),
							'palette-2'  => array('img' => get_template_directory_uri() . '/includes/images/skins/palette-2.png', 'presets' => $movedo_grve_skin_palette_2 ),
							'palette-3'  => array('img' => get_template_directory_uri() . '/includes/images/skins/palette-3.png', 'presets' => $movedo_grve_skin_palette_3 ),
							'palette-4'  => array('img' => get_template_directory_uri() . '/includes/images/skins/palette-4.png', 'presets' => $movedo_grve_skin_palette_4 ),
							'palette-5'  => array('img' => get_template_directory_uri() . '/includes/images/skins/palette-5.png', 'presets' => $movedo_grve_skin_palette_5 ),
							'palette-6'  => array('img' => get_template_directory_uri() . '/includes/images/skins/palette-6.png', 'presets' => $movedo_grve_skin_palette_6 ),
						),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Top Bar', 'movedo' ),
				'id' => 'grve_redux_section_colors_top_bar',
				'desc' => esc_html__( 'Set your color preferences for the TopBar (you will see the changes in the live preview only if TopBar is enabled).', 'movedo' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
					//Top Bar Color Settings
					array(
						'id'          => 'top_bar_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Top Bar Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Background color for your Top Bar.', 'movedo' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'top_bar_font_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Top Bar Font Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Font color for your Top Bar.', 'movedo' ),
						'default'     => '#777777',
						'transparent' => false,
					),
					array(
						'id'          => 'top_bar_link_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Top Bar Link Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Link color for your Top Bar.', 'movedo' ),
						'default'     => '#777777',
						'transparent' => false,
					),
					array(
						'id'          => 'top_bar_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Top Bar Hover Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Hover color for your Top Bar.', 'movedo' ),
						'default'     => '#0652FD',
						'transparent' => false,
					),
				)
			);
			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Header / Menu', 'movedo' ),
				'id' => 'grve_redux_section_colors_header_menu',
				'desc' => esc_html__( 'Set your color preferences for the Header and Menu.', 'movedo' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);
			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Default Header', 'movedo' ),
				'id' => 'grve_redux_section_colors_default_header',
				'desc' => esc_html__( 'Set your color preferences for the Default Header. Keep in mind that the basic settings for the Default Header are in Theme Options > Header Options.', 'movedo' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Default Header Color Settings
					array(
						'id'       => 'default_header_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a background color for the header.', 'movedo' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'default_header_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Background Opacity', 'movedo' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the header.', 'movedo' ),
						'options' => $movedo_grve_opacity_selection,
						"default" => '1',
					),
					array(
						'id'       => 'default_header_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a border color for the header.', 'movedo' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'default_header_border_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Border Opacity', 'movedo' ),
						'subtitle'    => esc_html__( 'Select opacity for the border of the header.', 'movedo' ),
						'options' => $movedo_grve_opacity_selection,
						"default" => '0.10',
					),
					//Menu Color Settings
					array(
						'id'          => 'default_header_menu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu text.', 'movedo' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_menu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Hover Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover menu text.', 'movedo' ),
						'default'     => '#0652FD',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_menu_type_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu type. This will affect if you select the button or underline type.', 'movedo' ),
						'default'     => '#eef1f6',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_menu_type_color_hover',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Hover Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover menu type. This will affect if you select the button or underline type.', 'movedo' ),
						'default'     => '#0652FD',
						'transparent' => false,
					),
					//Sub Menu Color Settings
					array(
						'id'          => 'default_header_submenu_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a background color for the sub menu.', 'movedo' ),
						'default'     => '#171a1d',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_submenu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Text Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the sub menu text.', 'movedo' ),
						'default'     => '#777777',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_submenu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Text Hover/Active Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover or active sub menu text.', 'movedo' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_submenu_text_bg_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Hover/Active Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a background color for the hover or active sub menu.', 'movedo' ),
						'default'     => '#171a1d',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_submenu_column_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Column Title Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the sub menu column titles ( Used in mega menu ).', 'movedo' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_submenu_column_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Column Titles Hover/Active Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover or active sub menu column titles ( Used in mega menu ).', 'movedo' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_submenu_border_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Border Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a border color for the sub menu.', 'movedo' ),
						'default'     => '#333638',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_label_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Label Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a background color for the label.', 'movedo' ),
						'default'     => '#454545',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_label_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Label Text Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a text color for the label.', 'movedo' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Logo on Top Header', 'movedo' ),
				'id' => 'grve_redux_section_colors_logotop_header',
				'desc' => esc_html__( 'Set your color preferences for the Logo on top Header. Keep in mind that the basic settings for the Logo on top Header are in Theme Options > Header Options.', 'movedo' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Logo on top Header Color Settings
					array(
						'id'       => 'logo_top_header_logo_area_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Logo Area Background Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a background color for the logo area.', 'movedo' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'logo_top_header_logo_area_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Logo Area Background Opacity', 'movedo' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the logo area.', 'movedo' ),
						'options' => $movedo_grve_opacity_selection,
						"default" => '1',
					),
					array(
						'id'       => 'logo_top_header_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a border color for the header.', 'movedo' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'logo_top_header_border_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Border Opacity', 'movedo' ),
						'subtitle'    => esc_html__( 'Select opacity for the border of the header.', 'movedo' ),
						'options' => $movedo_grve_opacity_selection,
						"default" => '0.10',
					),
					array(
						'id'       => 'logo_top_header_menu_area_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Menu Area Background Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a background color for the menu area.', 'movedo' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'logo_top_header_menu_area_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Menu Area Background Opacity', 'movedo' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the menu area.', 'movedo' ),
						'options' => $movedo_grve_opacity_selection,
						"default" => '1',
					),
					//Menu Color Settings
					array(
						'id'          => 'logo_top_header_menu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu text.', 'movedo' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_menu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Hover Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover menu text.', 'movedo' ),
						'default'     => '#0652FD',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_menu_type_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu type. This will affect if you select the button or underline type.', 'movedo' ),
						'default'     => '#eef1f6',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_menu_type_color_hover',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Hover Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover menu type. This will affect if you select the button or underline type.', 'movedo' ),
						'default'     => '#0652FD',
						'transparent' => false,
					),
					//Sub Menu Color Settings
					array(
						'id'          => 'logo_top_header_submenu_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a background color for the sub menu.', 'movedo' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_submenu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Text Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the sub menu text.', 'movedo' ),
						'default'     => '#777777',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_submenu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Text Hover/Active Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover or active sub menu text.', 'movedo' ),
						'default'     => '#0652FD',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_submenu_text_bg_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Hover/Active Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a background color for the hover or active sub menu.', 'movedo' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_submenu_column_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Column Title Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the sub menu column titles ( Used in mega menu ).', 'movedo' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_submenu_column_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Column Titles Hover/Active Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover or active sub menu column titles ( Used in mega menu ).', 'movedo' ),
						'default'     => '#0652FD',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_submenu_border_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Border Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a border color for the sub menu.', 'movedo' ),
						'default'     => '#eef1f6',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Side Header', 'movedo' ),
				'id' => 'grve_redux_section_colors_side_header',
				'desc' => esc_html__( 'Set your color preferences for the Side Header. Keep in mind that the basic settings for the Side Header are in Theme Options > Header Options.', 'movedo' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Logo on top Header Color Settings
					array(
						'id'       => 'side_header_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a background color for the header.', 'movedo' ),
						'default'  => '#f7f7f7',
						'transparent' => false,
					),
					array(
						'id' => 'side_header_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Background Opacity', 'movedo' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the header.', 'movedo' ),
						'options' => $movedo_grve_opacity_selection,
						"default" => '1',
					),
					//Menu Color Settings
					array(
						'id'          => 'side_header_menu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu text.', 'movedo' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'side_header_menu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Hover Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover menu text.', 'movedo' ),
						'default'     => '#0652FD',
						'transparent' => false,
					),
					//Sub Menu Color Settings
					array(
						'id'          => 'side_header_submenu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Text Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the sub menu text.', 'movedo' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'side_header_submenu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Text Hover/Active Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover or active sub menu text.', 'movedo' ),
						'default'     => '#0652FD',
						'transparent' => false,
					),
					array(
						'id'          => 'side_header_border_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Border Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a border color.', 'movedo' ),
						'default'     => '#323232',
						'transparent' => false,
					),
					array(
						'id' => 'side_header_border_opacity',
						'type' => 'select',
						'title' => esc_html__('Border Opacity', 'movedo' ),
						'subtitle'    => esc_html__( 'Select opacity for the borders.', 'movedo' ),
						'options' => $movedo_grve_opacity_selection,
						"default" => '0.10',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Sticky Header', 'movedo' ),
				'id' => 'grve_redux_section_colors_sticky_header',
				'desc' => esc_html__( 'Set your color preferences for the Sticky Header. You can enable/disable, select the type and logo for the sticky header in Theme Options > Header Options > Sticky Header Options.', 'movedo' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Sticky Header Color Settings
					array(
						'id'       => 'header_sticky_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a background color for the header.', 'movedo' ),
						'default'  => '#101215',
						'transparent' => false,
					),
					array(
						'id' => 'header_sticky_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Background Opacity', 'movedo' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the header.', 'movedo' ),
						'options' => $movedo_grve_opacity_selection,
						"default" => '1',
					),
					array(
						'id'       => 'header_sticky_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a border color for the sticky header.', 'movedo' ),
						'default'  => '#eef1f6',
						'transparent' => false,
					),
					array(
						'id' => 'header_sticky_border_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Border Opacity', 'movedo' ),
						'subtitle'    => esc_html__( 'Select opacity for the border of the sticky header.', 'movedo' ),
						'options' => $movedo_grve_opacity_selection,
						"default" => '0.30',
					),
					//Menu Color Settings
					array(
						'id'          => 'sticky_menu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu text.', 'movedo' ),
						'default'     => '#9c9c9c',
						'transparent' => false,
					),
					array(
						'id'          => 'sticky_menu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Hover Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover menu text.', 'movedo' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'header_sticky_menu_type_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu type. This will affect if you select the button or underline type.', 'movedo' ),
						'default'     => '#eef1f6',
						'transparent' => false,
					),
					array(
						'id'          => 'header_sticky_menu_type_color_hover',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Hover Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu type. This will affect if you select the button or underline type.', 'movedo' ),
						'default'     => '#eef1f6',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Light Header', 'movedo' ),
				'id' => 'grve_redux_section_colors_light_header',
				'desc' => esc_html__( 'Notice that the Light Header is the transparent header with light fonts that theme provides in order to combine with the overlapping option everywhere in your site.', 'movedo' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Menu Color Settings
					array(
						'id'          => 'light_menu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Hover/Active Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover/active menu text.', 'movedo' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'light_menu_type_color_hover',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu type. This will affect if you select the button or underline type.', 'movedo' ),
						'default'     => '#eef1f6',
						'transparent' => false,
					),
					array(
						'id'       => 'light_header_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a border color for the light header.', 'movedo' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'light_header_border_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Border Opacity', 'movedo' ),
						'subtitle'    => esc_html__( 'Select opacity for the border of the light header.', 'movedo' ),
						'options' => $movedo_grve_opacity_selection,
						"default" => '0.30',
					),
				)
			);
			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Dark Header', 'movedo' ),
				'id' => 'grve_redux_section_colors_dark_header',
				'desc' => esc_html__( 'Notice that the Dark Header is the transparent header with dark fonts that theme provides in order to combine with the overlapping option everywhere in your site.', 'movedo' ),
				'submenu' => false,
				'grve_colors' => true,
				'panel' => false,
				'subsection' => true,
				'fields' => array(
					//Menu Color Settings
					array(
						'id'          => 'dark_menu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Hover/Active Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover/active menu text.', 'movedo' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'dark_menu_type_color_hover',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu type. This will affect if you select the button or underline type.', 'movedo' ),
						'default'     => '#eef1f6',
						'transparent' => false,
					),
					array(
						'id'       => 'dark_header_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a border color for the dark header.', 'movedo' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'dark_header_border_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Border Opacity', 'movedo' ),
						'subtitle'    => esc_html__( 'Select opacity for the border of the dark header.', 'movedo' ),
						'options' => $movedo_grve_opacity_selection,
						"default" => '0.10',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Responsive Header', 'movedo' ),
				'id' => 'grve_redux_section_colors_responsive_header',
				'desc' => esc_html__( 'Set your color preferences for the Responsive Header. These settings will affect when the responsive header appears, below 1024px.', 'movedo' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'responsive_header_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a background color for the header.', 'movedo' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'responsive_header_background_opacity',
						'type' => 'select',
						'title' => esc_html__('Background Color Opacity', 'movedo' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the responsive header.', 'movedo' ),
						'options' => $movedo_grve_opacity_selection,
						"default" => '1',
					),
					array(
						'id'          => 'responsive_header_elements_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Header Elements Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the header elements.', 'movedo' ),
						'default'     => '#bfbfbf',
						'transparent' => false,
					),
					array(
						'id'          => 'responsive_header_elements_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Header Elements Hover Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for the header elements hover.', 'movedo' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Responsive / Hidden Menu', 'movedo' ),
				'id' => 'grve_redux_section_colors_responsive_menu',
				'desc' => esc_html__( 'Set your color preferences for the Responsive Menu. These settings will also affect for the hidden menu.', 'movedo' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'responsive_menu_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a background color for the responsive menu.', 'movedo' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'responsive_menu_link_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Link Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for the links of the responsive menu.', 'movedo' ),
						'default'  => '#777777',
						'transparent' => false,
					),
					array(
						'id'       => 'responsive_menu_link_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for the hovers of the responsive menu.', 'movedo' ),
						'default'  => '#0652FD',
						'transparent' => false,
					),
					array(
						'id'       => 'responsive_menu_close_btn_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Close Button Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for the close button of the responsive menu.', 'movedo' ),
						'default'  => '#777777',
						'transparent' => false,
					),
					array(
						'id'       => 'responsive_menu_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for the borders of the responsive menu.', 'movedo' ),
						'default'  => '#eef1f6',
						'transparent' => false,
					),
					array(
						'id'       => 'responsive_menu_overflow_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Overflow Background Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a background color for the overflow area, when responsive menu opens.', 'movedo' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'responsive_menu_overflow_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Overflow Background Opacity', 'movedo' ),
						'subtitle'    => esc_html__( 'Select opacity for the overflow area, when responsive menu opens.', 'movedo' ),
						'options' => $movedo_grve_opacity_selection,
						"default" => '0.90',
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Anchor Menu', 'movedo' ),
				'id' => 'grve_redux_section_colors_anchor_menu',
				'header' => '',
				'desc' => esc_html__( 'Set your color preferences for the Anchor Menu in case you use one in any of your pages, posts items.', 'movedo' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'page_anchor_menu_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'movedo' ),
						'subtitle' => esc_html__( 'Background color for the Anchor Menu.', 'movedo' ),
						'default'  => '#171a1d',
						'transparent' => false,
					),
					array(
						'id'       => 'page_anchor_menu_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Font Color', 'movedo' ),
						'subtitle' => esc_html__( 'Font color for the Anchor Menu.', 'movedo' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'page_anchor_menu_text_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Text Color', 'movedo' ),
						'subtitle' => esc_html__( 'Hover color for the Anchor Menu.', 'movedo' ),
						'default'  => '#0652FD',
						'transparent' => false,
					),
					array(
						'id'       => 'page_anchor_menu_background_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Background Color', 'movedo' ),
						'subtitle' => esc_html__( 'Hover background color for the Anchor Menu.', 'movedo' ),
						'default'  => '#171a1d',
						'transparent' => false,
					),
					array(
						'id'       => 'page_anchor_menu_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'movedo' ),
						'subtitle' => esc_html__( 'Border color for the Anchor Menu.', 'movedo' ),
						'default'  => '#333638',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Main Content', 'movedo' ),
				'id' => 'grve_redux_section_colors_main_content',
				'header' => '',
				'desc' => esc_html__( 'Set your color preferences for the main content area of your site.', 'movedo' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'main_content_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a background color.', 'movedo' ),
						'default'  => '#ffffff',
						'transparent' => false,

					),
					array(
						'id'       => 'body_heading_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Headings Text Color (h1-h6)', 'movedo' ),
						'subtitle'    => esc_html__( 'Pick a color for headings text.', 'movedo' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'body_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Text Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for the text.', 'movedo' ),
						'default'  => '#676767',
						'transparent' => false,
					),
					array(
						'id'       => 'body_text_link_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Link Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for the links.', 'movedo' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'body_text_link_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for hover text.', 'movedo' ),
						'default'  => '#0652FD',
						'transparent' => false,
					),
					array(
						'id'       => 'body_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a border color.', 'movedo' ),
						'default'  => '#e9e9e9',
						'transparent' => false,
					),
					array(
						'id'       => 'widget_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Widget Title Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for widget titles.', 'movedo' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'body_primary_1_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Primary 1 Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for primary 1.', 'movedo' ),
						'default'  => '#0652FD',
						'transparent' => false,
					),
					array(
						'id'       => 'body_primary_2_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Primary 2 Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for primary 2.', 'movedo' ),
						'default'  => '#003a40',
						'transparent' => false,
					),
					array(
						'id'       => 'body_primary_3_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Primary 3 Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for primary 3.', 'movedo' ),
						'default'  => '#487F84',
						'transparent' => false,
					),
					array(
						'id'       => 'body_primary_4_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Primary 4 Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for primary 4.', 'movedo' ),
						'default'  => '#5F597E',
						'transparent' => false,
					),
					array(
						'id'       => 'body_primary_5_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Primary 5 Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for primary 5.', 'movedo' ),
						'default'  => '#d6ccad',
						'transparent' => false,
					),
					array(
						'id'       => 'body_primary_6_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Primary 6 Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for primary 6.', 'movedo' ),
						'default'  => '#db5111',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Blog /Post', 'movedo' ),
				'id' => 'grve_redux_section_colors_blog_post',
				'desc' => esc_html__( 'Set your color preferences for your Blog / Post.', 'movedo' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Blog Title', 'movedo' ),
				'id' => 'grve_redux_section_colors_blog_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the blog title area and the color of the blog title. These settings will only affect in case you have set a Static Page as blog page in Settings > Reading > Front Page Displays. Also these settings will also affect on Archives / Categories / Tags overview pages.', 'movedo' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'blog_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Background color for your blog title.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'dark',
					),
					array(
						'id'       => 'blog_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'blog_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'blog_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'movedo' ),
						'options' => $movedo_grve_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'blog_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'blog_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'blog_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Color for your blog title.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'blog_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'blog_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'blog_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Color for your blog description.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'blog_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'blog_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Post Title', 'movedo' ),
				'id' => 'grve_redux_section_colors_post_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the single post title area and the color of the post title. Notice that you can disable it, override it or even use the feature section when you edit your single posts.', 'movedo' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'post_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Background color for your post title.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'dark',
					),
					array(
						'id'       => 'post_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'post_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'post_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'movedo' ),
						'options' => $movedo_grve_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'post_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'post_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'post_subheading_color',
						'type' => 'select',
						'title' => esc_html__( 'Categories/Meta Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Color for your post categories/meta.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'post_subheading_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Meta Title Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'post_subheading_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'post_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Color for your post title.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'post_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'post_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'post_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Color for your post description.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'post_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'post_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Post Bar', 'movedo' ),
				'id' => 'grve_redux_section_colors_post_bar',
				'header' => '',
				'desc' => esc_html__( 'Set the colors for the navigation - socials area in the single post.', 'movedo' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'post_bar_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'movedo' ),
						'subtitle' => esc_html__( 'Background color for the post bar.', 'movedo' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'post_bar_socials_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Socials Color', 'movedo' ),
						'subtitle' => esc_html__( 'Color for the Socials.', 'movedo' ),
						'default'  => '#d3d3d3',
						'transparent' => false,
					),
					array(
						'id'       => 'post_bar_socials_color_hover',
						'type'     => 'color',
						'title'    => esc_html__( 'Socials Hover Color', 'movedo' ),
						'subtitle' => esc_html__( 'Hover color for the Socials.', 'movedo' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'post_bar_nav_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Titles Color', 'movedo' ),
						'subtitle' => esc_html__( 'Color for the Navigation Titles.', 'movedo' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'post_bar_arrow_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Arrows Color', 'movedo' ),
						'subtitle' => esc_html__( 'Color for the Navigation Arrows.', 'movedo' ),
						'default'  => '#d3d3d3',
						'transparent' => false,
					),
					array(
						'id'       => 'post_bar_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'movedo' ),
						'subtitle' => esc_html__( 'Border color for the post bar.', 'movedo' ),
						'default'  => '#e9e9e9',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Page', 'movedo' ),
				'id' => 'grve_redux_section_colors_page',
				'desc' => esc_html__( 'Set your color preferences for your page.', 'movedo' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Page Title', 'movedo' ),
				'id' => 'grve_redux_section_colors_page_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the predefined page title area and the color of the page title. Notice that you can disable it, override it or even use the feature section when you edit your single pages.', 'movedo' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'page_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Background color for your page title.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'primary-2',
					),
					array(
						'id'       => 'page_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'page_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'page_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'movedo' ),
						'options' => $movedo_grve_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'page_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'page_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'page_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Color for your page title.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'page_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'page_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'page_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Color for your page description.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'page_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'page_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Search Page', 'movedo' ),
				'id' => 'grve_redux_section_colors_search_page',
				'desc' => esc_html__( 'Set your color preferences for your search page.', 'movedo' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Search Page Title', 'movedo' ),
				'id' => 'grve_redux_section_colors_search_page_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the search page title area and the color of the page title.', 'movedo' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'search_page_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Background color for your page title.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'dark',
					),
					array(
						'id'       => 'search_page_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'search_page_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'search_page_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'movedo' ),
						'options' => $movedo_grve_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'search_page_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'search_page_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'search_page_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Color for your page title.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'search_page_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'search_page_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'search_page_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Color for your page description.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'search_page_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'search_page_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Portfolio', 'movedo' ),
				'id' => 'grve_redux_section_colors_portfolio',
				'desc' => esc_html__( 'Set your color preferences for your portfolio.', 'movedo' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Portfolio Title', 'movedo' ),
				'id' => 'grve_redux_section_colors_portfolio_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the single portfolio title area and the color of the portfolio title and description. Notice that you can disable it, override it or even use the feature section when you edit your single portfolio items.', 'movedo' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'portfolio_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Background color for your portfolio title.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'dark',
					),
					array(
						'id'       => 'portfolio_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'portfolio_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'movedo' ),
						'options' => $movedo_grve_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'portfolio_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'portfolio_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Color for your portfolio title.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'portfolio_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'portfolio_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Color for your portfolio description.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'portfolio_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'portfolio_description_color', 'equals', 'custom' ),
					),
				)
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Portfolio Bar', 'movedo' ),
				'id' => 'grve_redux_section_colors_portfolio_bar',
				'header' => '',
				'desc' => esc_html__( 'Set the colors for the navigation - socials area in the single portfolio.', 'movedo' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'portfolio_bar_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'movedo' ),
						'subtitle' => esc_html__( 'Background color for the portfolio bar.', 'movedo' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'portfolio_bar_socials_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Socials Color', 'movedo' ),
						'subtitle' => esc_html__( 'Color for the Socials.', 'movedo' ),
						'default'  => '#d3d3d3',
						'transparent' => false,
					),
					array(
						'id'       => 'portfolio_bar_socials_color_hover',
						'type'     => 'color',
						'title'    => esc_html__( 'Socials Hover Color', 'movedo' ),
						'subtitle' => esc_html__( 'Hover color for the Socials.', 'movedo' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'portfolio_bar_nav_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Titles Color', 'movedo' ),
						'subtitle' => esc_html__( 'Color for the Navigation Titles.', 'movedo' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'portfolio_bar_arrow_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Arrows Color', 'movedo' ),
						'subtitle' => esc_html__( 'Color for the Navigation Arrows.', 'movedo' ),
						'default'  => '#d3d3d3',
						'transparent' => false,
					),
					array(
						'id'       => 'portfolio_bar_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Portfolio Bar Border Color', 'movedo' ),
						'subtitle' => esc_html__( 'Border color for the portfolio Bar.', 'movedo' ),
						'default'  => '#e9e9e9',
						'transparent' => false,
					),
				)
			);
			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Shop/Product', 'movedo' ),
				'id' => 'grve_redux_section_colors_shop_product',
				'desc' => esc_html__( 'Set your color preferences for your Shop/Product.', 'movedo' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Product Taxonomy Title', 'movedo' ),
				'id' => 'grve_redux_section_colors_product_tax_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the product taxonomies title area and the color of the product taxonomies title and description.', 'movedo' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'product_tax_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Background color for your title.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'dark',
					),
					array(
						'id'       => 'product_tax_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'product_tax_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_tax_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'movedo' ),
						'options' => $movedo_grve_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'product_tax_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'product_tax_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_tax_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Color for your title.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'product_tax_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'product_tax_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_tax_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Color for your description.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'product_tax_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'product_tax_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Product Title', 'movedo' ),
				'id' => 'grve_redux_section_colors_product_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the single product title area and the color of the product title and description. Notice that you can disable it, override it or even use the feature section when you edit your single product items.', 'movedo' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'product_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Background color for your title.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'dark',
					),
					array(
						'id'       => 'product_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'product_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'movedo' ),
						'options' => $movedo_grve_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'product_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'product_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Color for your title.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'product_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'product_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Color for your description.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'product_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'product_description_color', 'equals', 'custom' ),
					),
				)
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Product Area', 'movedo' ),
				'id' => 'grve_redux_section_colors_product_area',
				'header' => '',
				'desc' => esc_html__( 'Set the colors for the single product content area. Notice that you can override it when you edit your single product items.', 'movedo' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'          => 'product_area_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Background color for your Product Area.', 'movedo' ),
						'default'     => '#eeeeee',
						'transparent' => false,
					),
					array(
						'id'          => 'product_area_headings_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Headings Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Headings color for your Product Area.', 'movedo' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'product_area_font_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Font Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Font color for your Product Area.', 'movedo' ),
						'default'     => '#999999',
						'transparent' => false,
					),
					array(
						'id'          => 'product_area_link_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Link Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Link color for your Product Area.', 'movedo' ),
						'default'     => '#FF7D88',
						'transparent' => false,
					),
					array(
						'id'          => 'product_area_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Hover Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Hover color for your Product Area.', 'movedo' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'product_area_border_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Border Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Border color for your Product Area.', 'movedo' ),
						'default'     => '#e0e0e0',
						'transparent' => false,
					),
					array(
						'id'=>'product_area_button_color',
						'type' => 'select',
						'title' => esc_html__( 'Button Color', 'movedo' ),
						'subtitle' => esc_html__( 'Select the color of your Product Area Buttons.', 'movedo' ),
						'options' => $movedo_grve_button_color_selection,
						'default' => 'primary-1',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'product_area_button_hover_color',
						'type' => 'select',
						'title' => esc_html__( 'Button Hover Color', 'movedo' ),
						'subtitle' => esc_html__( 'Select the hover color of your Product Area Buttons.', 'movedo' ),
						'options' => $movedo_grve_button_color_selection,
						'default' => 'black',
						'validate' => 'not_empty',
					),
				)
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Product Bar', 'movedo' ),
				'id' => 'grve_redux_section_colors_product_bar',
				'header' => '',
				'desc' => esc_html__( 'Set the colors for the navigation - socials area in the single product.', 'movedo' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'product_bar_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'movedo' ),
						'subtitle' => esc_html__( 'Background color for the product bar.', 'movedo' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'product_bar_socials_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Socials Color', 'movedo' ),
						'subtitle' => esc_html__( 'Color for the Socials.', 'movedo' ),
						'default'  => '#d3d3d3',
						'transparent' => false,
					),
					array(
						'id'       => 'product_bar_socials_color_hover',
						'type'     => 'color',
						'title'    => esc_html__( 'Socials Hover Color', 'movedo' ),
						'subtitle' => esc_html__( 'Hover color for the Socials.', 'movedo' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'product_bar_nav_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Titles Color', 'movedo' ),
						'subtitle' => esc_html__( 'Color for the Navigation Titles.', 'movedo' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'product_bar_arrow_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Arrows Color', 'movedo' ),
						'subtitle' => esc_html__( 'Color for the Navigation Arrows.', 'movedo' ),
						'default'  => '#d3d3d3',
						'transparent' => false,
					),
					array(
						'id'       => 'product_bar_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Product Bar Border Color', 'movedo' ),
						'subtitle' => esc_html__( 'Border color for the product Bar.', 'movedo' ),
						'default'  => '#e9e9e9',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Events Calendar', 'movedo' ),
				'id' => 'grve_redux_section_colors_events_calendar',
				'desc' => esc_html__( 'Set your color preferences for your Events.', 'movedo' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Event Taxonomy Title', 'movedo' ),
				'id' => 'grve_redux_section_colors_event_tax_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the event taxonomies title area and the color of the event taxonomies title and description.', 'movedo' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'event_tax_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Background color for your title.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'dark',
					),
					array(
						'id'       => 'event_tax_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'event_tax_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'event_tax_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'movedo' ),
						'options' => $movedo_grve_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'event_tax_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'event_tax_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'event_tax_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Color for your title.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'event_tax_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'event_tax_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'event_tax_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Color for your description.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'event_tax_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'event_tax_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Event Title', 'movedo' ),
				'id' => 'grve_redux_section_colors_event_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the single event title area and the color of the event title and description. Notice that you can disable it, override it or even use the feature section when you edit your single event items.', 'movedo' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'event_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Background color for your title.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'dark',
					),
					array(
						'id'       => 'event_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'event_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'event_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'movedo' ),
						'options' => $movedo_grve_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'event_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'event_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'event_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Color for your title.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'event_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'event_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'event_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Color for your description.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'event_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'event_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Event Bar', 'movedo' ),
				'id' => 'grve_redux_section_colors_event_bar',
				'header' => '',
				'desc' => esc_html__( 'Set the colors for the navigation - socials area in the single event.', 'movedo' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'event_bar_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'movedo' ),
						'subtitle' => esc_html__( 'Background color for the event bar.', 'movedo' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'event_bar_socials_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Socials Color', 'movedo' ),
						'subtitle' => esc_html__( 'Color for the Socials.', 'movedo' ),
						'default'  => '#d3d3d3',
						'transparent' => false,
					),
					array(
						'id'       => 'event_bar_socials_color_hover',
						'type'     => 'color',
						'title'    => esc_html__( 'Socials Hover Color', 'movedo' ),
						'subtitle' => esc_html__( 'Hover color for the Socials.', 'movedo' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'event_bar_nav_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Titles Color', 'movedo' ),
						'subtitle' => esc_html__( 'Color for the Navigation Titles.', 'movedo' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'event_bar_arrow_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Arrows Color', 'movedo' ),
						'subtitle' => esc_html__( 'Color for the Navigation Arrows.', 'movedo' ),
						'default'  => '#d3d3d3',
						'transparent' => false,
					),
					array(
						'id'       => 'event_bar_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Event Bar Border Color', 'movedo' ),
						'subtitle' => esc_html__( 'Border color for the Event Bar.', 'movedo' ),
						'default'  => '#e9e9e9',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - bbPress Forum', 'movedo' ),
				'id' => 'grve_redux_section_colors_bbpress',
				'desc' => esc_html__( 'Set your color preferences for your Forum.', 'movedo' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Forum Title', 'movedo' ),
				'id' => 'grve_redux_section_colors_forum_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the forum title area.', 'movedo' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'forum_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Background color for your title.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'dark',
					),
					array(
						'id'       => 'forum_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'forum_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'forum_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'movedo' ),
						'options' => $movedo_grve_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'forum_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'forum_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'forum_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Color for your title.', 'movedo' ),
						'options' => $movedo_grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'forum_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'movedo' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'forum_title_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Footer', 'movedo' ),
				'id' => 'grve_redux_section_colors_footer',
				'desc' => esc_html__( 'Set your color preferences for your Footer.', 'movedo' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Footer Area', 'movedo' ),
				'id' => 'grve_redux_section_colors_footer_area',
				'header' => '',
				'desc' => esc_html__( 'Set your color preferences for the Footer Area. Define the Footer Area in Theme Options > Footer Options.', 'movedo' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Footer Area Color Settings
					array(
						'id'          => 'footer_widgets_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Background color for your Footer Area.', 'movedo' ),
						'default'     => '#0D0F10',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_widgets_headings_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Headings Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Headings color for your Footer Area.', 'movedo' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_widgets_font_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Font Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Font color for your Footer Area.', 'movedo' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_widgets_link_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Link Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Link color for your Footer Area.', 'movedo' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_widgets_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Hover Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Hover color for your Footer Area.', 'movedo' ),
						'default'     => '#909090',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_widgets_border_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Border Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Border color for your Footer Area.', 'movedo' ),
						'default'     => '#3E3F3F',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Footer Bar Area', 'movedo' ),
				'id' => 'grve_redux_section_colors_footer_bar_area',
				'header' => '',
				'desc' => esc_html__( 'Set your color preferences for the Footer Bar Area(copyright area). Define the Footer Bar Area in Theme Options > Footer Options.', 'movedo' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Footer Bar Color Settings
					array(
						'id'          => 'footer_bar_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Background Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Background color for your Footer Bar Area.', 'movedo' ),
						'default'     => '#0D0F10',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_bar_bg_color_opacity',
						'type'        => 'select',
						'title'       => esc_html__('Background Opacity', 'movedo' ),
						'subtitle'    => esc_html__( 'Select opacity for your Footer Bar Area.', 'movedo' ),
						'options'     => $movedo_grve_opacity_selection,
						"default"     => '1',
					),
					array(
						'id'          => 'footer_bar_font_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Font Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Font color for your Footer Bar Area.', 'movedo' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_bar_link_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Link Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Link color for your Footer Bar Area.', 'movedo' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_bar_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Hover Color', 'movedo' ),
						'subtitle'    => esc_html__( 'Hover color for your Footer Bar Area.', 'movedo' ),
						'default'     => '#909090',
						'transparent' => false,
					),
				)
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Breadcrumbs', 'movedo' ),
				'id' => 'grve_redux_section_colors_breadcrumbs',
				'header' => '',
				'desc' => esc_html__( 'Set your color preferences for the Breadcrumbs in case you use then in any of your pages, posts or items.', 'movedo' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'page_breadcrumbs_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'movedo' ),
						'subtitle' => esc_html__( 'Background color for the Breadcrumbs.', 'movedo' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'page_breadcrumbs_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Font Color', 'movedo' ),
						'subtitle' => esc_html__( 'Font color for the Breadcrumbs.', 'movedo' ),
						'default'  => '#6e6e6e',
						'transparent' => false,
					),
					array(
						'id'       => 'page_breadcrumbs_text_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Text Color', 'movedo' ),
						'subtitle' => esc_html__( 'Hover color for the Breadcrumbs.', 'movedo' ),
						'default'  => '#0652FD',
						'transparent' => false,
					),
					array(
						'id'       => 'page_breadcrumbs_divider_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Divider Color', 'movedo' ),
						'subtitle' => esc_html__( 'Divider color for the Breadcrumbs.', 'movedo' ),
						'default'  => '#b2b2b2',
						'transparent' => false,
					),
					array(
						'id'       => 'page_breadcrumbs_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'movedo' ),
						'subtitle' => esc_html__( 'Border color for the Breadcrumbs.', 'movedo' ),
						'default'  => '#e0e0e0',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Safe Button', 'movedo' ),
				'id' => 'grve_redux_section_colors_safe_button_area',
				'desc' => esc_html__( 'Set your color preferences for the Safe Button Area.', 'movedo' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'safebutton_layer_1_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Layer 1 Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for layer 1.', 'movedo' ),
						'default'  => '#0652FD',
						'transparent' => false,
					),
					array(
						'id'       => 'safebutton_layer_2_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Layer 2 Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for layer 2.', 'movedo' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'safebutton_layer_3_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Layer 3 Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for layer 3.', 'movedo' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Sliding Area', 'movedo' ),
				'id' => 'grve_redux_section_colors_sliding_area',
				'desc' => esc_html__( 'Set your color preferences for the Sliding Area.', 'movedo' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'sliding_area_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a background color for the sliding area.', 'movedo' ),
						'default'  => '#232323',
						'transparent' => false,
					),
					array(
						'id'       => 'sliding_area_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Title Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for the titles - headings (h1-h6) of the sliding area.', 'movedo' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'sliding_area_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Text Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for the text of the sliding area.', 'movedo' ),
						'default'  => '#777777',
						'transparent' => false,
					),
					array(
						'id'       => 'sliding_area_link_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Link Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for the links of the sliding area.', 'movedo' ),
						'default'  => '#777777',
						'transparent' => false,
					),
					array(
						'id'       => 'sliding_area_link_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for the hovers of the sliding area.', 'movedo' ),
						'default'  => '#0652FD',
						'transparent' => false,
					),
					array(
						'id'       => 'sliding_area_close_btn_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Close Button Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for the close button of the sliding area.', 'movedo' ),
						'default'  => '#777777',
						'transparent' => false,
					),
					array(
						'id'       => 'sliding_area_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for the borders of the sliding area.', 'movedo' ),
						'default'  => '#3e3e3e',
						'transparent' => false,
					),
					array(
						'id'       => 'sliding_area_overflow_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Overflow Background Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a background color for the overflow area, when sliding area opens.', 'movedo' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'sliding_area_overflow_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Overflow Background Opacity', 'movedo' ),
						'subtitle'    => esc_html__( 'Select opacity for the overflow area, when sliding area opens.', 'movedo' ),
						'options' => $movedo_grve_opacity_selection,
						"default" => '0.90',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Modals', 'movedo' ),
				'id' => 'grve_redux_section_colors_modals',
				'desc' => esc_html__( 'Set your color preferences for the Modals.', 'movedo' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'modal_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Title Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for the titles - headings (h1-h6) of the modal.', 'movedo' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'modal_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Text Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for the text of the modal.', 'movedo' ),
						'default'  => '#777777',
						'transparent' => false,
					),
					array(
						'id' => 'modal_cursor_color_color',
						'type' => 'select',
						'title' => esc_html__( 'Close Button Color', 'movedo' ),
						'subtitle'=> esc_html__( 'Select a color for the close button of the modal.', 'movedo' ),
						'options' => array(
							'dark' => esc_html__( 'Dark', 'movedo' ),
							'light' => esc_html__( 'Light', 'movedo' ),
						),
						'default' => 'dark',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'modal_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for the borders of the modal.', 'movedo' ),
						'default'  => '#eef1f6',
						'transparent' => false,
					),
					array(
						'id'       => 'modal_overflow_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Overflow Background Color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a background color for the overflow area, when modal opens.', 'movedo' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'modal_overflow_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Overflow Background Opacity', 'movedo' ),
						'subtitle'    => esc_html__( 'Select opacity for the overflow area, when modal opens.', 'movedo' ),
						'options' => $movedo_grve_opacity_selection,
						"default" => '1',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Back to Top', 'movedo' ),
				'id' => 'grve_redux_section_colors_back_to_top',
				'desc' => esc_html__( 'Set your color preferences for Back to Top.', 'movedo' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'=>'back_to_top_icon_color',
						'type' => 'color',
						'title' => esc_html__( 'Back to Top Icon Color', 'movedo' ),
						'subtitle' => esc_html__( 'Select the color of Back to Top icon.', 'movedo' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'=>'back_to_top_shape_color',
						'type' => 'color',
						'title' => esc_html__( 'Back to Top Icon Shape Color', 'movedo' ),
						'subtitle' => esc_html__( 'Select the color of Back to Top shape.', 'movedo' ),
						'default' => '#262829',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cloud',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Social Media', 'movedo' ),
				'id' => 'grve_redux_section_social_media',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'social_options',
						'type' => 'sortable',
						'title' => esc_html__( 'Social URLs', 'movedo' ),
						'subtitle' => esc_html__( 'Define and reorder your social URLs. Clear the input field for any social link you do not wish to display.', 'movedo' ),
						'desc' => '',
						'label' => true,
						'options' => $movedo_grve_social_options,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-map-marker',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Map Options', 'movedo' ),
				'id' => 'grve_redux_section_map_options',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'       => 'gmap_api_key',
						'type'     => 'text',
						'title'    => esc_html__( 'Google API Key', 'movedo' ),
						'subtitle' => $movedo_gmap_api_key_link,
						'default'  => '',
					),
					array(
						'id' => 'gmap_custom_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Enable Custom Style', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want to enable custom style for your map.', 'movedo' ),
						'default' => 0,
					),
					array(
						'id'       => 'gmap_water_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Water color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for water', 'movedo' ),
						'default'  => '#424242',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'gmap_landscape_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Landscape color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for landscape', 'movedo' ),
						'default'  => '#232323',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'gmap_poi_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Point of interest color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for point of interest', 'movedo' ),
						'default'  => '#232323',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'gmap_road_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Roads color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for roads', 'movedo' ),
						'default'  => '#1a1a1a',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'gmap_label_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Enable Label', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want to enable labels for your map.', 'movedo' ),
						'default' => 1,
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'gmap_label_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Label color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for labels', 'movedo' ),
						'default'  => '#777777',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_label_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'gmap_label_stroke_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Label Stroke color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a stroke color for labels', 'movedo' ),
						'default'  => '#1a1a1a',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_label_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'gmap_country_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Country Stroke color', 'movedo' ),
						'subtitle' => esc_html__( 'Pick a color for country stroke.', 'movedo' ),
						'default'  => '#000000',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'gmap_zoom_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Enable Zoom Control', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want to enable zoom control for your map.', 'movedo' ),
						'default' => 0,
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-error',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( '404 Page', 'movedo'),
				'id' => 'grve_redux_section_404',
				'subtitle' => esc_html__( 'You can find the settings for the 404 page here.', 'movedo' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'page_404_header',
						'type' => 'switch',
						'title' => esc_html__( 'Show Header', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want to show header.', 'movedo' ),
						'default' => 0,
					),
					array(
						'id' => 'page_404_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Page 404 Header Style', 'movedo' ),
						'subtitle'=> esc_html__( 'Select your page header style.', 'movedo' ),
						'options' => $movedo_grve_header_style,
						'default' => 'default',
						'required' => array( 'page_404_header', 'equals', 1 ),
					),
					array(
						'id' => 'page_404_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Page 404 Header Overlapping', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want the Page Header overlaps the content. Combine this option with the Light or Dark Header.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'no',
						'required' => array( 'page_404_header', 'equals', 1 ),
					),
					array(
						'id' => 'page_404_content',
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Page 404 Content', 'movedo' ),
						'subtitle' => esc_html__( 'Type the content of your 404 page, you can also use shortcodes.', 'movedo' ),
						'default' => '<h3><em>404 ERROR</em></h3><h1>Hey there mate!</h1><h2>Your lost treasure is not found here...</h2><p class="grve-leader-text">Sorry! The page you are looking for wasn\'t found!</p>',
					),
					array(
						'id' => 'page_404_search',
						'type' => 'checkbox',
						'title' => esc_html__( 'Show Search Box', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want to show a search box.', 'movedo' ),
						'default' => 0,
					),
					array(
						'id' => 'page_404_home_button',
						'type' => 'checkbox',
						'title' => esc_html__( 'Show Back to home Button', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want to show a back to home button.', 'movedo' ),
						'default' => 1,
					),
					array(
						'id' => 'page_404_footer',
						'type' => 'switch',
						'title' => esc_html__( 'Show Footer', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want to show footer.', 'movedo' ),
						'default' => 0,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cog',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Miscellaneous', 'movedo' ),
				'id' => 'grve_redux_section_miscellaneous',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'       => 'feature_section_post_types',
						'type'     => 'select',
						'multi'    => true,
						'title'    => esc_html__( 'Feature Section Post Types', 'movedo' ),
						'subtitle' => esc_html__( 'Select the post types you wish to enable the Feature Section.', 'movedo' ),
						'options' => $movedo_grve_feature_section_post_types_selection,
						'default' => array( 'page', 'portfolio' ),
					),
					array(
						'id'=>'wp_gallery_popup',
						'type' => 'switch',
						'title' => esc_html__( 'Lightbox for WordPress Gallery', 'movedo' ),
						'subtitle'=> esc_html__( 'Toggle lightbox for native WordPress Gallery on or off.', 'movedo' ),
						"default" => '0',
						'on' => esc_html__('On', 'movedo' ),
						'off' => esc_html__('Off', 'movedo' ),
					),
					array(
						'id'=>'wp_tagcloud',
						'type' => 'switch',
						'title' => esc_html__( 'Default WordPress Tag Cloud', 'movedo' ),
						'subtitle'=> esc_html__( 'Toggle default tag cloud on or off.', 'movedo' ),
						"default" => '0',
						'on' => esc_html__('On', 'movedo' ),
						'off' => esc_html__('Off', 'movedo' ),
					),
					array(
						'id'=>'logo_as_text_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Logo as text', 'movedo' ),
						'subtitle'=> esc_html__( 'Toggle logo as text on or off. When on, all logo images will be replaced with site name.', 'movedo' ),
						"default" => '0',
						'on' => esc_html__('On', 'movedo' ),
						'off' => esc_html__('Off', 'movedo' ),
					),
					array(
						'id'=>'logo_custom_link_url',
						'type' => 'text',
						'title' => esc_html__( 'Logo Custom Link URL', 'movedo' ),
						'subtitle'=> esc_html__( 'Define a custom URL link for your logo. If empty homepage will be used instead.', 'movedo' ),
						"default" => '',
					),
					array(
						'id'=>'menu_header_integration',
						'type' => 'select',
						'title' => esc_html__( 'Main Menu Integration', 'movedo' ),
						'subtitle' => esc_html__( 'Select the main menu integration method. Selection available for custom menu integration.', 'movedo' ),
						'options' => $movedo_grve_header_menu_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'sidebar_heading_tag',
						'type' => 'select',
						'title' => esc_html__( 'Sidebar Headings Tag', 'movedo' ),
						'subtitle' => esc_html__( 'Select the headings tag for your Sidebar Titles.', 'movedo' ),
						'options' => $movedo_grve_headings_tag_selection,
						'default' => 'div',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'footer_heading_tag',
						'type' => 'select',
						'title' => esc_html__( 'Footer Sidebar Headings Tag', 'movedo' ),
						'subtitle' => esc_html__( 'Select the headings tag for your Footer Sidebar Titles.', 'movedo' ),
						'options' => $movedo_grve_headings_tag_selection,
						'default' => 'div',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'disable_seo_page_analysis',
						'type' => 'checkbox',
						'title' => esc_html__( 'Disable WordPress SEO Page Analysis', 'movedo' ),
						'subtitle'=> esc_html__( 'Select if you want to disable WordPress SEO page analysis.', 'movedo' ),
						'default' => 0,
					),
					array(
						'id' => 'responsive_sidearea_button_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Responsive Sliding Area Button Visibility', 'movedo' ),
						'subtitle' => esc_html__( 'Enable/Disable the Sliding Area Button on devices.', 'movedo' ),
						'options' => $movedo_grve_enable_selection,
						'default' => 'yes',
					),
					array(
						'id' => 'spinner_image',
						'url' => true,
						'type' => 'media',
						'title' => esc_html__( 'Spinner Image', 'movedo' ),
						'subtitle' => esc_html__( 'Upload a custom image if you want to replace the built-in graphic spinners.', 'movedo' ),
					),
					array(
						'id'=>'placeholder_mode',
						'type' => 'select',
						'title' => esc_html__( 'Placeholder Mode', 'movedo' ),
						'subtitle' => esc_html__( 'Select what images to display as placeholders.', 'movedo' ),
						'options' => array(
							'dummy' => esc_html__( 'Theme Dummy Image', 'movedo' ),
							'unsplash' => esc_html__( 'unsplash', 'movedo' ),
							// 'placehold' => esc_html__( 'placehold.it', 'movedo' ),
						),
						'default' => 'dummy',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'scroll_mode',
						'type' => 'select',
						'title' => esc_html__( 'Smooth Scroll Mode', 'movedo' ),
						'subtitle' => esc_html__( 'Select your smooth scroll mode.', 'movedo' ),
						'options' => array(
							'auto' => esc_html__( 'Browser defined', 'movedo' ),
							'on' => esc_html__( 'Always On', 'movedo' ),
							'off' => esc_html__( 'Always Off', 'movedo' ),
						),
						'default' => 'auto',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'device_animations',
						'type' => 'switch',
						'title' => esc_html__( 'Device Animations', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable/Disable animations for mobile devices.', 'movedo' ),
						"default" => '0',
						'on' => esc_html__('On', 'movedo' ),
						'off' => esc_html__('Off', 'movedo' ),
					),
					array(
						'id'=>'device_hover_single_tap',
						'type' => 'switch',
						'title' => esc_html__( 'Device Single Tap', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable/Disable single tap for links/hovers on devices.', 'movedo' ),
						"default" => '0',
						'on' => esc_html__('On', 'movedo' ),
						'off' => esc_html__('Off', 'movedo' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cog',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Page Builder Addons', 'movedo' ),
				'desc' => esc_html__( 'Enable/Disable default Page Builder functionality.', 'movedo' ),
				'id' => 'grve_redux_section_page_builder',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'=>'vc_grid_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Page Builder Grid Elements', 'movedo' ),
						'subtitle'=> esc_html__( 'Toggle Page Builder Grid elements on or off.', 'movedo' ),
						"default" => '0',
						'on' => esc_html__('On', 'movedo' ),
						'off' => esc_html__('Off', 'movedo' ),
					),
					array(
						'id'=>'vc_charts_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Page Builder Charts Elements', 'movedo' ),
						'subtitle'=> esc_html__( 'Toggle Page Builder Charts elements on or off.', 'movedo' ),
						"default" => '0',
						'on' => esc_html__('On', 'movedo' ),
						'off' => esc_html__('Off', 'movedo' ),
					),
					// array(
						// 'id'=>'vc_woo_visibility',
						// 'type' => 'switch',
						// 'title' => esc_html__( 'Page Builder WooCommerce Elements', 'movedo' ),
						// 'subtitle'=> esc_html__( 'Toggle Page Builder WooCommerce elements on or off.', 'movedo' ),
						// "default" => '0',
						// 'on' => esc_html__('On', 'movedo' ),
						// 'off' => esc_html__('Off', 'movedo' ),
					// ),
					array(
						'id'=>'vc_auto_updater',
						'type' => 'switch',
						'title' => esc_html__( 'Page Builder Auto Updater', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable/Disable Page Builder Auto Updater ( Activation Required ).', 'movedo' ),
						"default" => '0',
						'on' => esc_html__('On', 'movedo' ),
						'off' => esc_html__('Off', 'movedo' ),
					),
					array(
						'id'=>'vc_content_manager_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Page Builder Theme Content Manager', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable/Disable Theme Content Manager.', 'movedo' ),
						"default" => '1',
						'on' => esc_html__('On', 'movedo' ),
						'off' => esc_html__('Off', 'movedo' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cog',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Login Settings', 'movedo' ),
				'desc' => esc_html__( 'Configure your login functionality.', 'movedo' ),
				'id' => 'grve_redux_section_login',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'=>'login_mode',
						'type' => 'select',
						'title' => esc_html__( 'Login Mode', 'movedo' ),
						'subtitle' => esc_html__( 'Select your login mode, modal or a custom link.', 'movedo' ),
						'options' => array(
							'modal' => esc_html__( 'Ajax Modal', 'movedo' ),
							'custom-link' => esc_html__( 'Custom Link', 'movedo' ),
						),
						'default' => 'modal',
					),
					array(
						'id'=>'login_custom_link_url',
						'type' => 'text',
						'title' => esc_html__( 'Login Custom Link URL', 'movedo' ),
						'subtitle'=> esc_html__( 'Define a custom URL link for your login page.', 'movedo' ),
						"default" => '',
						'required' => array( 'login_mode', 'equals', 'custom-link' ),
					),
					array(
						'id'=>'login_redirect_url',
						'type' => 'text',
						'title' => esc_html__( 'Login Redirect URL', 'movedo' ),
						'subtitle'=> esc_html__( 'Define a redirect URL for your login page. If empty current page will be used instead.', 'movedo' ),
						"default" => '',
						'required' => array( 'login_mode', 'equals', 'modal' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cog',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Button Settings', 'movedo' ),
				'desc' => esc_html__( 'Set the style for the buttons.', 'movedo' ),
				'id' => 'grve_redux_section_buttons',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'=>'button_type',
						'type' => 'select',
						'title' => esc_html__( 'Button Type', 'movedo' ),
						'subtitle' => esc_html__( 'Select the type of your Buttons.', 'movedo' ),
						'options' => $movedo_grve_button_type_selection,
						'default' => 'simple',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'button_shape',
						'type' => 'select',
						'title' => esc_html__( 'Button Shape', 'movedo' ),
						'subtitle' => esc_html__( 'Select the shape of your Buttons.', 'movedo' ),
						'options' => $movedo_grve_button_shape_selection,
						'default' => 'square',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'button_color',
						'type' => 'select',
						'title' => esc_html__( 'Button Color', 'movedo' ),
						'subtitle' => esc_html__( 'Select the color of your Buttons.', 'movedo' ),
						'options' => $movedo_grve_button_color_selection,
						'default' => 'primary-1',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'button_hover_color',
						'type' => 'select',
						'title' => esc_html__( 'Button Hover Color', 'movedo' ),
						'subtitle' => esc_html__( 'Select the hover color of your Buttons.', 'movedo' ),
						'options' => $movedo_grve_button_color_selection,
						'default' => 'black',
						'validate' => 'not_empty',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cog',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Back To Top', 'movedo' ),
				'desc' => esc_html__( 'Set the style for the back to top button.', 'movedo' ),
				'id' => 'grve_redux_section_back_top_top',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'=>'back_to_top_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Back to Top', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Back to Top button.', 'movedo' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id'=>'back_to_top_shape',
						'type' => 'select',
						'title' => esc_html__( 'Back to Top Icon Shape', 'movedo' ),
						'subtitle' => esc_html__( 'Select the shape of Back to Top button.', 'movedo' ),
						'options' => array(
							'none' => esc_html__( 'No Shape', 'movedo' ),
							'square' => esc_html__( 'Square', 'movedo' ),
							'round' => esc_html__( 'Round', 'movedo' ),
							'circle' => esc_html__( 'Circle', 'movedo' ),
						),
						'default' => 'none',
						'validate' => 'not_empty',
						'required' => array( 'back_to_top_enabled', 'equals', '1' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cog',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Meta Tags', 'movedo' ),
				'desc' => esc_html__( 'Configure your site meta tags.', 'movedo' ),
				'id' => 'grve_redux_section_meta_tags',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'=>'meta_viewport_responsive',
						'type' => 'switch',
						'title' => esc_html__( 'Responsive Viewport Meta', 'movedo' ),
						'subtitle'=> esc_html__( 'Enable or Disable Responsive Viewport.', 'movedo' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id'=>'meta_opengraph',
						'type' => 'switch',
						'title' => esc_html__( 'Open Graph Meta', 'movedo' ),
						'subtitle'=> esc_html__( 'Generate open graph meta tags for social sharing ( e.g: Facebook, Google+, LinkedIn etc )', 'movedo' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id'=>'meta_twitter',
						'type' => 'switch',
						'title' => esc_html__( 'Twitter Card Meta', 'movedo' ),
						'subtitle'=> esc_html__( 'Generate meta tags for Twitter', 'movedo' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-wrench',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Coming Soon', 'movedo' ),
				'id' => 'grve_redux_section_coming_soon',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'coming_soon_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Enable Coming Soon', 'movedo' ),
						'subtitle'=> esc_html__( 'Toggle Coming Soon Redirect on or off.', 'movedo' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'movedo' ),
						'off' => esc_html__( 'Off', 'movedo' ),
					),
					array(
						'id'=>'coming_soon_template',
						'type' => 'select',
						'title' => esc_html__( 'Coming Soon Template', 'movedo' ),
						'subtitle' => esc_html__( 'Select content only or use the defined page template.', 'movedo' ),
						'options' => array(
							'content' => esc_html__( 'Content Only', 'movedo' ),
							'template' => esc_html__( 'Use Page Template', 'movedo' ),
						),
						'default' => 'content',
						'validate' => 'not_empty',
						'required' => array( 'coming_soon_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'coming_soon_page',
						'type' => 'select',
						'title' => esc_html__( 'Coming Soon Page', 'movedo' ),
						'subtitle' => esc_html__( 'Select the page for your redirection.', 'movedo' ),
						'data' => 'page',
						'default' => '',
						'required' => array( 'coming_soon_enabled', 'equals', '1' ),
					),

				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-resize-small',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Media Sizes', 'movedo' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'feature_section_bg_size',
						'type' => 'select',
						'title' => esc_html__( 'Feature Section Background Image Size', 'movedo' ),
						'subtitle' => esc_html__( 'Select what background image to show for Feture Sections.', 'movedo' ),
						'options' => array(
							'responsive' => esc_html__( 'Responsive', 'movedo' ),
							'extra-extra-large' => esc_html__( 'Extra Extra Large', 'movedo' ),
							'full' => esc_html__( 'Full', 'movedo' ),
						),
						'default' => 'responsive',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'row_section_bg_size',
						'type' => 'select',
						'title' => esc_html__( 'Row Section Background Image Size', 'movedo' ),
						'subtitle' => esc_html__( 'Select what background image to show for Row Sections.', 'movedo' ),
						'options' => array(
							'responsive' => esc_html__( 'Responsive', 'movedo' ),
							'extra-extra-large' => esc_html__( 'Extra Extra Large', 'movedo' ),
							'full' => esc_html__( 'Full', 'movedo' ),
						),
						'default' => 'responsive',
						'validate' => 'not_empty',
					),
				)
			);
			if ( !defined('ENVATO_HOSTED_SITE') ) {
				$this->sections[] = array(
					'icon' => 'el-icon-repeat',
					'icon_class' => 'el-icon-large',
					'title' => esc_html__( 'Theme Update', 'movedo' ),
					'id' => 'grve_redux_section_theme_update',
					'submenu' => true,
					'customizer' => false,
					'fields' => array(
						array(
							'id'=>'update_enabled',
							'type' => 'switch',
							'title' => esc_html__( 'Enable Theme Update', 'movedo' ),
							'subtitle'=> esc_html__( 'Toggle Theme update on or off.', 'movedo' ),
							"default" => '0',
							'on' => esc_html__( 'On', 'movedo' ),
							'off' => esc_html__( 'Off', 'movedo' ),
						),
						array(
							'id' => 'update_user_name',
							'type' => 'text',
							'title' => esc_html__( 'Themeforest username', 'movedo' ),
							'subtitle' => esc_html__( 'Enter your Themeforest username here.', 'movedo' ),
							'default' => '',
							'required' => array( 'update_enabled', 'equals', '1' ),
						),
						array(
							'id' => 'update_api_key',
							'type' => 'text',
							'title' => esc_html__( 'Secret API Key', 'movedo' ),
							'subtitle' => esc_html__( 'Enter your Envato API Key here. You will find it under Settings > API Keys in your Envato Account.', 'movedo' ),
							'default' => '',
							'required' => array( 'update_enabled', 'equals', '1' ),
						),
					)
				);
			}

			//Show Sections available only in customizer
			if ( ( defined( 'MOVEDO_GRVE_THEME_REDUX_CUSTOM_PANEL' ) &&  true === MOVEDO_GRVE_THEME_REDUX_CUSTOM_PANEL ) || $this->movedo_grve_redux_customizer_visibility() ) {
				foreach ( $this->sections as $k => $section ) {
					if ( isset( $section['grve_colors'] ) && isset( $section['panel'] ) ) {
						unset($this->sections[$k]['panel']);
					}
				}
			}

		}


		public function setArguments() {

			$theme = wp_get_theme(); // For use with some settings. Not necessary.

			$this->args = array(
				// TYPICAL -> Change these values as you need/desire
				'opt_name' => 'movedo_grve_options', // This is where your data is stored in the database and also becomes your global variable name.
				'display_name' => ' ', // Name that appears at the top of your panel
				'display_version' => $theme->get('Version'), // Version that appears at the top of your panel
				'menu_type' => 'submenu', //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
				'allow_sub_menu' => false, // Show the sections below the admin menu item or not
				'menu_title' => esc_html__( 'Theme Options', 'movedo' ),
				'page' => esc_html__( 'Theme Options', 'movedo' ),
				'google_api_key' => 'AIzaSyBBgve_JGMTPX8CWMxeoG1KrfmUF6WN4NE', // Must be defined to add google fonts to the typography module
				'admin_bar' => false, // Show the panel pages on the admin bar
				'global_variable' => 'movedo_grve_options', // Set a different name for your global variable other than the opt_name
				'dev_mode' => false, // Show the time the page took to load, etc
				'customizer' => true, // Enable basic customizer support
				'ajax_save' => true,
				'ajax_max_input' => true,
				'templates_path' => get_template_directory() . '/includes/admin/templates/panel/', //Redux Template files

				// OPTIONAL -> Give you extra features
				'page_priority' => null, // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
				'page_parent' => 'themes.php', // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
				'page_permissions' => 'manage_options', // Permissions needed to access the options panel.
				'menu_icon' => get_template_directory_uri() .'/includes/images/adminmenu/theme.png', // Specify a custom URL to an icon
				'last_tab' => '', // Force your panel to always open to a specific tab (by id)
				'page_icon' => 'icon-themes', // Icon displayed in the admin panel next to your menu_title
				'page_slug' => 'movedo_grve_options', // Page slug used to denote the panel
				'save_defaults' => true, // On load save the defaults to DB before user clicks save or not
				'default_show' => false, // If true, shows the default value next to each field that is not the default value.
				'default_mark' => '', // What to print by the field's title if the value shown is default. Suggested: *

				// CAREFUL -> These options are for advanced use only
				'use_cdn' => false,
				'transient_time' => 60 * MINUTE_IN_SECONDS,
				'output' => true, // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
				'output_tag' => true, // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head

				// FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
				'database' => '', // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
				'show_import_export' => true,
				'disable_tracking' => true,
				'help_tabs' => array(),
				'help_sidebar' => '',
			);

			// Panel Intro text -> before the form
			$this->args['intro_text'] ='';

			// Add content after the form.
			$this->args['footer_text'] = '';
			$this->args['footer_credit'] = ' ';

		}

	}

	global $movedo_grve_redux_framework;
	$movedo_grve_redux_framework = new Movedo_GRVE_Redux_Framework_config();
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
